/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.infinispan.task;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.impl.AuthorizationHelper;
import org.infinispan.server.infinispan.task.ServerTaskRegistry;
import org.infinispan.server.infinispan.task.ServerTaskRunner;
import org.infinispan.server.infinispan.task.ServerTaskRunnerFactory;
import org.infinispan.server.infinispan.task.ServerTaskWrapper;
import org.infinispan.tasks.Task;
import org.infinispan.tasks.TaskContext;
import org.infinispan.tasks.spi.TaskEngine;

public class ServerTaskEngine
implements TaskEngine {
    private final AuthorizationHelper globalAuthzHelper;
    private final ServerTaskRegistry registry;
    private final ServerTaskRunnerFactory runnerFactory = new ServerTaskRunnerFactory();

    public ServerTaskEngine(ServerTaskRegistry manager, EmbeddedCacheManager cacheManager) {
        this.registry = manager;
        this.globalAuthzHelper = (AuthorizationHelper)cacheManager.getGlobalComponentRegistry().getComponent(AuthorizationHelper.class);
    }

    public String getName() {
        return "Deployed";
    }

    public List<Task> getTasks() {
        return this.registry.getTasks();
    }

    public <T> CompletableFuture<T> runTask(String taskName, TaskContext context) {
        ServerTaskWrapper task = this.registry.getTask(taskName);
        if (task == null) {
            throw new IllegalArgumentException("Task not found: " + taskName);
        }
        this.checkPermissions(context, task);
        return this.invokeTask(context, task);
    }

    private <T> CompletableFuture<T> invokeTask(TaskContext context, ServerTaskWrapper<T> task) {
        ServerTaskRunner runner = this.runnerFactory.getRunner(task.getExecutionMode());
        return runner.execute(task.getName(), context);
    }

    private <T> void checkPermissions(TaskContext context, ServerTaskWrapper<T> task) {
        String role = task.getRole().orElse(null);
        if (this.globalAuthzHelper != null) {
            AuthorizationManager authorizationManager;
            if (context.getCache().isPresent() && (authorizationManager = ((Cache)context.getCache().get()).getAdvancedCache().getAuthorizationManager()) != null) {
                authorizationManager.checkPermission(AuthorizationPermission.EXEC, role);
                return;
            }
            this.globalAuthzHelper.checkPermission(null, AuthorizationPermission.EXEC, role);
        }
    }

    public boolean handles(String taskName) {
        return this.registry.handles(taskName);
    }
}

