/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.integration;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Map;
import org.apache.activemq.artemis.core.config.FileDeploymentManager;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.dto.ServerDTO;
import org.apache.activemq.artemis.integration.Broker;
import org.apache.activemq.artemis.integration.bootstrap.ActiveMQBootstrapLogger;
import org.apache.activemq.artemis.jms.server.config.impl.FileJMSConfiguration;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;

public class FileBroker
implements Broker {
    private final String configurationUrl;
    private boolean started;
    private final ActiveMQSecurityManager securityManager;
    private Map<String, ActiveMQComponent> components;

    public FileBroker(ServerDTO broker, ActiveMQSecurityManager security) {
        this.securityManager = security;
        this.configurationUrl = broker.configuration;
    }

    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        FileConfiguration configuration = new FileConfiguration();
        FileJMSConfiguration jmsConfiguration = new FileJMSConfiguration();
        FileDeploymentManager fileDeploymentManager = new FileDeploymentManager(this.configurationUrl);
        fileDeploymentManager.addDeployable((Deployable)configuration).addDeployable((Deployable)jmsConfiguration);
        fileDeploymentManager.readConfiguration();
        this.components = fileDeploymentManager.buildService(this.securityManager, ManagementFactory.getPlatformMBeanServer());
        ArrayList<ActiveMQComponent> componentsByStartOrder = this.getComponentsByStartOrder(this.components);
        ActiveMQBootstrapLogger.LOGGER.serverStarting();
        for (ActiveMQComponent component : componentsByStartOrder) {
            component.start();
        }
        this.started = true;
    }

    public void stop() throws Exception {
        if (!this.started) {
            return;
        }
        ActiveMQComponent[] mqComponents = new ActiveMQComponent[this.components.size()];
        this.components.values().toArray(mqComponents);
        for (int i = mqComponents.length - 1; i >= 0; --i) {
            mqComponents[i].stop();
        }
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }

    public Map<String, ActiveMQComponent> getComponents() {
        return this.components;
    }

    public ArrayList<ActiveMQComponent> getComponentsByStartOrder(Map<String, ActiveMQComponent> components) {
        ArrayList<ActiveMQComponent> activeMQComponents = new ArrayList<ActiveMQComponent>();
        ActiveMQComponent jmsComponent = components.get("jms");
        if (jmsComponent != null) {
            activeMQComponents.add(jmsComponent);
        }
        activeMQComponents.add(components.get("core"));
        return activeMQComponents;
    }
}

