/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.interfaces.InetAddressUtil;
import org.jboss.as.host.controller.HostControllerBootstrap;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.SystemExiter;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.process.CommandLineArgumentUsageImpl;
import org.jboss.as.process.protocol.StreamUtils;
import org.jboss.as.process.stdin.Base64InputStream;
import org.jboss.as.version.ProductConfig;
import org.jboss.logging.MDC;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.handlers.ConsoleHandler;
import org.jboss.modules.Module;
import org.jboss.stdio.LoggingOutputStream;
import org.jboss.stdio.NullInputStream;
import org.jboss.stdio.SimpleStdioContextSelector;
import org.jboss.stdio.StdioContext;
import org.jboss.stdio.StdioContextSelector;
import org.wildfly.security.manager.WildFlySecurityManager;

public final class Main {
    private static final PrintStream STDOUT = System.out;
    private static final PrintStream STDERR = System.err;
    private static final String PROCESS_NAME = "-D[Host Controller]";

    public static void main(String[] args) throws IOException {
        MDC.put((String)"process", (Object)"host controller");
        InputStream in = System.in;
        byte[] authKey = new byte[24];
        try {
            StreamUtils.readFully((InputStream)new Base64InputStream(System.in), (byte[])authKey);
        }
        catch (IOException e) {
            STDERR.println(HostControllerLogger.ROOT_LOGGER.failedToReadAuthenticationKey(e));
            Main.fail();
            return;
        }
        try {
            Class.forName(ConsoleHandler.class.getName(), true, ConsoleHandler.class.getClassLoader());
        }
        catch (Throwable e) {
            // empty catch block
        }
        StdioContext.install();
        StdioContext context = StdioContext.create((InputStream)new NullInputStream(), (OutputStream)new LoggingOutputStream((java.util.logging.Logger)Logger.getLogger((String)"stdout"), (Level)org.jboss.logmanager.Level.INFO), (OutputStream)new LoggingOutputStream((java.util.logging.Logger)Logger.getLogger((String)"stderr"), (Level)org.jboss.logmanager.Level.ERROR));
        StdioContext.setStdioContextSelector((StdioContextSelector)new SimpleStdioContextSelector(context));
        Main.create(args, new String(authKey, Charset.forName("US-ASCII")));
        while (in.read() != -1) {
        }
        Main.exit();
    }

    private Main() {
    }

    public static HostControllerBootstrap create(String[] args, String authCode) {
        Main main = new Main();
        return main.boot(args, authCode);
    }

    /*
     * Loose catch block
     */
    private HostControllerBootstrap boot(String[] args, String authCode) {
        HostControllerEnvironment config;
        block5: {
            long startTime = Module.getStartTime();
            config = Main.determineEnvironment(args, startTime);
            if (config != null) break block5;
            Main.usage();
            Main.abort();
            return null;
            {
                catch (Throwable t) {
                    Main.abort(t);
                    return null;
                }
            }
        }
        try {
            HostControllerBootstrap hc = new HostControllerBootstrap(config, authCode);
            hc.bootstrap();
            return hc;
        }
        catch (Throwable t) {
            Main.abort(t);
            return null;
        }
    }

    private static void abort(Throwable t) {
        try {
            if (t != null) {
                t.printStackTrace();
            }
        }
        finally {
            Main.abort();
        }
    }

    private static void abort() {
        SystemExiter.exit(99);
    }

    private static void exit() {
        SystemExiter.exit(0);
    }

    private static void fail() {
        SystemExiter.exit(1);
    }

    private static void usage() {
        CommandLineArgumentUsageImpl.printUsage((PrintStream)STDOUT);
    }

    public static HostControllerEnvironment determineEnvironment(String[] args, long startTime) {
        Integer pmPort = null;
        InetAddress pmAddress = null;
        PCSocketConfig pcSocketConfig = new PCSocketConfig();
        String defaultJVM = null;
        boolean isRestart = false;
        boolean backupDomainFiles = false;
        boolean cachedDc = false;
        String domainConfig = null;
        String initialDomainConfig = null;
        String hostConfig = null;
        String initialHostConfig = null;
        RunningMode initialRunningMode = RunningMode.NORMAL;
        Map<String, String> hostSystemProperties = Main.getHostSystemProperties();
        String modulePath = null;
        boolean securityManagerEnabled = System.getSecurityManager() != null || hostSystemProperties.containsKey("java.security.manager");
        int argsLength = args.length;
        for (int i = 0; i < argsLength; ++i) {
            String arg = args[i];
            try {
                String value;
                if (PROCESS_NAME.equals(arg)) continue;
                if ("--properties".equals(arg) || "-properties".equals(arg) || "-P".equals(arg)) {
                    if (Main.processProperties(arg, args[++i], hostSystemProperties)) continue;
                    return null;
                }
                if (arg.startsWith("--properties")) {
                    String urlSpec = Main.parseValue(arg, "--properties");
                    if (urlSpec != null && Main.processProperties(arg, urlSpec, hostSystemProperties)) continue;
                    return null;
                }
                if (arg.startsWith("-P")) {
                    String urlSpec = Main.parseValue(arg, "-P");
                    if (urlSpec != null && Main.processProperties(arg, urlSpec, hostSystemProperties)) continue;
                    return null;
                }
                if (arg.startsWith("-properties")) {
                    String urlSpec = Main.parseValue(arg, "-properties");
                    if (urlSpec != null && Main.processProperties(arg, urlSpec, hostSystemProperties)) continue;
                    return null;
                }
                if ("--pc-port".equals(arg)) {
                    String port = args[++i];
                    try {
                        pmPort = Integer.valueOf(port);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        STDERR.println(HostControllerLogger.ROOT_LOGGER.invalidValue("--pc-port", "Integer", port, Main.usageNote()));
                        return null;
                    }
                }
                if (arg.startsWith("--pc-port")) {
                    String val = Main.parseValue(arg, "--pc-port");
                    if (val == null) {
                        return null;
                    }
                    Integer port = Main.parsePort(val, "--pc-port");
                    if (port == null) {
                        return null;
                    }
                    pmPort = port;
                    continue;
                }
                if ("--pc-address".equals(arg)) {
                    String addr = args[++i];
                    try {
                        pmAddress = InetAddress.getByName(addr);
                        continue;
                    }
                    catch (UnknownHostException e) {
                        STDERR.println(HostControllerLogger.ROOT_LOGGER.unknownHostValue("--pc-address", addr, Main.usageNote()));
                        return null;
                    }
                }
                if (arg.startsWith("--pc-address")) {
                    String val = Main.parseValue(arg, "--pc-address");
                    if (val == null) {
                        return null;
                    }
                    InetAddress addr = Main.parseAddress(val, arg);
                    if (addr == null) {
                        return null;
                    }
                    pmAddress = addr;
                    continue;
                }
                if (pcSocketConfig.processPCSocketConfigArgument(arg, args, i)) {
                    if (pcSocketConfig.isParseFailed()) {
                        return null;
                    }
                    i += pcSocketConfig.getArgIncrement();
                    continue;
                }
                if ("--process-restarted".equals(arg)) {
                    isRestart = true;
                    continue;
                }
                if ("--backup".equals(arg) || "-backup".equals(arg)) {
                    backupDomainFiles = true;
                    continue;
                }
                if ("--cached-dc".equals(arg) || "-cached-dc".equals(arg)) {
                    cachedDc = true;
                    continue;
                }
                if ("--default-jvm".equals(arg) || "-default-jvm".equals(arg)) {
                    if ((defaultJVM = Main.checkValueIsNotAnArg(arg, args[++i])) != null) continue;
                    return null;
                }
                if ("--domain-config".equals(arg) || "-c".equals(arg) || "-domain-config".equals(arg)) {
                    if ((domainConfig = Main.checkValueIsNotAnArg(arg, args[++i])) != null) continue;
                    return null;
                }
                if (arg.startsWith("--domain-config")) {
                    String val = Main.parseValue(arg, "--domain-config");
                    if (val == null) {
                        return null;
                    }
                    domainConfig = val;
                    continue;
                }
                if (arg.startsWith("-c")) {
                    String val = Main.parseValue(arg, "-c");
                    if (val == null) {
                        return null;
                    }
                    domainConfig = val;
                    continue;
                }
                if (arg.startsWith("-domain-config")) {
                    String val = Main.parseValue(arg, "-domain-config");
                    if (val == null) {
                        return null;
                    }
                    domainConfig = val;
                    continue;
                }
                if (arg.startsWith("--read-only-domain-config")) {
                    initialDomainConfig = Main.parseValue(arg, "--read-only-domain-config");
                    if (initialDomainConfig != null) continue;
                    return null;
                }
                if ("--host-config".equals(arg) || "-host-config".equals(arg)) {
                    if ((hostConfig = Main.checkValueIsNotAnArg(arg, args[++i])) != null) continue;
                    return null;
                }
                if (arg.startsWith("--host-config")) {
                    String val = Main.parseValue(arg, "--host-config");
                    if (val == null) {
                        return null;
                    }
                    hostConfig = val;
                    continue;
                }
                if (arg.startsWith("-host-config")) {
                    String val = Main.parseValue(arg, "-host-config");
                    if (val == null) {
                        return null;
                    }
                    hostConfig = val;
                    continue;
                }
                if (arg.startsWith("--read-only-host-config")) {
                    initialHostConfig = Main.parseValue(arg, "--read-only-host-config");
                    if (initialHostConfig != null) continue;
                    return null;
                }
                if (arg.startsWith("--master-address")) {
                    int idx = arg.indexOf(61);
                    if (idx == arg.length() - 1) {
                        STDERR.println(HostControllerLogger.ROOT_LOGGER.argumentExpected(arg, Main.usageNote()));
                        return null;
                    }
                    String string = value = idx > -1 ? arg.substring(idx + 1) : Main.checkValueIsNotAnArg(arg, args[++i]);
                    if (value == null) {
                        return null;
                    }
                    value = Main.fixPossibleIPv6URL(value);
                    hostSystemProperties.put("jboss.domain.master.address", value);
                    WildFlySecurityManager.setPropertyPrivileged((String)"jboss.domain.master.address", (String)value);
                    continue;
                }
                if (arg.startsWith("--master-port")) {
                    int idx = arg.indexOf(61);
                    if (idx == arg.length() - 1) {
                        STDERR.println(HostControllerLogger.ROOT_LOGGER.argumentExpected(arg, Main.usageNote()));
                        return null;
                    }
                    value = idx > -1 ? arg.substring(idx + 1) : args[++i];
                    Integer port = Main.parsePort(value, "--master-port");
                    if (port == null) {
                        return null;
                    }
                    hostSystemProperties.put("jboss.domain.master.port", value);
                    WildFlySecurityManager.setPropertyPrivileged((String)"jboss.domain.master.port", (String)value);
                    continue;
                }
                if ("--admin-only".equals(arg)) {
                    initialRunningMode = RunningMode.ADMIN_ONLY;
                    continue;
                }
                if (arg.startsWith("-D")) {
                    String name;
                    int idx = arg.indexOf("=");
                    if (idx == -1) {
                        name = arg.substring(2);
                        value = "true";
                    } else {
                        name = arg.substring(2, idx);
                        value = arg.substring(idx + 1, arg.length());
                    }
                    if (!"java.security.manager".equals(name)) {
                        WildFlySecurityManager.setPropertyPrivileged((String)name, (String)value);
                        hostSystemProperties.put(name, value);
                    }
                    continue;
                }
                if (arg.startsWith("-b")) {
                    int idx = arg.indexOf(61);
                    if (idx == arg.length() - 1) {
                        STDERR.println(HostControllerLogger.ROOT_LOGGER.argumentExpected(arg, Main.usageNote()));
                        return null;
                    }
                    String string = value = idx > -1 ? arg.substring(idx + 1) : Main.checkValueIsNotAnArg(arg, args[++i]);
                    if (value == null) {
                        return null;
                    }
                    value = Main.fixPossibleIPv6URL(value);
                    String propertyName = idx < 0 ? (arg.length() == 2 ? "jboss.bind.address" : "jboss.bind.address." + arg.substring(2)) : (idx == 2 ? "jboss.bind.address" : "jboss.bind.address." + arg.substring(2, idx));
                    hostSystemProperties.put(propertyName, value);
                    WildFlySecurityManager.setPropertyPrivileged((String)propertyName, (String)value);
                    continue;
                }
                if (arg.startsWith("-u")) {
                    int idx = arg.indexOf(61);
                    if (idx == arg.length() - 1) {
                        STDERR.println(HostControllerLogger.ROOT_LOGGER.argumentExpected(arg, Main.usageNote()));
                        return null;
                    }
                    String string = value = idx > -1 ? arg.substring(idx + 1) : Main.checkValueIsNotAnArg(arg, args[++i]);
                    if (value == null) {
                        return null;
                    }
                    value = Main.fixPossibleIPv6URL(value);
                    hostSystemProperties.put("jboss.default.multicast.address", value);
                    WildFlySecurityManager.setPropertyPrivileged((String)"jboss.default.multicast.address", (String)value);
                    continue;
                }
                if (arg.equals("-mp")) {
                    if ((modulePath = Main.checkValueIsNotAnArg(arg, args[++i])) != null) continue;
                    return null;
                }
                if (arg.equals("-secmgr")) {
                    securityManagerEnabled = true;
                    continue;
                }
                STDERR.println(HostControllerLogger.ROOT_LOGGER.invalidOption(arg, Main.usageNote()));
                return null;
            }
            catch (IndexOutOfBoundsException e) {
                STDERR.println(HostControllerLogger.ROOT_LOGGER.argumentExpected(arg, Main.usageNote()));
                return null;
            }
        }
        ProductConfig productConfig = new ProductConfig(Module.getBootModuleLoader(), WildFlySecurityManager.getPropertyPrivileged((String)"jboss.home.dir", null), hostSystemProperties);
        return new HostControllerEnvironment(hostSystemProperties, isRestart, modulePath, pmAddress, pmPort, pcSocketConfig.getBindAddress(), pcSocketConfig.getBindPort(), defaultJVM, domainConfig, initialDomainConfig, hostConfig, initialHostConfig, initialRunningMode, backupDomainFiles, cachedDc, productConfig, securityManagerEnabled, startTime, ProcessType.HOST_CONTROLLER);
    }

    private static String parseValue(String arg, String key) {
        int splitPos = key.length();
        if (arg.length() <= splitPos + 1 || arg.charAt(splitPos) != '=') {
            STDERR.println(HostControllerLogger.ROOT_LOGGER.argumentHasNoValue(arg, Main.usageNote()));
            return null;
        }
        return arg.substring(splitPos + 1);
    }

    private static String checkValueIsNotAnArg(String argument, String value) {
        if (value.startsWith("-")) {
            STDERR.println(HostControllerLogger.ROOT_LOGGER.argumentHasNoValue(argument, Main.usageNote()));
            return null;
        }
        return value;
    }

    private static boolean processProperties(String arg, String urlSpec, Map<String, String> hostSystemProperties) {
        URL url = null;
        try {
            url = Main.makeURL(urlSpec);
            Properties props = new Properties();
            props.load(url.openConnection().getInputStream());
            WildFlySecurityManager.getSystemPropertiesPrivileged().putAll((Map<?, ?>)props);
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                hostSystemProperties.put((String)entry.getKey(), (String)entry.getValue());
            }
            return true;
        }
        catch (MalformedURLException e) {
            STDERR.println(HostControllerLogger.ROOT_LOGGER.malformedUrl(arg, Main.usageNote()));
            return false;
        }
        catch (IOException e) {
            STDERR.println(HostControllerLogger.ROOT_LOGGER.unableToLoadProperties(url, Main.usageNote()));
            return false;
        }
    }

    private static Integer parsePort(String value, String key) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            STDERR.println(HostControllerLogger.ROOT_LOGGER.invalidValue(key, "Integer", value, Main.usageNote()));
            return null;
        }
    }

    private static InetAddress parseAddress(String value, String key) {
        try {
            return InetAddress.getByName(value);
        }
        catch (UnknownHostException e) {
            STDERR.println(HostControllerLogger.ROOT_LOGGER.unknownHostValue(key, value, Main.usageNote()));
            return null;
        }
    }

    private static String fixPossibleIPv6URL(String val) {
        String result = val;
        if (val != null && val.length() > 2 && val.charAt(0) == '[' && val.charAt(val.length() - 1) == ']' && val.contains(":")) {
            result = val.substring(1, val.length() - 1);
        }
        return result;
    }

    private static URL makeURL(String urlspec) throws MalformedURLException {
        URL url;
        urlspec = urlspec.trim();
        try {
            url = new URL(urlspec);
            if (url.getProtocol().equals("file")) {
                File file = new File(url.getFile()).getCanonicalFile();
                url = file.toURI().toURL();
            }
        }
        catch (Exception e) {
            try {
                File file = new File(urlspec).getCanonicalFile();
                url = file.toURI().toURL();
            }
            catch (Exception n) {
                throw new MalformedURLException(n.toString());
            }
        }
        return url;
    }

    private static Map<String, String> getHostSystemProperties() {
        HashMap<String, String> hostSystemProperties = new HashMap<String, String>();
        try {
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            for (String arg : runtime.getInputArguments()) {
                String val;
                String[] split;
                if (arg == null || arg.length() <= 2 || !arg.startsWith("-D") || hostSystemProperties.containsKey((split = (arg = arg.substring(2)).split("="))[0])) continue;
                if (split.length == 1) {
                    val = null;
                } else if (split.length == 2) {
                    val = split[1];
                } else {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 2; i < split.length; ++i) {
                        sb.append("=");
                    }
                    sb.append(split[split.length - 1]);
                    val = sb.toString();
                }
                hostSystemProperties.put(split[0], val);
            }
        }
        catch (Exception e) {
            STDERR.println(HostControllerLogger.ROOT_LOGGER.cannotAccessJvmInputArgument(e));
        }
        return hostSystemProperties;
    }

    private static String usageNote() {
        boolean isWindows = WildFlySecurityManager.getPropertyPrivileged((String)"os.name", null).toLowerCase(Locale.ENGLISH).contains("windows");
        String command = isWindows ? "domain" : "domain.sh";
        return HostControllerLogger.ROOT_LOGGER.usageNote(command);
    }

    private static class PCSocketConfig {
        private final String defaultBindAddress;
        private InetAddress bindAddress;
        private int bindPort = 0;
        private int argIncrement = 0;
        private boolean parseFailed;
        private final UnknownHostException uhe;

        private PCSocketConfig() {
            boolean preferIPv6 = Boolean.valueOf(WildFlySecurityManager.getPropertyPrivileged((String)"java.net.preferIPv6Addresses", (String)"false"));
            this.defaultBindAddress = preferIPv6 ? "::1" : "127.0.0.1";
            UnknownHostException toCache = null;
            try {
                this.bindAddress = InetAddress.getByName(this.defaultBindAddress);
            }
            catch (UnknownHostException e) {
                try {
                    this.bindAddress = InetAddressUtil.getLocalHost();
                }
                catch (UnknownHostException uhe) {
                    toCache = uhe;
                }
            }
            this.uhe = toCache;
        }

        private InetAddress getBindAddress() {
            if (this.bindAddress == null) {
                throw HostControllerLogger.ROOT_LOGGER.cannotObtainValidDefaultAddress(this.uhe, this.defaultBindAddress, "--interprocess-hc-address");
            }
            return this.bindAddress;
        }

        private int getBindPort() {
            return this.bindPort;
        }

        private int getArgIncrement() {
            return this.argIncrement;
        }

        private boolean isParseFailed() {
            return this.parseFailed;
        }

        private boolean processPCSocketConfigArgument(String arg, String[] args, int index) {
            boolean isPCSocketArg = true;
            this.argIncrement = 0;
            if ("--interprocess-hc-address".equals(arg) || "-interprocess-hc-address".equals(arg)) {
                this.setBindAddress(arg, args[index + 1]);
                this.argIncrement = 1;
            } else if (arg.startsWith("--interprocess-hc-address")) {
                String addr = Main.parseValue(arg, "--interprocess-hc-address");
                if (addr == null) {
                    this.parseFailed = true;
                } else {
                    this.setBindAddress(arg, addr);
                }
            } else if (arg.startsWith("-interprocess-hc-address")) {
                String addr = Main.parseValue(arg, "-interprocess-hc-address");
                if (addr == null) {
                    this.parseFailed = true;
                } else {
                    this.setBindAddress(arg, addr);
                }
            } else if ("--interprocess-hc-port".equals(arg) || "-interprocess-hc-port".equals(arg)) {
                this.bindPort = Integer.parseInt(args[index + 1]);
                this.argIncrement = 1;
            } else if (arg.startsWith("--interprocess-hc-port")) {
                String port = Main.parseValue(arg, "--interprocess-hc-port");
                if (port == null) {
                    this.parseFailed = true;
                } else {
                    this.bindPort = Integer.parseInt(port);
                }
            } else if (arg.startsWith("-interprocess-hc-port")) {
                String port = Main.parseValue(arg, "-interprocess-hc-port");
                if (port == null) {
                    this.parseFailed = true;
                } else {
                    this.bindPort = Integer.parseInt(port);
                }
            } else {
                isPCSocketArg = false;
            }
            return isPCSocketArg;
        }

        private void setBindAddress(String key, String value) {
            try {
                this.bindAddress = InetAddress.getByName(value);
            }
            catch (UnknownHostException e) {
                this.parseFailed = true;
                STDERR.println(HostControllerLogger.ROOT_LOGGER.invalidValue(key, "InetAddress", value, Main.usageNote()));
            }
        }
    }
}

