/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.iiop.openjdk.rmi.ir;

import org.omg.CORBA.DefinitionKind;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.wildfly.iiop.openjdk.logging.IIOPLogger;
import org.wildfly.iiop.openjdk.rmi.ir.IRObjectImpl;
import org.wildfly.iiop.openjdk.rmi.ir.LocalIDLType;
import org.wildfly.iiop.openjdk.rmi.ir.PrimitiveDefImpl;
import org.wildfly.iiop.openjdk.rmi.ir.RepositoryImpl;

abstract class IDLTypeImpl
extends IRObjectImpl
implements LocalIDLType {
    private TypeCode typeCode;

    IDLTypeImpl(TypeCode typeCode, DefinitionKind def_kind, RepositoryImpl repository) {
        super(def_kind, repository);
        this.typeCode = typeCode;
    }

    public TypeCode type() {
        return this.typeCode;
    }

    static LocalIDLType getIDLType(TypeCode typeCode, RepositoryImpl repository) {
        TCKind tcKind = typeCode.kind();
        if (PrimitiveDefImpl.isPrimitiveTCKind(tcKind)) {
            return new PrimitiveDefImpl(typeCode, repository);
        }
        if (tcKind == TCKind.tk_sequence) {
            return repository.getSequenceImpl(typeCode);
        }
        if (tcKind == TCKind.tk_value || tcKind == TCKind.tk_value_box || tcKind == TCKind.tk_alias || tcKind == TCKind.tk_struct || tcKind == TCKind.tk_union || tcKind == TCKind.tk_enum || tcKind == TCKind.tk_objref) {
            try {
                return (LocalIDLType)((Object)repository._lookup_id(typeCode.id()));
            }
            catch (BadKind ex) {
                throw IIOPLogger.ROOT_LOGGER.badKindForTypeCode(tcKind.value());
            }
        }
        throw IIOPLogger.ROOT_LOGGER.badKindForTypeCode(tcKind.value());
    }

    @Override
    protected byte[] getObjectId() {
        return this.repository.getNextObjectId();
    }
}

