/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.query.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.AttributeNode;
import javax.persistence.EntityGraph;
import javax.persistence.Subgraph;
import org.hibernate.QueryException;
import org.hibernate.engine.internal.JoinSequence;
import org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.hibernate.hql.internal.ast.tree.FromClause;
import org.hibernate.hql.internal.ast.tree.FromElement;
import org.hibernate.hql.internal.ast.tree.FromElementFactory;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.sql.JoinType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class EntityGraphQueryHint {
    private final EntityGraph<?> originEntityGraph;

    public EntityGraphQueryHint(EntityGraph<?> originEntityGraph) {
        this.originEntityGraph = originEntityGraph;
    }

    public List<FromElement> toFromElements(FromClause fromClause, HqlSqlWalker walker) {
        HashMap<String, FromElement> explicitFetches = new HashMap<String, FromElement>();
        for (Object o : fromClause.getFromElements()) {
            FromElement fromElement = (FromElement)o;
            if (fromElement.getRole() == null) continue;
            explicitFetches.put(fromElement.getRole(), fromElement);
        }
        return this.getFromElements(fromClause.getLevel() == 1 ? this.originEntityGraph.getAttributeNodes() : Collections.emptyList(), fromClause.getFromElement(), fromClause, walker, explicitFetches);
    }

    private List<FromElement> getFromElements(List attributeNodes, FromElement origin, FromClause fromClause, HqlSqlWalker walker, Map<String, FromElement> explicitFetches) {
        ArrayList<FromElement> fromElements = new ArrayList<FromElement>();
        for (Object obj : attributeNodes) {
            AttributeNode attributeNode = (AttributeNode)obj;
            String attributeName = attributeNode.getAttributeName();
            String className = origin.getClassName();
            String role = className + "." + attributeName;
            String classAlias = origin.getClassAlias();
            String originTableAlias = origin.getTableAlias();
            Type propertyType = origin.getPropertyType(attributeName, attributeName);
            try {
                FromElement fromElement = explicitFetches.get(role);
                boolean explicitFromElement = false;
                if (fromElement == null) {
                    String[] columns;
                    if (propertyType.isEntityType()) {
                        EntityType entityType = (EntityType)propertyType;
                        columns = origin.toColumns(originTableAlias, attributeName, false);
                        String tableAlias = walker.getAliasGenerator().createName(entityType.getAssociatedEntityName());
                        FromElementFactory fromElementFactory = new FromElementFactory(fromClause, origin, attributeName, classAlias, columns, false);
                        JoinSequence joinSequence = walker.getSessionFactoryHelper().createJoinSequence(false, entityType, tableAlias, JoinType.LEFT_OUTER_JOIN, columns);
                        fromElement = fromElementFactory.createEntityJoin(entityType.getAssociatedEntityName(), tableAlias, joinSequence, true, walker.isInFrom(), entityType, role, null);
                    } else if (propertyType.isCollectionType()) {
                        CollectionType collectionType = (CollectionType)propertyType;
                        columns = origin.toColumns(originTableAlias, attributeName, false);
                        FromElementFactory fromElementFactory = new FromElementFactory(fromClause, origin, attributeName, classAlias, columns, false);
                        QueryableCollection queryableCollection = walker.getSessionFactoryHelper().requireQueryableCollection(collectionType.getRole());
                        fromElement = fromElementFactory.createCollection(queryableCollection, collectionType.getRole(), JoinType.LEFT_OUTER_JOIN, true, false);
                    }
                } else {
                    explicitFromElement = true;
                    fromElement.setInProjectionList(true);
                    fromElement.setFetch(true);
                }
                if (fromElement == null) continue;
                if (!explicitFromElement) {
                    fromElements.add(fromElement);
                }
                for (Subgraph subgraph : attributeNode.getSubgraphs().values()) {
                    fromElements.addAll(this.getFromElements(subgraph.getAttributeNodes(), fromElement, fromClause, walker, explicitFetches));
                }
            }
            catch (Exception e) {
                throw new QueryException("Could not apply the EntityGraph to the Query!", e);
            }
        }
        return fromElements;
    }
}

