/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.filters;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.filters.CustomFilterDefinition;
import org.wildfly.extension.undertow.filters.ErrorPageDefinition;
import org.wildfly.extension.undertow.filters.ExpressionFilterDefinition;
import org.wildfly.extension.undertow.filters.GzipFilter;
import org.wildfly.extension.undertow.filters.ModClusterDefinition;
import org.wildfly.extension.undertow.filters.RequestLimitHandler;
import org.wildfly.extension.undertow.filters.ResponseHeaderFilter;
import org.wildfly.extension.undertow.filters.RewriteFilterDefinition;

public class FilterDefinitions
extends PersistentResourceDefinition {
    public static final FilterDefinitions INSTANCE = new FilterDefinitions();
    private static List<? extends PersistentResourceDefinition> FILTERS = Collections.unmodifiableList(Arrays.asList(RequestLimitHandler.INSTANCE, ResponseHeaderFilter.INSTANCE, GzipFilter.INSTANCE, ErrorPageDefinition.INSTANCE, CustomFilterDefinition.INSTANCE, ModClusterDefinition.INSTANCE, ExpressionFilterDefinition.INSTANCE, RewriteFilterDefinition.INSTANCE));

    private FilterDefinitions() {
        super(UndertowExtension.PATH_FILTERS, (ResourceDescriptionResolver)UndertowExtension.getResolver("filter"), (OperationStepHandler)new AbstractAddStepHandler(), (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Collections.emptySet();
    }

    public List<? extends PersistentResourceDefinition> getChildren() {
        return FILTERS;
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        super.registerChildren(resourceRegistration);
        final PathElement targetPe = RequestLimitHandler.INSTANCE.getPathElement();
        AliasEntry aliasEntry = new AliasEntry(resourceRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{targetPe}))){

            public PathAddress convertToTargetAddress(PathAddress aliasAddress, AliasEntry.AliasContext aliasContext) {
                PathElement pe = aliasAddress.getLastElement();
                return aliasAddress.getParent().append(new PathElement[]{PathElement.pathElement((String)targetPe.getKey(), (String)pe.getValue())});
            }
        };
        resourceRegistration.registerAlias(PathElement.pathElement((String)"connection-limit"), aliasEntry);
    }
}

