/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.affinity;

import java.util.Properties;
import org.apache.lucene.search.similarities.Similarity;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.store.DirectoryProvider;
import org.infinispan.Cache;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.hibernate.search.spi.InfinispanDirectoryProvider;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.query.backend.ComponentRegistryService;

public class ShardIndexManager
extends DirectoryBasedIndexManager {
    public EntityIndexBinding getIndexBinding(Class<?> entityType) {
        return super.getIndexBinding(entityType);
    }

    public void initialize(String indexName, Properties properties, Similarity similarity, WorkerBuildContext buildContext) {
        super.initialize(indexName, properties, similarity, buildContext);
        ServiceManager serviceManager = buildContext.getServiceManager();
        ComponentRegistryService componentRegistryService = (ComponentRegistryService)serviceManager.requestService(ComponentRegistryService.class);
        ComponentRegistry componentRegistry = componentRegistryService.getComponentRegistry();
        Cache cache = (Cache)componentRegistry.getComponent(Cache.class);
        cache.addListener((Object)new TopologyChangeListener());
        this.closeIndexWriter();
    }

    protected DirectoryProvider<?> createDirectoryProvider(String indexName, Properties cfg, WorkerBuildContext buildContext) {
        String shardName = indexName.substring(indexName.lastIndexOf(".") + 1);
        InfinispanDirectoryProvider directoryProvider = new InfinispanDirectoryProvider(Integer.valueOf(shardName).intValue());
        directoryProvider.initialize(indexName, cfg, (BuildContext)buildContext);
        return directoryProvider;
    }

    @Listener
    public class TopologyChangeListener {
        @TopologyChanged
        public void onTopologyChange(TopologyChangedEvent<?, ?> tce) {
            if (!tce.isPre()) {
                ShardIndexManager.this.closeIndexWriter();
            }
        }
    }
}

