/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.eventlogger;

import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.Util;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.FilterConditionContext;
import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.SortOrder;
import org.infinispan.server.eventlogger.DecoratedServerEventLogger;
import org.infinispan.server.eventlogger.ServerEventImpl;
import org.infinispan.util.SerializableFunction;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.util.logging.events.EventLog;
import org.infinispan.util.logging.events.EventLogCategory;
import org.infinispan.util.logging.events.EventLogLevel;
import org.infinispan.util.logging.events.EventLogger;

public class ServerEventLogger
implements EventLogger {
    public static final String EVENT_LOG_CACHE = "___event_log_cache";
    public static final Log log = LogFactory.getLog(ServerEventLogger.class);
    private final EmbeddedCacheManager cacheManager;
    private final TimeService timeService;
    private Cache<UUID, ServerEventImpl> eventCache;

    ServerEventLogger(EmbeddedCacheManager cacheManager, TimeService timeService) {
        this.cacheManager = cacheManager;
        this.timeService = timeService;
    }

    private Cache<UUID, ServerEventImpl> getEventCache() {
        if (this.eventCache == null) {
            this.eventCache = this.cacheManager.getCache(EVENT_LOG_CACHE);
        }
        return this.eventCache;
    }

    public void log(EventLogLevel level, EventLogCategory category, String message) {
        this.textLog(level, category, message);
        this.eventLog(new ServerEventImpl(level, category, this.timeService.instant(), message));
    }

    void textLog(EventLogLevel level, EventLogCategory category, String message) {
        LogFactory.getLogger((String)category.toString()).log(level.toLoggerLevel(), (Object)message);
    }

    void eventLog(ServerEventImpl event) {
        this.getEventCache().putAsync((Object)Util.threadLocalRandomUUID(), (Object)event);
    }

    public EventLogger scope(String scope) {
        return new DecoratedServerEventLogger(this).scope(scope);
    }

    public EventLogger context(String cacheName) {
        return new DecoratedServerEventLogger(this).context(cacheName);
    }

    public EventLogger detail(String detail) {
        return new DecoratedServerEventLogger(this).detail(detail);
    }

    public EventLogger who(String s) {
        return new DecoratedServerEventLogger(this).who(s);
    }

    TimeService getTimeService() {
        return this.timeService;
    }

    public List<EventLog> getEvents(Instant start, int count, Optional<EventLogCategory> category, Optional<EventLogLevel> level) {
        ArrayList events = new ArrayList();
        AtomicReference throwable = new AtomicReference();
        try {
            this.cacheManager.executor().submitConsumer((SerializableFunction & Serializable)m -> {
                Cache cache = m.getCache(EVENT_LOG_CACHE);
                QueryFactory queryFactory = Search.getQueryFactory((Cache)cache);
                QueryBuilder query = queryFactory.from(ServerEventImpl.class).orderBy("when", SortOrder.DESC).maxResults(count);
                FilterConditionContext filter = query.having("when").lte((Object)start);
                category.map(c -> filter.and(queryFactory.having("category").eq(c)));
                level.map(l -> filter.and(queryFactory.having("level").eq(l)));
                List nodeEvents = filter.toBuilder().build().list();
                return nodeEvents;
            }, (address, nodeEvents, t) -> {
                if (t == null) {
                    events.addAll(nodeEvents);
                } else {
                    throwable.set(t);
                }
            }).get(1L, TimeUnit.MINUTES);
            if (throwable.get() != null) {
                throw new CacheException((Throwable)throwable.get());
            }
        }
        catch (Exception e) {
            log.debug((Object)"Could not retrieve events", (Throwable)e);
            throw new CacheException((Throwable)e);
        }
        Collections.sort(events);
        return events.subList(0, Math.min(events.size(), count));
    }
}

