/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.registry.impl;

import java.lang.invoke.MethodHandles;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.Cache;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.registry.impl.SecurityActions;
import org.infinispan.util.concurrent.ConcurrentHashSet;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class InternalCacheRegistryImpl
implements InternalCacheRegistry {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private EmbeddedCacheManager cacheManager;
    private final ConcurrentMap<String, EnumSet<InternalCacheRegistry.Flag>> internalCaches = CollectionFactory.makeBoundedConcurrentMap((int)10);
    private final Set<String> privateCaches = new ConcurrentHashSet<String>();

    @Inject
    public void init(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Stop(priority=1)
    public void stop() {
        this.internalCaches.keySet().forEach(cacheName -> {
            Cache cache = this.cacheManager.getCache((String)cacheName, false);
            if (cache != null) {
                cache.stop();
            }
        });
    }

    @Override
    public void registerInternalCache(String name, Configuration configuration) {
        this.registerInternalCache(name, configuration, EnumSet.noneOf(InternalCacheRegistry.Flag.class));
    }

    @Override
    public void registerInternalCache(String name, Configuration configuration, EnumSet<InternalCacheRegistry.Flag> flags) {
        if ((flags.contains((Object)InternalCacheRegistry.Flag.EXCLUSIVE) || !this.internalCaches.containsKey(name)) && this.cacheManager.getCacheConfiguration(name) != null) {
            throw log.existingConfigForInternalCache(name);
        }
        ConfigurationBuilder builder = new ConfigurationBuilder().read(configuration);
        builder.jmxStatistics().disable();
        GlobalConfiguration globalConfiguration = this.cacheManager.getCacheManagerConfiguration();
        if (flags.contains((Object)InternalCacheRegistry.Flag.PERSISTENT) && globalConfiguration.globalState().enabled()) {
            ((SingleFileStoreConfigurationBuilder)builder.persistence().addSingleFileStore().location(globalConfiguration.globalState().persistentLocation()).purgeOnStartup(false)).preload(true);
        }
        SecurityActions.defineConfiguration(this.cacheManager, name, builder.build());
        this.internalCaches.put(name, flags);
        if (!flags.contains((Object)InternalCacheRegistry.Flag.USER)) {
            this.privateCaches.add(name);
        }
    }

    @Override
    public boolean isInternalCache(String name) {
        return this.internalCaches.containsKey(name);
    }

    @Override
    public Set<String> getInternalCacheNames() {
        return this.internalCaches.keySet();
    }

    @Override
    public void filterPrivateCaches(Set<String> names) {
        names.removeAll(this.privateCaches);
    }

    @Override
    public boolean internalCacheHasFlag(String name, InternalCacheRegistry.Flag flag) {
        EnumSet flags = (EnumSet)this.internalCaches.get(name);
        return flags != null && flags.contains((Object)flag);
    }
}

