/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.mw.wst.common;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.soap.SOAPElement;

public class SOAPUtil {
    public static Iterator getChildElements(SOAPElement soapElement) {
        return new SOAPElementIterator(soapElement.getChildElements());
    }

    private static final class SOAPElementIterator
    implements Iterator {
        private final Iterator elementIter;
        private Object current;

        SOAPElementIterator(Iterator elementIter) {
            this.elementIter = elementIter;
        }

        @Override
        public boolean hasNext() {
            this.checkCurrent();
            return this.current != null;
        }

        public Object next() throws NoSuchElementException {
            this.checkCurrent();
            if (this.current == null) {
                throw new NoSuchElementException("No more elements in iterator");
            }
            Object result = this.current;
            this.current = null;
            return result;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Remove not supported on this iterator");
        }

        private void checkCurrent() {
            if (this.current == null) {
                while (this.elementIter.hasNext()) {
                    Object next = this.elementIter.next();
                    if (!(next instanceof SOAPElement)) continue;
                    this.current = next;
                    break;
                }
            }
        }
    }
}

