/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.jboss.as.clustering.infinispan.subsystem.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.BackupSiteResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.CacheCommands;
import org.jboss.as.clustering.infinispan.subsystem.CacheMetricsHandler;
import org.jboss.as.clustering.infinispan.subsystem.CacheReadAttributeHandler;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanResourceDescriptionResolver;
import org.jboss.as.clustering.infinispan.subsystem.RestartCacheWriteAttributeHandler;
import org.jboss.as.clustering.infinispan.subsystem.RestartableResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.RestartableServiceHandler;
import org.jboss.as.clustering.infinispan.subsystem.TransactionResource;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.services.path.ResolvePathHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class CacheResource
extends SimpleResourceDefinition
implements RestartableResourceDefinition {
    static final SimpleAttributeDefinition CONFIGURATION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("configuration", ModelType.STRING, true).setXmlName(Attribute.CONFIGURATION.getLocalName())).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final AttributeDefinition[] CACHE_ATTRIBUTES = new AttributeDefinition[]{CONFIGURATION};
    static final SimpleAttributeDefinition NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name", ModelType.STRING, true).setXmlName(Attribute.NAME.getLocalName())).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition MIGRATOR_NAME = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("migrator-name", ModelType.STRING, true).setAllowExpression(false)).build();
    static final SimpleAttributeDefinition READ_BATCH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("read-batch", ModelType.INT, true).setAllowExpression(false)).setDefaultValue(new ModelNode().set(1000))).build();
    static final SimpleAttributeDefinition WRITE_THREADS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("write-threads", ModelType.INT, true).setAllowExpression(false)).setDefaultValue(new ModelNode().set(Runtime.getRuntime().availableProcessors()))).build();
    static final OperationDefinition CLEAR_CACHE = new SimpleOperationDefinitionBuilder("clear-cache", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache")).setRuntimeOnly().build();
    static final OperationDefinition FLUSH_CACHE = new SimpleOperationDefinitionBuilder("flush-cache", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache")).setRuntimeOnly().build();
    static final OperationDefinition STOP_CACHE = new SimpleOperationDefinitionBuilder("stop-cache", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache")).setRuntimeOnly().build();
    static final OperationDefinition START_CACHE = new SimpleOperationDefinitionBuilder("start-cache", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache")).setRuntimeOnly().build();
    static final OperationDefinition RESET_STATISTICS = new SimpleOperationDefinitionBuilder("reset-statistics", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache")).setRuntimeOnly().build();
    static final OperationDefinition RESET_ACTIVATION_STATISTICS = new SimpleOperationDefinitionBuilder("reset-activation-statistics", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache")).setRuntimeOnly().build();
    static final OperationDefinition RESET_INVALIDATION_STATISTICS = new SimpleOperationDefinitionBuilder("reset-invalidation-statistics", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache")).setRuntimeOnly().build();
    static final OperationDefinition RESET_PASSIVATION_STATISTICS = new SimpleOperationDefinitionBuilder("reset-passivation-statistics", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache")).setRuntimeOnly().build();
    static final OperationDefinition RESET_RPC_MANAGER_STATISTICS = new SimpleOperationDefinitionBuilder("reset-rpc-manager-statistics", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache")).setRuntimeOnly().build();
    static final OperationDefinition SYNCHRONIZE_DATA = new SimpleOperationDefinitionBuilder("synchronize-data", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache")).setParameters(new AttributeDefinition[]{MIGRATOR_NAME, READ_BATCH, WRITE_THREADS}).setRuntimeOnly().build();
    static final OperationDefinition DISCONNECT_SOURCE = new SimpleOperationDefinitionBuilder("disconnect-source", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache")).setParameters(new AttributeDefinition[]{MIGRATOR_NAME}).setRuntimeOnly().build();
    static final OperationDefinition RECORD_KNOWN_GLOBAL_KEYSET = new SimpleOperationDefinitionBuilder("record-known-global-keyset", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache")).setRuntimeOnly().build();
    static final OperationDefinition MASS_REINDEX = new SimpleOperationDefinitionBuilder("mass-reindex", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache")).setRuntimeOnly().build();
    protected final ResolvePathHandler resolvePathHandler;
    protected final boolean runtimeRegistration;
    private final RestartableServiceHandler serviceInstaller;

    public CacheResource(PathElement pathElement, ResourceDescriptionResolver descriptionResolver, CacheAdd cacheAddHandler, OperationStepHandler removeHandler, ResolvePathHandler resolvePathHandler, boolean runtimeRegistration) {
        super(pathElement, descriptionResolver, (OperationStepHandler)cacheAddHandler, removeHandler);
        this.serviceInstaller = cacheAddHandler;
        this.resolvePathHandler = resolvePathHandler;
        this.runtimeRegistration = runtimeRegistration;
    }

    @Override
    public RestartableServiceHandler getServiceInstaller() {
        return this.serviceInstaller;
    }

    @Override
    public boolean isRuntimeRegistration() {
        return this.runtimeRegistration;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        RestartCacheWriteAttributeHandler restartWriteHandler = new RestartCacheWriteAttributeHandler(this.getPathElement().getKey(), this.serviceInstaller, CACHE_ATTRIBUTES);
        for (AttributeDefinition attr : CACHE_ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attr, (OperationStepHandler)CacheReadAttributeHandler.INSTANCE, (OperationStepHandler)restartWriteHandler);
        }
        if (this.runtimeRegistration) {
            CacheMetricsHandler.INSTANCE.registerCommonMetrics(resourceRegistration);
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler(CLEAR_CACHE, (OperationStepHandler)CacheCommands.ClearCacheCommand.INSTANCE);
        resourceRegistration.registerOperationHandler(FLUSH_CACHE, (OperationStepHandler)CacheCommands.FlushCacheCommand.INSTANCE);
        resourceRegistration.registerOperationHandler(START_CACHE, (OperationStepHandler)CacheCommands.StartCacheCommand.INSTANCE);
        resourceRegistration.registerOperationHandler(STOP_CACHE, (OperationStepHandler)CacheCommands.StopCacheCommand.INSTANCE);
        resourceRegistration.registerOperationHandler(RESET_STATISTICS, (OperationStepHandler)CacheCommands.ResetCacheStatisticsCommand.INSTANCE);
        resourceRegistration.registerOperationHandler(RESET_ACTIVATION_STATISTICS, (OperationStepHandler)CacheCommands.ResetActivationStatisticsCommand.INSTANCE);
        resourceRegistration.registerOperationHandler(RESET_INVALIDATION_STATISTICS, (OperationStepHandler)CacheCommands.ResetInvalidationStatisticsCommand.INSTANCE);
        resourceRegistration.registerOperationHandler(RESET_PASSIVATION_STATISTICS, (OperationStepHandler)CacheCommands.ResetPassivationStatisticsCommand.INSTANCE);
        resourceRegistration.registerOperationHandler(RESET_RPC_MANAGER_STATISTICS, (OperationStepHandler)CacheCommands.ResetRpcManagerStatisticsCommand.INSTANCE);
        resourceRegistration.registerOperationHandler(DISCONNECT_SOURCE, (OperationStepHandler)CacheCommands.DisconnectSourceCommand.INSTANCE);
        resourceRegistration.registerOperationHandler(RECORD_KNOWN_GLOBAL_KEYSET, (OperationStepHandler)CacheCommands.RecordGlobalKeySetCommand.INSTANCE);
        resourceRegistration.registerOperationHandler(SYNCHRONIZE_DATA, (OperationStepHandler)CacheCommands.SynchronizeDataCommand.INSTANCE);
        resourceRegistration.registerOperationHandler(MASS_REINDEX, (OperationStepHandler)CacheCommands.MassReindexCommand.INSTANCE);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        super.registerChildren(resourceRegistration);
        resourceRegistration.registerSubModel((ResourceDefinition)new TransactionResource(this));
        resourceRegistration.registerSubModel((ResourceDefinition)new BackupSiteResource(this));
    }
}

