/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.jms;

import javax.jms.Queue;
import javax.jms.Topic;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQQueueConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQTopicConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQXAConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQXAQueueConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQXATopicConnectionFactory;
import org.apache.activemq.artemis.uri.ConnectionFactoryParser;

public class ActiveMQJMSClient {
    public static ActiveMQConnectionFactory createConnectionFactory(String url, String name) throws Exception {
        ConnectionFactoryParser parser = new ConnectionFactoryParser();
        return (ActiveMQConnectionFactory)parser.newObject(parser.expandURI(url), name);
    }

    public static ActiveMQConnectionFactory createConnectionFactoryWithHA(DiscoveryGroupConfiguration groupConfiguration, JMSFactoryType jmsFactoryType) {
        ActiveMQConnectionFactory factory = null;
        if (jmsFactoryType.equals((Object)JMSFactoryType.CF)) {
            factory = new ActiveMQJMSConnectionFactory(true, groupConfiguration);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.QUEUE_CF)) {
            factory = new ActiveMQQueueConnectionFactory(true, groupConfiguration);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.TOPIC_CF)) {
            factory = new ActiveMQTopicConnectionFactory(true, groupConfiguration);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.XA_CF)) {
            factory = new ActiveMQXAConnectionFactory(true, groupConfiguration);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.QUEUE_XA_CF)) {
            factory = new ActiveMQXAQueueConnectionFactory(true, groupConfiguration);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.TOPIC_XA_CF)) {
            factory = new ActiveMQXATopicConnectionFactory(true, groupConfiguration);
        }
        return factory;
    }

    public static ActiveMQConnectionFactory createConnectionFactoryWithoutHA(DiscoveryGroupConfiguration groupConfiguration, JMSFactoryType jmsFactoryType) {
        ActiveMQConnectionFactory factory = null;
        if (jmsFactoryType.equals((Object)JMSFactoryType.CF)) {
            factory = new ActiveMQJMSConnectionFactory(false, groupConfiguration);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.QUEUE_CF)) {
            factory = new ActiveMQQueueConnectionFactory(false, groupConfiguration);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.TOPIC_CF)) {
            factory = new ActiveMQTopicConnectionFactory(false, groupConfiguration);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.XA_CF)) {
            factory = new ActiveMQXAConnectionFactory(false, groupConfiguration);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.QUEUE_XA_CF)) {
            factory = new ActiveMQXAQueueConnectionFactory(false, groupConfiguration);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.TOPIC_XA_CF)) {
            factory = new ActiveMQXATopicConnectionFactory(false, groupConfiguration);
        }
        return factory;
    }

    public static ActiveMQConnectionFactory createConnectionFactoryWithHA(JMSFactoryType jmsFactoryType, TransportConfiguration ... initialServers) {
        ActiveMQConnectionFactory factory = null;
        if (jmsFactoryType.equals((Object)JMSFactoryType.CF)) {
            factory = new ActiveMQJMSConnectionFactory(true, initialServers);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.QUEUE_CF)) {
            factory = new ActiveMQQueueConnectionFactory(true, initialServers);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.TOPIC_CF)) {
            factory = new ActiveMQTopicConnectionFactory(true, initialServers);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.XA_CF)) {
            factory = new ActiveMQXAConnectionFactory(true, initialServers);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.QUEUE_XA_CF)) {
            factory = new ActiveMQXAQueueConnectionFactory(true, initialServers);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.TOPIC_XA_CF)) {
            factory = new ActiveMQXATopicConnectionFactory(true, initialServers);
        }
        return factory;
    }

    public static ActiveMQConnectionFactory createConnectionFactoryWithoutHA(JMSFactoryType jmsFactoryType, TransportConfiguration ... transportConfigurations) {
        ActiveMQConnectionFactory factory = null;
        if (jmsFactoryType.equals((Object)JMSFactoryType.CF)) {
            factory = new ActiveMQJMSConnectionFactory(false, transportConfigurations);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.QUEUE_CF)) {
            factory = new ActiveMQQueueConnectionFactory(false, transportConfigurations);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.TOPIC_CF)) {
            factory = new ActiveMQTopicConnectionFactory(false, transportConfigurations);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.XA_CF)) {
            factory = new ActiveMQXAConnectionFactory(false, transportConfigurations);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.QUEUE_XA_CF)) {
            factory = new ActiveMQXAQueueConnectionFactory(false, transportConfigurations);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.TOPIC_XA_CF)) {
            factory = new ActiveMQXATopicConnectionFactory(false, transportConfigurations);
        }
        return factory;
    }

    public static Topic createTopic(String name) {
        return ActiveMQDestination.createTopic(name);
    }

    public static Queue createQueue(String name) {
        return ActiveMQDestination.createQueue(name);
    }

    private ActiveMQJMSClient() {
    }
}

