/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.adduser;

import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.adduser.ConfirmationChoice;
import org.jboss.as.domain.management.security.adduser.ConsoleWrapper;
import org.jboss.as.domain.management.security.adduser.DisplaySecret;
import org.jboss.as.domain.management.security.adduser.State;
import org.jboss.as.domain.management.security.adduser.StateValues;
import org.jboss.as.domain.management.security.adduser.UpdatePropertiesHandler;

public class UpdateUser
extends UpdatePropertiesHandler
implements State {
    private final StateValues stateValues;
    private final ConsoleWrapper theConsole;

    public UpdateUser(ConsoleWrapper theConsole, StateValues stateValues) {
        super(theConsole);
        this.theConsole = theConsole;
        this.stateValues = stateValues;
    }

    @Override
    public State execute() {
        State nextState = this.update(this.stateValues);
        if (nextState == null && this.stateValues.isInteractive() && this.stateValues.getPassword() != null) {
            nextState = new ConfirmationChoice(this.theConsole, DomainManagementLogger.ROOT_LOGGER.serverUser(), DomainManagementLogger.ROOT_LOGGER.yesNo(), (State)new DisplaySecret(this.theConsole, this.stateValues), null);
        }
        return nextState;
    }

    @Override
    String consoleUserMessage(String fileName) {
        return DomainManagementLogger.ROOT_LOGGER.updateUser(this.stateValues.getUserName(), fileName);
    }

    @Override
    String consoleGroupsMessage(String fileName) {
        return DomainManagementLogger.ROOT_LOGGER.updatedGroups(this.stateValues.getUserName(), this.stateValues.getGroups(), fileName);
    }

    @Override
    String errorMessage(String fileName, Throwable e) {
        return DomainManagementLogger.ROOT_LOGGER.unableToUpdateUser(fileName, e.getMessage());
    }
}

