/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tasks;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.Marshaller;

public class TaskContext {
    private Optional<Marshaller> marshaller = Optional.empty();
    private Optional<Cache<?, ?>> cache = Optional.empty();
    private Optional<Map<String, ?>> parameters = Optional.empty();
    private boolean logEvent;

    public TaskContext marshaller(Marshaller marshaller) {
        this.marshaller = Optional.of(marshaller);
        return this;
    }

    public TaskContext cache(Cache<?, ?> cache) {
        this.cache = Optional.of(cache);
        return this;
    }

    public TaskContext parameters(Map<String, ?> parameters) {
        this.parameters = Optional.of(parameters);
        return this;
    }

    public TaskContext addParameter(String name, Object value) {
        Map params = this.parameters.orElseGet(() -> new HashMap());
        params.put(name, value);
        return this.parameters(params);
    }

    public TaskContext logEvent(boolean logEvent) {
        this.logEvent = logEvent;
        return this;
    }

    public Optional<Marshaller> getMarshaller() {
        return this.marshaller;
    }

    public Optional<Cache<?, ?>> getCache() {
        return this.cache;
    }

    public Optional<Map<String, ?>> getParameters() {
        return this.parameters;
    }

    public boolean isLogEvent() {
        return this.logEvent;
    }
}

