/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.hql;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.Tree;
import org.hibernate.hql.ast.TypeDescriptor;
import org.hibernate.hql.ast.common.JoinType;
import org.hibernate.hql.ast.origin.hql.resolve.path.PathedPropertyReference;
import org.hibernate.hql.ast.origin.hql.resolve.path.PathedPropertyReferenceSource;
import org.hibernate.hql.ast.origin.hql.resolve.path.PropertyPath;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.QueryResolverDelegate;
import org.infinispan.objectfilter.impl.hql.FilterEmbeddedEntityTypeDescriptor;
import org.infinispan.objectfilter.impl.hql.FilterEntityTypeDescriptor;
import org.infinispan.objectfilter.impl.hql.FilterPropertyTypeDescriptor;
import org.infinispan.objectfilter.impl.hql.FilterTypeDescriptor;
import org.infinispan.objectfilter.impl.hql.ObjectPropertyHelper;
import org.infinispan.objectfilter.impl.logging.Log;
import org.jboss.logging.Logger;

final class FilterQueryResolverDelegate
implements QueryResolverDelegate {
    private static final Log log = (Log)Logger.getMessageLogger(Log.class, (String)FilterQueryResolverDelegate.class.getName());
    private final Map<String, String> aliasToEntityType = new HashMap<String, String>();
    private final ObjectPropertyHelper propertyHelper;
    private final EntityNamesResolver entityNamesResolver;
    private String targetType;
    private boolean definingSelect = false;

    FilterQueryResolverDelegate(EntityNamesResolver entityNamesResolver, ObjectPropertyHelper propertyHelper) {
        this.entityNamesResolver = entityNamesResolver;
        this.propertyHelper = propertyHelper;
    }

    public void registerPersisterSpace(Tree entityNameTree, Tree aliasTree) {
        String entityName;
        String alias = aliasTree.getText();
        String prevAlias = this.aliasToEntityType.put(alias, entityName = entityNameTree.getText());
        if (prevAlias != null && !prevAlias.equalsIgnoreCase(entityName)) {
            throw new UnsupportedOperationException("Alias reuse currently not supported: aliasTree " + alias + " already assigned to type " + prevAlias);
        }
        if (this.entityNamesResolver.getClassFromName(entityName) == null) {
            throw new IllegalStateException("Unknown entity name " + entityName);
        }
        if (this.targetType != null) {
            throw new IllegalStateException("Can't target multiple types: " + this.targetType + " already selected before " + entityName);
        }
        this.targetType = entityName;
    }

    public void registerJoinAlias(Tree alias, PropertyPath path) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isUnqualifiedPropertyReference() {
        return true;
    }

    public PathedPropertyReferenceSource normalizeUnqualifiedPropertyReference(Tree property) {
        if (this.aliasToEntityType.containsKey(property.getText())) {
            return this.normalizeQualifiedRoot(property);
        }
        return this.normalizeProperty(new FilterEntityTypeDescriptor(this.targetType, this.propertyHelper), Collections.emptyList(), property.getText());
    }

    public boolean isPersisterReferenceAlias() {
        return true;
    }

    public PathedPropertyReferenceSource normalizeUnqualifiedRoot(Tree identifier382) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public PathedPropertyReferenceSource normalizeQualifiedRoot(Tree root) {
        String entityNameForAlias = this.aliasToEntityType.get(root.getText());
        if (entityNameForAlias == null) {
            throw log.getUnknownAliasException(root.getText());
        }
        if (this.entityNamesResolver.getClassFromName(entityNameForAlias) == null) {
            throw new IllegalStateException("Unknown entity name " + entityNameForAlias);
        }
        return new PathedPropertyReference(root.getText(), (TypeDescriptor)new FilterEntityTypeDescriptor(entityNameForAlias, this.propertyHelper), true);
    }

    public PathedPropertyReferenceSource normalizePropertyPathIntermediary(PropertyPath path, Tree propertyName) {
        FilterTypeDescriptor sourceType = (FilterTypeDescriptor)path.getLastNode().getType();
        if (!sourceType.hasProperty(propertyName.getText())) {
            throw log.getNoSuchPropertyException(sourceType.toString(), propertyName.getText());
        }
        LinkedList<String> newPath = new LinkedList<String>(path.getNodeNamesWithoutAlias());
        newPath.add(propertyName.getText());
        return new PathedPropertyReference(propertyName.getText(), (TypeDescriptor)new FilterEmbeddedEntityTypeDescriptor(sourceType.getEntityType(), newPath, this.propertyHelper), false);
    }

    public PathedPropertyReferenceSource normalizeIntermediateIndexOperation(PathedPropertyReferenceSource propertyReferenceSource, Tree collectionProperty, Tree selector) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void normalizeTerminalIndexOperation(PathedPropertyReferenceSource propertyReferenceSource, Tree collectionProperty, Tree selector) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public PathedPropertyReferenceSource normalizeUnqualifiedPropertyReferenceSource(Tree identifier394) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public PathedPropertyReferenceSource normalizePropertyPathTerminus(PropertyPath path, Tree propertyNameNode) {
        return this.normalizeProperty((FilterTypeDescriptor)path.getLastNode().getType(), path.getNodeNamesWithoutAlias(), propertyNameNode.getText());
    }

    private PathedPropertyReferenceSource normalizeProperty(FilterTypeDescriptor type, List<String> path, String propertyName) {
        if (!type.hasProperty(propertyName)) {
            throw log.getNoSuchPropertyException(type.toString(), propertyName);
        }
        LinkedList<String> newPath = new LinkedList<String>(path);
        newPath.add(propertyName);
        FilterTypeDescriptor propType = type.hasEmbeddedProperty(propertyName) ? new FilterEmbeddedEntityTypeDescriptor(type.getEntityType(), newPath, this.propertyHelper) : new FilterPropertyTypeDescriptor();
        return new PathedPropertyReference(propertyName, (TypeDescriptor)propType, false);
    }

    public void pushFromStrategy(JoinType joinType, Tree associationFetchTree, Tree propertyFetchTree, Tree alias) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void pushSelectStrategy() {
        this.definingSelect = true;
    }

    public void popStrategy() {
        this.definingSelect = false;
    }

    public void propertyPathCompleted(PropertyPath path) {
        if (this.definingSelect && path.getLastNode().getType() instanceof FilterEmbeddedEntityTypeDescriptor) {
            FilterEmbeddedEntityTypeDescriptor type = (FilterEmbeddedEntityTypeDescriptor)path.getLastNode().getType();
            throw log.getProjectionOfCompleteEmbeddedEntitiesNotSupportedException(type.getEntityType(), path.asStringPathWithoutAlias());
        }
    }
}

