/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.jms.management;

import org.apache.activemq.artemis.utils.json.JSONArray;
import org.apache.activemq.artemis.utils.json.JSONObject;

public class JMSConsumerInfo {
    private final String consumerID;
    private final String connectionID;
    private final String destinationName;
    private final String destinationType;
    private final boolean browseOnly;
    private final long creationTime;
    private final boolean durable;
    private final String filter;

    public static JMSConsumerInfo[] from(String jsonString) throws Exception {
        JSONArray array = new JSONArray(jsonString);
        JMSConsumerInfo[] infos = new JMSConsumerInfo[array.length()];
        for (int i = 0; i < array.length(); ++i) {
            JMSConsumerInfo info;
            JSONObject sub = array.getJSONObject(i);
            infos[i] = info = new JMSConsumerInfo(sub.getString("consumerID"), sub.getString("connectionID"), sub.getString("destinationName"), sub.getString("destinationType"), sub.getBoolean("browseOnly"), sub.getLong("creationTime"), sub.getBoolean("durable"), sub.optString("filter", null));
        }
        return infos;
    }

    private JMSConsumerInfo(String consumerID, String connectionID, String destinationName, String destinationType, boolean browseOnly, long creationTime, boolean durable, String filter) {
        this.consumerID = consumerID;
        this.connectionID = connectionID;
        this.destinationName = destinationName;
        this.destinationType = destinationType;
        this.browseOnly = browseOnly;
        this.creationTime = creationTime;
        this.durable = durable;
        this.filter = filter;
    }

    public String getConsumerID() {
        return this.consumerID;
    }

    public String getConnectionID() {
        return this.connectionID;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public String getDestinationType() {
        return this.destinationType;
    }

    public boolean isBrowseOnly() {
        return this.browseOnly;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public String getFilter() {
        return this.filter;
    }
}

