/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.DirectReader;

public final class DirectMonotonicReader {
    private static final LongValues EMPTY = new LongValues(){

        @Override
        public long get(long index) {
            return 0L;
        }
    };

    public static Meta loadMeta(IndexInput metaIn, long numValues, int blockShift) throws IOException {
        Meta meta = new Meta(numValues, blockShift);
        for (int i = 0; i < meta.numBlocks; ++i) {
            meta.mins[i] = metaIn.readLong();
            meta.avgs[i] = Float.intBitsToFloat(metaIn.readInt());
            meta.offsets[i] = metaIn.readLong();
            meta.bpvs[i] = metaIn.readByte();
        }
        return meta;
    }

    public static LongValues getInstance(Meta meta, RandomAccessInput data) throws IOException {
        final LongValues[] readers = new LongValues[meta.numBlocks];
        for (int i = 0; i < meta.mins.length; ++i) {
            readers[i] = meta.bpvs[i] == 0 ? EMPTY : DirectReader.getInstance(data, meta.bpvs[i], meta.offsets[i]);
        }
        final int blockShift = meta.blockShift;
        final long[] mins = meta.mins;
        final float[] avgs = meta.avgs;
        return new LongValues(){

            @Override
            public long get(long index) {
                int block = (int)(index >>> blockShift);
                long blockIndex = index & (long)((1 << blockShift) - 1);
                long delta = readers[block].get(blockIndex);
                return mins[block] + (long)(avgs[block] * (float)blockIndex) + delta;
            }
        };
    }

    public static class Meta
    implements Accountable {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Meta.class);
        final long numValues;
        final int blockShift;
        final int numBlocks;
        final long[] mins;
        final float[] avgs;
        final byte[] bpvs;
        final long[] offsets;

        Meta(long numValues, int blockShift) {
            this.numValues = numValues;
            this.blockShift = blockShift;
            long numBlocks = numValues >>> blockShift;
            if (numBlocks << blockShift < numValues) {
                ++numBlocks;
            }
            this.numBlocks = (int)numBlocks;
            this.mins = new long[this.numBlocks];
            this.avgs = new float[this.numBlocks];
            this.bpvs = new byte[this.numBlocks];
            this.offsets = new long[this.numBlocks];
        }

        @Override
        public long ramBytesUsed() {
            return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.mins) + RamUsageEstimator.sizeOf(this.avgs) + RamUsageEstimator.sizeOf(this.bpvs) + RamUsageEstimator.sizeOf(this.offsets);
        }

        @Override
        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }
    }
}

