/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import java.util.function.BiConsumer;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.functional.AbstractWriteKeyCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.functional.impl.Params;

public final class WriteOnlyKeyValueCommand<K, V>
extends AbstractWriteKeyCommand<K, V> {
    public static final byte COMMAND_ID = 55;
    private BiConsumer<V, EntryView.WriteEntryView<V>> f;
    private V value;

    public WriteOnlyKeyValueCommand(K key, V value, BiConsumer<V, EntryView.WriteEntryView<V>> f, CommandInvocationId id, ValueMatcher valueMatcher, Params params) {
        super(key, valueMatcher, id, params);
        this.f = f;
        this.value = value;
    }

    public WriteOnlyKeyValueCommand() {
    }

    @Override
    public byte getCommandId() {
        return 55;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        output.writeObject(this.value);
        output.writeObject(this.f);
        MarshallUtil.marshallEnum((Enum)this.valueMatcher, (ObjectOutput)output);
        output.writeObject(Flag.copyWithoutRemotableFlags(this.flags));
        output.writeObject(this.commandInvocationId);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.value = input.readObject();
        this.f = (BiConsumer)input.readObject();
        this.valueMatcher = (ValueMatcher)MarshallUtil.unmarshallEnum((ObjectInput)input, ValueMatcher::valueOf);
        this.flags = (Set)input.readObject();
        this.commandInvocationId = (CommandInvocationId)input.readObject();
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        CacheEntry e = ctx.lookupEntry(this.key);
        if (e == null) {
            return null;
        }
        this.f.accept(this.value, EntryViews.writeOnly(e));
        return null;
    }

    @Override
    public void updateStatusFromRemoteResponse(Object remoteResponse) {
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitWriteOnlyKeyValueCommand(ctx, this);
    }

    @Override
    public boolean readsExistingValues() {
        return false;
    }

    @Override
    public boolean alwaysReadsExistingValues() {
        return false;
    }

    @Override
    public boolean isWriteOnly() {
        return true;
    }
}

