/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.distribution.L1Manager;
import org.infinispan.distribution.RemoteValueRetrievedListener;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.interceptors.distribution.L1WriteSynchronizer;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class L1ManagerImpl
implements L1Manager,
RemoteValueRetrievedListener {
    private static final Log log = LogFactory.getLog(L1ManagerImpl.class);
    private final boolean trace = log.isTraceEnabled();
    private Configuration configuration;
    private RpcManager rpcManager;
    private CommandsFactory commandsFactory;
    private int threshold;
    private long l1Lifespan;
    private final ConcurrentMap<Object, ConcurrentMap<Address, Long>> requestors = CollectionFactory.makeConcurrentMap();
    private final ConcurrentMap<Object, L1WriteSynchronizer> synchronizers = CollectionFactory.makeConcurrentMap();
    private ScheduledExecutorService scheduledExecutor;
    private ScheduledFuture<?> scheduledRequestorsCleanupTask;
    private TimeService timeService;
    private RpcOptions syncIgnoreLeaversRpcOptions;

    @Inject
    public void init(Configuration configuration, RpcManager rpcManager, CommandsFactory commandsFactory, @ComponentName(value="org.infinispan.executors.expiration") ScheduledExecutorService scheduledExecutor, TimeService timeService) {
        this.rpcManager = rpcManager;
        this.commandsFactory = commandsFactory;
        this.configuration = configuration;
        this.scheduledExecutor = scheduledExecutor;
        this.timeService = timeService;
    }

    @Start(priority=3)
    public void start() {
        this.threshold = this.configuration.clustering().l1().invalidationThreshold();
        this.l1Lifespan = this.configuration.clustering().l1().lifespan();
        if (this.configuration.clustering().l1().cleanupTaskFrequency() > 0L) {
            this.scheduledRequestorsCleanupTask = this.scheduledExecutor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    L1ManagerImpl.this.cleanUpRequestors();
                }
            }, this.configuration.clustering().l1().cleanupTaskFrequency(), this.configuration.clustering().l1().cleanupTaskFrequency(), TimeUnit.MILLISECONDS);
        } else {
            log.warnL1NotHavingReaperThread();
        }
        this.syncIgnoreLeaversRpcOptions = this.rpcManager.getRpcOptionsBuilder(ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS, DeliverOrder.NONE).build();
    }

    @Stop(priority=3)
    public void stop() {
        if (this.scheduledRequestorsCleanupTask != null) {
            this.scheduledRequestorsCleanupTask.cancel(true);
        }
    }

    private void cleanUpRequestors() {
        long expiryTime = this.timeService.wallClockTime() - this.l1Lifespan;
        for (Map.Entry entry : this.requestors.entrySet()) {
            Object key = entry.getKey();
            ConcurrentMap reqs = (ConcurrentMap)entry.getValue();
            this.prune(reqs, expiryTime);
            if (!reqs.isEmpty()) continue;
            this.requestors.remove(key);
        }
    }

    private void prune(ConcurrentMap<Address, Long> reqs, long expiryTime) {
        for (Map.Entry req : reqs.entrySet()) {
            if ((Long)req.getValue() >= expiryTime) continue;
            reqs.remove(req.getKey());
        }
    }

    @Override
    public void addRequestor(Object key, Address origin) {
        ConcurrentMap as = (ConcurrentMap)this.requestors.get(key);
        log.tracef("Registering requestor %s for key '%s'", origin, key);
        long now = this.timeService.wallClockTime();
        if (as == null) {
            as = CollectionFactory.makeConcurrentMap();
            as.put(origin, now);
            ConcurrentMap<Address, Long> previousAs = this.requestors.putIfAbsent(key, as);
            if (previousAs != null) {
                previousAs.put(origin, now);
            }
        } else {
            as.put(origin, now);
        }
    }

    @Override
    public Future<?> flushCache(Collection<Object> keys, Address origin, boolean assumeOriginKeptEntryInL1) {
        Collection<Address> invalidationAddresses = this.buildInvalidationAddressList(keys, origin, assumeOriginKeptEntryInL1);
        int nodes = invalidationAddresses.size();
        if (nodes > 0) {
            InvalidateCommand ic = this.commandsFactory.buildInvalidateFromL1Command(origin, Collections.emptySet(), keys);
            SingleRpcCommand rpcCommand = this.commandsFactory.buildSingleRpcCommand(ic);
            boolean multicast = this.isUseMulticast(nodes);
            if (this.trace) {
                log.tracef("Invalidating keys %s on nodes %s. Use multicast? %s", keys, invalidationAddresses, multicast);
            }
            CompletableFuture<Map<Address, Response>> future = multicast ? this.rpcManager.invokeRemotelyAsync(null, rpcCommand, this.syncIgnoreLeaversRpcOptions) : this.rpcManager.invokeRemotelyAsync(invalidationAddresses, rpcCommand, this.syncIgnoreLeaversRpcOptions);
            return future;
        }
        if (this.trace) {
            log.tracef("No L1 caches to invalidate for keys %s", keys);
        }
        return null;
    }

    private Collection<Address> buildInvalidationAddressList(Collection<Object> keys, Address origin, boolean assumeOriginKeptEntryInL1) {
        HashSet<Address> addresses = new HashSet<Address>(2);
        boolean originIsInRequestorsList = false;
        for (Object key : keys) {
            ConcurrentMap as = (ConcurrentMap)this.requestors.remove(key);
            if (as == null) continue;
            Set requestorAddresses = as.keySet();
            addresses.addAll(requestorAddresses);
            if (!assumeOriginKeptEntryInL1 || origin == null || !requestorAddresses.contains(origin)) continue;
            originIsInRequestorsList = true;
            this.addRequestor(key, origin);
        }
        if (originIsInRequestorsList) {
            addresses.remove(origin);
        }
        return addresses;
    }

    private boolean isUseMulticast(int nodes) {
        if (this.threshold == -1) {
            return false;
        }
        if (!this.rpcManager.getTransport().isMulticastCapable()) {
            return false;
        }
        if (this.threshold == 0) {
            return true;
        }
        return nodes > this.threshold;
    }

    @Override
    public void registerL1WriteSynchronizer(Object key, L1WriteSynchronizer sync) {
        if (this.synchronizers.put(key, sync) != null && this.trace) {
            log.tracef("Replaced existing L1 write synchronizer for key %s as there was a concurrent L1 attempt to update", key);
        }
    }

    @Override
    public void unregisterL1WriteSynchronizer(Object key, L1WriteSynchronizer sync) {
        this.synchronizers.remove(key, sync);
    }

    @Override
    public void remoteValueFound(InternalCacheEntry ice) {
        L1WriteSynchronizer synchronizer = (L1WriteSynchronizer)this.synchronizers.get(ice.getKey());
        if (synchronizer != null) {
            synchronizer.runL1UpdateIfPossible(ice);
        }
    }

    @Override
    public void remoteValueNotFound(Object key) {
        L1WriteSynchronizer synchronizer = (L1WriteSynchronizer)this.synchronizers.get(key);
        if (synchronizer != null) {
            synchronizer.runL1UpdateIfPossible(null);
        }
    }
}

