/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.logging;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.security.Permission;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.ObjectName;
import javax.naming.NamingException;
import javax.transaction.Synchronization;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.xml.namespace.QName;
import org.infinispan.IllegalLifecycleStateException;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.CacheListenerException;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.jmx.JmxDomainConflictException;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.partitionhandling.AvailabilityException;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.persistence.support.SingletonCacheWriter;
import org.infinispan.remoting.RemoteException;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.topology.CacheTopology;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareRemoteTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareTransaction;
import org.infinispan.util.concurrent.TimeoutException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jgroups.View;

@MessageLogger(projectCode="ISPN")
public interface Log
extends BasicLogger {
    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to load %s from cache loader", id=1)
    public void unableToLoadFromCacheLoader(Object var1, @Cause PersistenceException var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Field %s not found!!", id=2)
    public void fieldNotFound(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Property %s could not be replaced as intended!", id=3)
    public void propertyCouldNotBeReplaced(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unexpected error reading properties", id=4)
    public void errorReadingProperties(@Cause IOException var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Detected write skew on key [%s]. Another process has changed the entry since we last read it! Unable to copy entry for update.", id=5)
    public void unableToCopyEntryForUpdate(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed remote execution on node %s", id=6)
    public void remoteExecutionFailed(Address var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed local execution ", id=7)
    public void localExecutionFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Can not select %s random members for %s", id=8)
    public void cannotSelectRandomMembers(int var1, List<Address> var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="DistributionManager not yet joined the cluster. Cannot do anything about other concurrent joiners.", id=14)
    public void distributionManagerNotJoined();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="DistributionManager not started after waiting up to 5 minutes! Not rehashing!", id=15)
    public void distributionManagerNotStarted();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Problem %s encountered when applying state for key %s!", id=16)
    public void problemApplyingStateForKey(String var1, Object var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to apply prepare %s", id=18)
    public void unableToApplyPrepare(PrepareCommand var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Couldn't acquire shared lock", id=19)
    public void couldNotAcquireSharedLock();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Expected just one response; got %s", id=21)
    public void expectedJustOneResponse(Map<Address, Response> var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="wakeUpInterval is <= 0, not starting expired purge thread", id=25)
    public void notStartingEvictionThread();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Caught exception purging data container!", id=26)
    public void exceptionPurgingDataContainer(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not acquire lock for eviction of %s", id=27)
    public void couldNotAcquireLockForEviction(Object var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to passivate entry under %s", id=28)
    public void unableToPassivateEntry(Object var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Passivating all entries to disk", id=29)
    public void passivatingAllEntries();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Passivated %d entries in %s", id=30)
    public void passivatedEntries(int var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="MBeans were successfully registered to the platform MBean server.", id=31)
    public void mbeansSuccessfullyRegistered();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Problems un-registering MBeans", id=32)
    public void problemsUnregisteringMBeans(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to unregister Cache MBeans with pattern %s", id=33)
    public void unableToUnregisterMBeanWithPattern(String var1, @Cause MBeanRegistrationException var2);

    @Message(value="There's already a JMX MBean instance %s already registered under '%s' JMX domain. If you want to allow multiple instances configured with same JMX domain enable 'allowDuplicateDomains' attribute in 'globalJmxStatistics' config element", id=34)
    public JmxDomainConflictException jmxMBeanAlreadyRegistered(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not reflect field description of this class. Was it removed?", id=35)
    public void couldNotFindDescriptionField();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Did not find attribute %s", id=36)
    public void couldNotFindAttribute(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed to update attribute name %s with value %s", id=37)
    public void failedToUpdateAttribute(String var1, Object var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Method name %s doesn't start with \"get\", \"set\", or \"is\" but is annotated with @ManagedAttribute: will be ignored", id=38)
    public void ignoringManagedAttribute(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Method %s must have a valid return type and zero parameters", id=39)
    public void invalidManagedAttributeMethod(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Not adding annotated method %s since we already have read attribute", id=40)
    public void readManagedAttributeAlreadyPresent(Method var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Not adding annotated method %s since we already have writable attribute", id=41)
    public void writeManagedAttributeAlreadyPresent(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Did not find queried attribute with name %s", id=42)
    public void queriedAttributeNotFound(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Exception while writing value for attribute %s", id=43)
    public void errorWritingValueForAttribute(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not invoke set on attribute %s with value %s", id=44)
    public void couldNotInvokeSetOnAttribute(String var1, Object var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Problems encountered while purging expired", id=45)
    public void problemPurgingExpired(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unknown responses from remote cache: %s", id=46)
    public void unknownResponsesFromRemoteCache(Collection<Response> var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error while doing remote call", id=47)
    public void errorDoingRemoteCall(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Interrupted or timeout while waiting for AsyncCacheWriter worker threads to push all state to the decorated store", id=48)
    public void interruptedWaitingAsyncStorePush(@Cause InterruptedException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unexpected error", id=51)
    public void unexpectedErrorInAsyncProcessor(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Interrupted on acquireLock for %d milliseconds!", id=52)
    public void interruptedAcquiringLock(long var1, @Cause InterruptedException var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to process some async modifications after %d retries!", id=53)
    public void unableToProcessAsyncModifications(int var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unexpected error in AsyncStoreCoordinator thread. AsyncCacheWriter is dead!", id=55)
    public void unexpectedErrorInAsyncStoreCoordinator(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Exception reported changing cache active status", id=58)
    public void errorChangingSingletonStoreStatus(@Cause SingletonCacheWriter.PushStateException var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Had problems removing file %s", id=59)
    public void problemsRemovingFile(File var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Problems purging file %s", id=60)
    public void problemsPurgingFile(File var1, @Cause PersistenceException var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to acquire global lock to purge cache store", id=61)
    public void unableToAcquireLockToPurgeStore();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error while reading from file: %s", id=62)
    public void errorReadingFromFile(File var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Problems creating the directory: %s", id=64)
    public void problemsCreatingDirectory(File var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Exception while marshalling object: %s", id=65)
    public void errorMarshallingObject(@Cause IOException var1, Object var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unable to read version id from first two bytes of stream, barfing.", id=66)
    public void unableToReadVersionId();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Will try and wait for the cache %s to start", id=67)
    public void waitForCacheToStart(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Cache named %s does not exist on this cache manager!", id=68)
    public void namedCacheDoesNotExist(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Caught exception when handling command %s", id=71)
    public void exceptionHandlingCommand(ReplicableCommand var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failed replicating %d elements in replication queue", id=72)
    public void failedReplicatingQueue(int var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unexpected error while replicating", id=73)
    public void unexpectedErrorReplicating(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Message or message buffer is null or empty.", id=77)
    public void msgOrMsgBufferEmpty();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Starting JGroups channel %s", id=78)
    public void startingJGroupsChannel(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Channel %s local address is %s, physical addresses are %s", id=79)
    public void localAndPhysicalAddress(String var1, Address var2, List<Address> var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Disconnecting JGroups channel %s", id=80)
    public void disconnectJGroups(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Problem closing channel %s; setting it to null", id=81)
    public void problemClosingChannel(@Cause Exception var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Stopping the RpcDispatcher for channel %s", id=82)
    public void stoppingRpcDispatcher(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Class [%s] cannot be cast to JGroupsChannelLookup! Not using a channel lookup.", id=83)
    public void wrongTypeForJGroupsChannelLookup(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Errors instantiating [%s]! Not using a channel lookup.", id=84)
    public void errorInstantiatingJGroupsChannelLookup(String var1, @Cause Exception var2);

    @Message(value="Error while trying to create a channel using the specified configuration file: %s", id=85)
    public CacheConfigurationException errorCreatingChannelFromConfigFile(String var1, @Cause Exception var2);

    @Message(value="Error while trying to create a channel using the specified configuration XML: %s", id=86)
    public CacheConfigurationException errorCreatingChannelFromXML(String var1, @Cause Exception var2);

    @Message(value="Error while trying to create a channel using the specified configuration string: %s", id=87)
    public CacheConfigurationException errorCreatingChannelFromConfigString(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Unable to use any JGroups configuration mechanisms provided in properties %s. Using default JGroups configuration!", id=88)
    public void unableToUseJGroupsPropertiesProvided(TypedProperties var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="getCoordinator(): Interrupted while waiting for members to be set", id=89)
    public void interruptedWaitingForCoordinator(@Cause InterruptedException var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Channel not set up properly!", id=92)
    public void channelNotSetUp();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Received new, MERGED cluster view for channel %s: %s", id=93)
    public void receivedMergedView(String var1, View var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Received new cluster view for channel %s: %s", id=94)
    public void receivedClusterView(String var1, View var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error while processing a prepare in a single-phase transaction", id=97)
    public void errorProcessing1pcPrepareCommand(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Exception during rollback", id=98)
    public void errorRollingBack(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unprocessed Transaction Log Entries! = %d", id=99)
    public void unprocessedTxLogEntries(int var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Stopping, but there are %s local transactions and %s remote transactions that did not finish in time.", id=100)
    public void unfinishedTransactionsRemain(int var1, int var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed synchronization registration", id=101)
    public void failedSynchronizationRegistration(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to roll back global transaction %s", id=102)
    public void unableToRollbackGlobalTx(GlobalTransaction var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="A remote transaction with the given id was already registered!!!", id=103)
    public void remoteTxAlreadyRegistered();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Falling back to DummyTransactionManager from Infinispan", id=104)
    public void fallingBackToDummyTm();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failed creating initial JNDI context", id=105)
    public void failedToCreateInitialCtx(@Cause NamingException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Found WebSphere TransactionManager factory class [%s], but couldn't invoke its static 'getTransactionManager' method", id=106)
    public void unableToInvokeWebsphereStaticGetTmMethod(@Cause Exception var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Retrieving transaction manager %s", id=107)
    public void retrievingTm(TransactionManager var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error enlisting resource", id=108)
    public void errorEnlistingResource(@Cause XAException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="beforeCompletion() failed for %s", id=109)
    public void beforeCompletionFailed(Synchronization var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unexpected error from resource manager!", id=110)
    public void unexpectedErrorFromResourceManager(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="afterCompletion() failed for %s", id=111)
    public void afterCompletionFailed(Synchronization var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="exception while committing", id=112)
    public void errorCommittingTx(@Cause XAException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unbinding of DummyTransactionManager failed", id=113)
    public void unbindingDummyTmFailed(@Cause NamingException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unsupported combination (dldEnabled, recoveryEnabled, xa) = (%s, %s, %s)", id=114)
    public void unsupportedTransactionConfiguration(boolean var1, boolean var2, boolean var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Recovery call will be ignored as recovery is disabled. More on recovery: http://community.jboss.org/docs/DOC-16646", id=115)
    public void recoveryIgnored();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Missing the list of prepared transactions from node %s. Received response is %s", id=116)
    public void missingListPreparedTransactions(Object var1, Object var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="There's already a prepared transaction with this xid: %s. New transaction is %s. Are there two different transactions having same Xid in the cluster?", id=117)
    public void preparedTxAlreadyExists(RecoveryAwareTransaction var1, RecoveryAwareRemoteTransaction var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not load module at URL %s", id=118)
    public void couldNotLoadModuleAtUrl(URL var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Module %s loaded, but could not be initialized", id=119)
    public void couldNotInitializeModule(Object var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Invocation of %s threw an exception %s. Exception is ignored.", id=120)
    public void ignoringException(String var1, String var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unable to set value!", id=121)
    public void unableToSetValue(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to convert string property [%s] to an int! Using default value of %d", id=122)
    public void unableToConvertStringPropertyToInt(String var1, int var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to convert string property [%s] to a long! Using default value of %d", id=123)
    public void unableToConvertStringPropertyToLong(String var1, long var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to convert string property [%s] to a boolean! Using default value of %b", id=124)
    public void unableToConvertStringPropertyToBoolean(String var1, boolean var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to invoke getter %s on Configuration.class!", id=125)
    public void unableToInvokeGetterOnConfiguration(Method var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Attempted to stop() from FAILED state, but caught exception; try calling destroy()", id=126)
    public void failedToCallStopAfterFailure(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Needed to call stop() before destroying but stop() threw exception. Proceeding to destroy", id=127)
    public void stopBeforeDestroyFailed(@Cause CacheException var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Infinispan version: %s", id=128)
    public void version(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Received a remote call but the cache is not in STARTED state - ignoring call.", id=129)
    public void cacheNotStarted();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Caught exception! Aborting join.", id=130)
    public void abortingJoin(@Cause Exception var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="%s completed join rehash in %s!", id=131)
    public void joinRehashCompleted(Address var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="%s aborted join rehash after %s!", id=132)
    public void joinRehashAborted(Address var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Attempted to register listener of class %s, but no valid, public methods annotated with method-level event annotations found! Ignoring listener.", id=133)
    public void noAnnotateMethodsFoundInListener(Class<?> var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to invoke method %s on Object instance %s - removing this target object from list of listeners!", id=134)
    public void unableToInvokeListenerMethodAndRemoveListener(Method var1, Object var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not lock key %s in order to invalidate from L1 at node %s, skipping....", id=135)
    public void unableToLockToInvalidate(Object var1, Address var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error executing command %s, writing keys %s", id=136)
    public void executionError(String var1, Collection<?> var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Failed invalidating remote cache", id=137)
    public void failedInvalidatingRemoteCache(@Cause Exception var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Could not register object with name: %s", id=138)
    public void couldNotRegisterObjectName(ObjectName var1, @Cause InstanceAlreadyExistsException var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Infinispan configuration schema could not be resolved locally nor fetched from URL. Local path=%s, schema path=%s, schema URL=%s", id=139)
    public void couldNotResolveConfigurationSchema(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Lazy deserialization configuration is deprecated, please use storeAsBinary instead", id=140)
    public void lazyDeserializationDeprecated();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not rollback prepared 1PC transaction. This transaction will be rolled back by the recovery process, if enabled. Transaction: %s", id=141)
    public void couldNotRollbackPrepared1PcTransaction(LocalTransaction var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Received a key that doesn't map to this node: %s, mapped to %s", id=143)
    public void keyDoesNotMapToLocalNode(Object var1, Collection<Address> var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed loading value for key %s from cache store", id=144)
    public void failedLoadingValueFromCacheStore(Object var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error invalidating keys from L1 after rehash", id=147)
    public void failedToInvalidateKeys(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Invalid %s value of %s. It can not be higher than %s which is %s", id=148)
    public void invalidTimeoutValue(Object var1, Object var2, Object var3, Object var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Fetch persistent state and purge on startup are both disabled, cache may contain stale entries on startup", id=149)
    public void staleEntriesWithoutFetchPersistentStateOrPurgeOnStartup();

    @LogMessage(level=Logger.Level.FATAL)
    @Message(value="Rehash command received on non-distributed cache. All the nodes in the cluster should be using the same configuration.", id=150)
    public void rehashCommandReceivedOnNonDistributedCache();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error flushing to file: %s", id=151)
    public void errorFlushingToFileChannel(FileChannel var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Passivation configured without an eviction policy being selected. Only manually evicted entities will be passivated.", id=152)
    public void passivationWithoutEviction();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unable to unlock keys %2$s for transaction %1$s after they were rebalanced off node %3$s", id=154)
    public void unableToUnlockRebalancedKeys(GlobalTransaction var1, List<Object> var2, Address var3, @Cause Throwable var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unblocking transactions failed", id=159)
    public void errorUnblockingTransactions(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not complete injected transaction.", id=160)
    public void couldNotCompleteInjectedTransaction(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Using a batchMode transaction manager", id=161)
    public void usingBatchModeTransactionManager();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Could not instantiate transaction manager", id=162)
    public void couldNotInstantiateTransactionManager(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="FileCacheStore ignored an unexpected file %2$s in path %1$s. The store path should be dedicated!", id=163)
    public void cacheLoaderIgnoringUnexpectedFile(Object var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Rolling back to cache view %d, but last committed view is %d", id=164)
    public void cacheViewRollbackIdMismatch(int var1, int var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Strict peer-to-peer is enabled but the JGroups channel was started externally - this is very likely to result in RPC timeout errors on startup", id=171)
    public void warnStrictPeerToPeerWithInjectedChannel();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Custom interceptor %s has used @Inject, @Start or @Stop. These methods will not be processed. Please extend org.infinispan.interceptors.base.BaseCustomInterceptor instead, and your custom interceptor will have access to a cache and cacheManager.  Override stop() and start() for lifecycle methods.", id=173)
    public void customInterceptorExpectsInjection(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unexpected error reading configuration", id=174)
    public void errorReadingConfiguration(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unexpected error closing resource", id=175)
    public void failedToCloseResource(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The 'wakeUpInterval' attribute of the 'eviction' configuration XML element is deprecated. Setting the 'wakeUpInterval' attribute of the 'expiration' configuration XML element to %d instead", id=176)
    public void evictionWakeUpIntervalDeprecated(Long var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="%s has been deprecated as a synonym for %s. Use one of %s instead", id=177)
    public void randomCacheModeSynonymsDeprecated(String var1, String var2, List<String> var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="stateRetrieval's 'alwaysProvideInMemoryState' attribute is no longer in use, instead please make sure all instances of this named cache in the cluster have 'fetchInMemoryState' attribute enabled", id=178)
    public void alwaysProvideInMemoryStateDeprecated();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="stateRetrieval's 'initialRetryWaitTime' attribute is no longer in use.", id=179)
    public void initialRetryWaitTimeDeprecated();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="stateRetrieval's 'logFlushTimeout' attribute is no longer in use.", id=180)
    public void logFlushTimeoutDeprecated();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="stateRetrieval's 'maxProgressingLogWrites' attribute is no longer in use.", id=181)
    public void maxProgressingLogWritesDeprecated();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="stateRetrieval's 'numRetries' attribute is no longer in use.", id=182)
    public void numRetriesDeprecated();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="stateRetrieval's 'retryWaitTimeIncreaseFactor' attribute is no longer in use.", id=183)
    public void retryWaitTimeIncreaseFactorDeprecated();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="The stateRetrieval configuration element has been deprecated, we're assuming you meant stateTransfer. Please see XML schema for more information.", id=184)
    public void stateRetrievalConfigurationDeprecated();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="hash's 'rehashEnabled' attribute has been deprecated. Please use stateTransfer.fetchInMemoryState instead", id=185)
    public void hashRehashEnabledDeprecated();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="hash's 'rehashRpcTimeout' attribute has been deprecated. Please use stateTransfer.timeout instead", id=186)
    public void hashRehashRpcTimeoutDeprecated();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="hash's 'rehashWait' attribute has been deprecated. Please use stateTransfer.timeout instead", id=187)
    public void hashRehashWaitDeprecated();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error while processing a commit in a two-phase transaction", id=188)
    public void errorProcessing2pcCommitCommand(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="While stopping a cache or cache manager, one of its components failed to stop", id=189)
    public void componentFailedToStop(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Use of the 'loader' element to configure a store is deprecated, please use the 'store' element instead", id=190)
    public void deprecatedLoaderAsStoreConfiguration();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="When indexing locally a cache with shared cache loader, preload must be enabled", id=191)
    public void localIndexingWithSharedCacheLoaderRequiresPreload();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="hash's 'numVirtualNodes' attribute has been deprecated. Please use hash.numSegments instead", id=192)
    public void hashNumVirtualNodesDeprecated();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="hash's 'consistentHash' attribute has been deprecated. Please use hash.consistentHashFactory instead", id=193)
    public void consistentHashDeprecated();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed loading keys from cache store", id=194)
    public void failedLoadingKeysFromCacheStore(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error during rebalance for cache %s on node %s", id=195)
    public void rebalanceError(String var1, Address var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failed to recover cluster state after the current node became the coordinator (or after merge)", id=196)
    public void failedToRecoverClusterState(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Error updating cluster member list", id=197)
    public void errorUpdatingMembersList(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Unable to register MBeans for default cache", id=198)
    public void unableToRegisterMBeans();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Unable to register MBeans for named cache %s", id=199)
    public void unableToRegisterMBeans(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Unable to register MBeans for cache manager", id=200)
    public void unableToRegisterCacheManagerMBeans();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="This cache is configured to backup to its own site (%s).", id=201)
    public void cacheBackupsDataToSameSite(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Problems backing up data for cache %s to site %s: %s", id=202)
    public void warnXsiteBackupFailed(String var1, String var2, Object var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The rollback request for tx %s cannot be processed by the cache %s as this cache is not transactional!", id=203)
    public void cannotRespondToRollback(GlobalTransaction var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The commit request for tx %s cannot be processed by the cache %s as this cache is not transactional!", id=204)
    public void cannotRespondToCommit(GlobalTransaction var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Trying to bring back an non-existent site (%s)!", id=205)
    public void tryingToBringOnlineNonexistentSite(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not execute cancelation command locally %s", id=206)
    public void couldNotExecuteCancellationLocally(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not interrupt as no thread found for command uuid %s", id=207)
    public void couldNotInterruptThread(UUID var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="No live owners found for segment %d of cache %s. Current owners are:  %s. Faulty owners: %s", id=208)
    public void noLiveOwnersFoundForSegment(int var1, String var2, Collection<Address> var3, Collection<Address> var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed to retrieve transactions for segments %s of cache %s from node %s", id=209)
    public void failedToRetrieveTransactionsForSegments(Collection<Integer> var1, String var2, Address var3, @Cause Exception var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed to request segments %s of cache %s from node %s (node will not be retried)", id=210)
    public void failedToRequestSegments(Collection<Integer> var1, String var2, Address var3, @Cause Throwable var4);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unable to load %s from any of the following classloaders: %s", id=213)
    public void unableToLoadClass(String var1, String var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to remove entry under %s from cache store after activation", id=214)
    public void unableToRemoveEntryAfterActivation(Object var1, @Cause Exception var2);

    @Message(value="Unknown migrator %s", id=215)
    public Exception unknownMigrator(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="%d entries migrated to cache %s in %s", id=216)
    public void entriesMigrated(long var1, String var3, String var4);

    @Message(value="Received exception from %s, see cause for remote stack trace", id=217)
    public RemoteException remoteException(Address var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Timeout while waiting for the transaction validation. The command will not be processed. Transaction is %s", id=218)
    public void timeoutWaitingUntilTransactionPrepared(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Shutdown while handling command %s", id=219)
    public void shutdownHandlingCommand(ReplicableCommand var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Problems un-marshalling remote command from byte buffer", id=220)
    public void errorUnMarshallingCommand(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unknown response value [%s]. Expected [%s]", id=221)
    public void unexpectedResponse(String var1, String var2);

    @Message(value="Custom interceptor missing class", id=222)
    public CacheConfigurationException customInterceptorMissingClass();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Custom interceptor '%s' does not extend BaseCustomInterceptor, which is recommended", id=223)
    public void suggestCustomInterceptorInheritance(String var1);

    @Message(value="Custom interceptor '%s' specifies more than one position", id=224)
    public CacheConfigurationException multipleCustomInterceptorPositions(String var1);

    @Message(value="Custom interceptor '%s' doesn't specify a position", id=225)
    public CacheConfigurationException missingCustomInterceptorPosition(String var1);

    @Message(value="Error while initializing SSL context", id=226)
    public CacheConfigurationException sslInitializationException(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Support for concurrent updates can no longer be configured (it is always enabled by default)", id=227)
    public void warnConcurrentUpdateSupportCannotBeConfigured();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failed to recover cache %s state after the current node became the coordinator", id=228)
    public void failedToRecoverCacheState(String var1, @Cause Throwable var2);

    @Message(value="Unexpected initial version type (only NumericVersion instances supported): %s", id=229)
    public IllegalArgumentException unexpectedInitialVersion(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failed to start rebalance for cache %s", id=230)
    public void rebalanceStartError(String var1, @Cause Throwable var2);

    @Message(value="Cache mode should be DIST or REPL, rather than %s", id=231)
    public IllegalStateException requireDistOrReplCache(String var1);

    @Message(value="Cache is in an invalid state: %s", id=232)
    public IllegalStateException invalidCacheState(String var1);

    @Message(value="Root element for %s already registered in ParserRegistry", id=234)
    public IllegalArgumentException parserRootElementAlreadyRegistered(QName var1);

    @Message(value="Configuration parser %s does not declare any Namespace annotations", id=235)
    public CacheConfigurationException parserDoesNotDeclareNamespaces(String var1);

    @Message(value="Purging expired entries failed", id=236)
    public PersistenceException purgingExpiredEntriesFailed(@Cause Throwable var1);

    @Message(value="Waiting for expired entries to be purge timed out", id=237)
    public PersistenceException timedOutWaitingForExpiredEntriesToBePurged(@Cause Throwable var1);

    @Message(value="Directory %s does not exist and cannot be created!", id=238)
    public CacheConfigurationException directoryCannotBeCreated(String var1);

    @Message(value="Cache manager is shutting down, so type write externalizer for type=%s cannot be resolved", id=239)
    public IOException externalizerTableStopped(String var1);

    @Message(value="Cache manager is shutting down, so type (id=%d) cannot be resolved. Interruption being pushed up.", id=240)
    public IOException pushReadInterruptionDueToCacheManagerShutdown(int var1, @Cause InterruptedException var2);

    @Message(value="Cache manager is %s and type (id=%d) cannot be resolved (thread not interrupted)", id=241)
    public CacheException cannotResolveExternalizerReader(ComponentStatus var1, int var2);

    @Message(value="Missing foreign externalizer with id=%s, either externalizer was not configured by client, or module lifecycle implementation adding externalizer was not loaded properly", id=242)
    public CacheException missingForeignExternalizer(int var1);

    @Message(value="Type of data read is unknown. Id=%d is not amongst known reader indexes.", id=243)
    public CacheException unknownExternalizerReaderIndex(int var1);

    @Message(value="AdvancedExternalizer's getTypeClasses for externalizer %s must return a non-empty set", id=244)
    public CacheConfigurationException advanceExternalizerTypeClassesUndefined(String var1);

    @Message(value="Duplicate id found! AdvancedExternalizer id=%d for %s is shared by another externalizer (%s). Reader index is %d", id=245)
    public CacheConfigurationException duplicateExternalizerIdFound(int var1, Class<?> var2, String var3, int var4);

    @Message(value="Internal %s externalizer is using an id(%d) that exceeded the limit. It needs to be smaller than %d", id=246)
    public CacheConfigurationException internalExternalizerIdLimitExceeded(AdvancedExternalizer<?> var1, int var2, int var3);

    @Message(value="Foreign %s externalizer is using a negative id(%d). Only positive id values are allowed.", id=247)
    public CacheConfigurationException foreignExternalizerUsingNegativeId(AdvancedExternalizer<?> var1, int var2);

    @Message(value="Invalid cache loader configuration!!  Only ONE cache loader may have fetchPersistentState set to true.  Cache will not start!", id=248)
    public CacheConfigurationException multipleCacheStoresWithFetchPersistentState();

    @Message(value="The cache loader configuration %s does not specify the loader class using @ConfigurationFor", id=249)
    public CacheConfigurationException loaderConfigurationDoesNotSpecifyLoaderClass(String var1);

    @Message(value="Invalid configuration, expecting '%s' got '%s' instead", id=250)
    public CacheConfigurationException incompatibleLoaderConfiguration(String var1, String var2);

    @Message(value="Cache Loader configuration cannot be null", id=251)
    public CacheConfigurationException cacheLoaderConfigurationCannotBeNull();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error executing parallel store task", id=252)
    public void errorExecutingParallelStoreTask(@Cause Throwable var1);

    @Message(value="Invalid Cache Loader class: %s", id=253)
    public CacheConfigurationException invalidCacheLoaderClass(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The transport element's 'strictPeerToPeer' attribute is no longer in use.", id=254)
    public void strictPeerToPeerDeprecated();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error while processing prepare", id=255)
    public void errorProcessingPrepare(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Configurator SAXParse error", id=256)
    public void configuratorSAXParseError(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Configurator SAX error", id=257)
    public void configuratorSAXError(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Configurator general error", id=258)
    public void configuratorError(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Async store executor did not stop properly", id=259)
    public void errorAsyncStoreNotStopped();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Exception executing command", id=260)
    public void exceptionExecutingInboundCommand(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failed to execute outbound transfer", id=261)
    public void failedOutBoundTransferExecution(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failed to enlist TransactionXaAdapter to transaction", id=262)
    public void failedToEnlistTransactionXaAdapter(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="FIFO strategy is deprecated, LRU will be used instead", id=263)
    public void warnFifoStrategyIsDeprecated();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Not using an L1 invalidation reaper thread. This could lead to memory leaks as the requestors map may grow indefinitely!", id=264)
    public void warnL1NotHavingReaperThread();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Problems creating interceptor %s", id=267)
    public void unableToCreateInterceptor(Class var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to broadcast evicts as a part of the prepare phase. Rolling back.", id=268)
    public void unableToRollbackEvictionsDuringPrepare(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Cache used for Grid metadata should be synchronous.", id=269)
    public void warnGridFSMetadataCacheRequiresSync();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not commit local tx %s", id=270)
    public void warnCouldNotCommitLocalTx(Object var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not rollback local tx %s", id=271)
    public void warnCouldNotRollbackLocalTx(Object var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Exception removing recovery information", id=272)
    public void warnExceptionRemovingRecovery(@Cause Exception var1);

    @Message(value="Indexing can not be enabled on caches in Invalidation mode", id=273)
    public CacheConfigurationException invalidConfigurationIndexingWithInvalidation();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Persistence enabled without any CacheLoaderInterceptor in InterceptorChain!", id=274)
    public void persistenceWithoutCacheLoaderInterceptor();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Persistence enabled without any CacheWriteInterceptor in InterceptorChain!", id=275)
    public void persistenceWithoutCacheWriteInterceptor();

    @Message(value="Could not find migration data in cache %s", id=276)
    public CacheException missingMigrationData(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not migrate key %s", id=277)
    public void keyMigrationFailed(String var1, @Cause Throwable var2);

    @Message(value="Indexing can only be enabled if infinispan-query.jar is available on your classpath, and this jar has not been detected.", id=278)
    public CacheConfigurationException invalidConfigurationIndexingWithoutModule();

    @Message(value="Failed to read stored entries from file. Error in file %s at offset %d", id=279)
    public PersistenceException errorReadingFileStore(String var1, long var2);

    @Message(value="Caught exception [%s] while invoking method [%s] on listener instance: %s", id=280)
    public CacheListenerException exceptionInvokingListener(String var1, Method var2, Object var3, @Cause Throwable var4);

    @Message(value="%s reported that a third node was suspected, see cause for info on the node that was suspected", id=281)
    public SuspectException thirdPartySuspected(Address var1, @Cause SuspectException var2);

    @Message(value="Cannot enable Invocation Batching when the Transaction Mode is NON_TRANSACTIONAL, set the transaction mode to TRANSACTIONAL", id=282)
    public CacheConfigurationException invocationBatchingNeedsTransactionalCache();

    @Message(value="A cache configured with invocation batching can't have recovery enabled", id=283)
    public CacheConfigurationException invocationBatchingCannotBeRecoverable();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Problem encountered while installing cluster listener", id=284)
    public void clusterListenerInstallationFailure(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Issue when retrieving cluster listeners from %s response was %s", id=285)
    public void unsuccessfulResponseForClusterListeners(Address var1, Response var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Issue when retrieving cluster listeners from %s", id=286)
    public void exceptionDuringClusterListenerRetrieval(Address var1, @Cause Throwable var2);

    @Message(value="Unauthorized access: subject '%s' lacks '%s' permission", id=287)
    public SecurityException unauthorizedAccess(String var1, String var2);

    @Message(value="A principal-to-role mapper has not been specified", id=288)
    public CacheConfigurationException invalidPrincipalRoleMapper();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to send X-Site state chunk to '%s'.", id=289)
    public void unableToSendXSiteState(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to wait for X-Site state chunk ACKs from '%s'.", id=290)
    public void unableToWaitForXSiteStateAcks(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to apply X-Site state chunk.", id=291)
    public void unableToApplyXSiteState(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unrecognized attribute '%s'. Please check your configuration. Ignoring!", id=292)
    public void unrecognizedAttribute(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Ignoring XML attribute %s, please remove from configuration file", id=293)
    public void ignoreXmlAttribute(Object var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Ignoring XML element %s, please remove from configuration file", id=294)
    public void ignoreXmlElement(Object var1);

    @Message(value="No thread pool with name %s found", id=295)
    public CacheConfigurationException undefinedThreadPoolName(String var1);

    @Message(value="Attempt to add a %s permission to a SecurityPermissionCollection", id=296)
    public IllegalArgumentException invalidPermission(Permission var1);

    @Message(value="Attempt to add a permission to a read-only SecurityPermissionCollection", id=297)
    public SecurityException readOnlyPermissionCollection();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Using internal security checker", id=298)
    public void authorizationEnabledWithoutSecurityManager();

    @Message(value="Unable to acquire lock after %s for key %s and requestor %s. Lock is held by %s", id=299)
    public TimeoutException unableToAcquireLock(String var1, Object var2, Object var3, Object var4);

    @Message(value="There was an exception while processing retrieval of entry values", id=300)
    public CacheException exceptionProcessingEntryRetrievalValues(@Cause Throwable var1);

    @Message(value="Iterator response for identifier %s encountered unexpected exception", id=301)
    public CacheException exceptionProcessingIteratorResponse(UUID var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Issue when retrieving transactions from %s, response was %s", id=302)
    public void unsuccessfulResponseRetrievingTransactionsForSegments(Address var1, Response var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="More than one configuration file with specified name on classpath. The first one will be used:\n %s", id=304)
    public void ambiguousConfigurationFiles(String var1);

    @Message(value="Cluster is operating in degraded mode because of node failures.", id=305)
    public AvailabilityException partitionDegraded();

    @Message(value="Key '%s' is not available. Not all owners are in this partition", id=306)
    public AvailabilityException degradedModeKeyUnavailable(Object var1);

    @Message(value="Cannot clear when the cluster is partitioned", id=307)
    public AvailabilityException clearDisallowedWhilePartitioned();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Rebalancing enabled", id=308)
    public void rebalancingEnabled();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Rebalancing suspended", id=309)
    public void rebalancingSuspended();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Starting cluster-wide rebalance for cache %s, topology %s", id=310)
    public void startRebalance(String var1, CacheTopology var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Received a command from an outdated topology, returning the exception to caller", id=311)
    public void outdatedTopology(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Cyclic dependency detected between caches, stop order ignored", id=321)
    public void stopOrderIgnored();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to re-start x-site state transfer to site %s", id=322)
    public void failedToRestartXSiteStateTransfer(String var1, @Cause Throwable var2);

    @Message(value="%s is in 'TERMINATED' state and so it does not accept new invocations. Either restart it or recreate the cache container.", id=323)
    public IllegalLifecycleStateException cacheIsTerminated(String var1);

    @Message(value="%s is in 'STOPPING' state and this is an invocation not belonging to an on-going transaction, so it does not accept new invocations. Either restart it or recreate the cache container.", id=324)
    public IllegalLifecycleStateException cacheIsStopping(String var1);

    @Message(value="Creating tmp cache %s timed out waiting for rebalancing to complete on node %s ", id=325)
    public RuntimeException creatingTmpCacheTimedOut(String var1, Address var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Remote transaction %s timed out. Rolling back after %d ms", id=326)
    public void remoteTransactionTimeout(GlobalTransaction var1, long var2);

    @Message(value="Cannot find a parser for element '%s' in namespace '%s'. Check that your configuration is up-to date for this version of Infinispan.", id=327)
    public CacheConfigurationException unsupportedConfiguration(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Finished local rebalance for cache %s on node %s, topology id = %d", id=328)
    public void rebalanceCompleted(String var1, Address var2, int var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to read rebalancing status from coordinator %s", id=329)
    public void errorReadingRebalancingStatus(Address var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Distributed task failed at %s. The task is failing over to be executed at %s", id=330)
    public void distributedTaskFailover(Address var1, Address var2, @Cause Exception var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to invoke method %s on Object instance %s ", id=331)
    public void unableToInvokeListenerMethod(Method var1, Object var2, @Cause Throwable var3);

    @Message(value="Remote transaction %s rolled back because originator is no longer in the cluster", id=332)
    public CacheException orphanTransactionRolledBack(GlobalTransaction var1);

    @Message(value="The site must be specified.", id=333)
    public CacheConfigurationException backupSiteNullName();

    @Message(value="Using a custom failure policy requires a failure policy class to be specified.", id=334)
    public CacheConfigurationException customBackupFailurePolicyClassNotSpecified();

    @Message(value="Two-phase commit can only be used with synchronous backup strategy.", id=335)
    public CacheConfigurationException twoPhaseCommitAsyncBackup();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Finished cluster-wide rebalance for cache %s, topology id = %d", id=336)
    public void clusterWideRebalanceCompleted(String var1, int var2);

    @Message(value="The 'site' must be specified!", id=337)
    public CacheConfigurationException backupMissingSite();

    @Message(value="It is required to specify a 'failurePolicyClass' when using a custom backup failure policy!", id=338)
    public CacheConfigurationException missingBackupFailurePolicyClass();

    @Message(value="Null name not allowed (use 'defaultRemoteCache()' in case you want to specify the default cache name).", id=339)
    public CacheConfigurationException backupForNullCache();

    @Message(value="Both 'remoteCache' and 'remoteSite' must be specified for a backup'!", id=340)
    public CacheConfigurationException backupForMissingParameters();

    @Message(value="Cannot configure async properties for an sync cache. Set the cache mode to async first.", id=341)
    public IllegalStateException asyncPropertiesConfigOnSyncCache();

    @Message(value="Cannot configure sync properties for an async cache. Set the cache mode to sync first.", id=342)
    public IllegalStateException syncPropertiesConfigOnAsyncCache();

    @Message(value="Must have a transport set in the global configuration in order to define a clustered cache", id=343)
    public CacheConfigurationException missingTransportConfiguration();

    @Message(value="reaperWakeUpInterval must be >= 0, we got %d", id=344)
    public CacheConfigurationException invalidReaperWakeUpInterval(long var1);

    @Message(value="completedTxTimeout must be >= 0, we got %d", id=345)
    public CacheConfigurationException invalidCompletedTxTimeout(long var1);

    @Message(value="Total Order based protocol not available for transaction mode %s", id=346)
    public CacheConfigurationException invalidTxModeForTotalOrder(TransactionMode var1);

    @Message(value="Cache mode %s is not supported by Total Order based protocol", id=347)
    public CacheConfigurationException invalidCacheModeForTotalOrder(String var1);

    @Message(value="Total Order based protocol not available with recovery", id=348)
    public CacheConfigurationException unavailableTotalOrderWithTxRecovery();

    @Message(value="Total Order based protocol not available with %s", id=349)
    public CacheConfigurationException invalidLockingModeForTotalOrder(LockingMode var1);

    @Message(value="Enabling the L1 cache is only supported when using DISTRIBUTED as a cache mode.  Your cache mode is set to %s", id=350)
    public CacheConfigurationException l1OnlyForDistributedCache(String var1);

    @Message(value="Using a L1 lifespan of 0 or a negative value is meaningless", id=351)
    public CacheConfigurationException l1InvalidLifespan();

    @Message(value="Use of the replication queue is invalid when using DISTRIBUTED mode.", id=352)
    public CacheConfigurationException noReplicationQueueDistributedCache();

    @Message(value="Use of the replication queue is only allowed with an ASYNCHRONOUS cluster mode.", id=353)
    public CacheConfigurationException replicationQueueOnlyForAsyncCaches();

    @Message(value="Cannot define both interceptor class (%s) and interceptor instance (%s)", id=354)
    public CacheConfigurationException interceptorClassAndInstanceDefined(String var1, String var2);

    @Message(value="Unable to instantiate loader/writer instance for StoreConfiguration %s", id=355)
    public CacheConfigurationException unableToInstantiateClass(Class<?> var1);

    @Message(value="Maximum data container size is currently 2^48 - 1, the number provided was %s", id=356)
    public CacheConfigurationException evictionSizeTooLarge(long var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="end() failed for %s", id=357)
    public void xaResourceEndFailed(XAResource var1, @Cause Throwable var2);

    @Message(value="A cache configuration named %s already exists. This cannot be configured externally by the user.", id=358)
    public CacheConfigurationException existingConfigForInternalCache(String var1);

    @Message(value="Keys '%s' are not available. Not all owners are in this partition", id=359)
    public AvailabilityException degradedModeKeysUnavailable(Collection<?> var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The xml element eviction-executor has been deprecated and replaced by expiration-executor, please update your configuration file.", id=360)
    public void evictionExecutorDeprecated();

    @Message(value="Cannot commit remote transaction %s as it was already rolled back", id=361)
    public CacheException remoteTransactionAlreadyRolledBack(GlobalTransaction var1);

    @Message(value="Could not find status for remote transaction %s, please increase transaction.completedTxTimeout", id=362)
    public TimeoutException remoteTransactionStatusMissing(GlobalTransaction var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="No filter indexing service provider found for filter of type %s", id=363)
    public void noFilterIndexingServiceProviderFound(String var1);

    @Message(value="Attempted to register cluster listener of class %s, but listener is annotated as only observing pre events!", id=364)
    public CacheException clusterListenerRegisteredWithOnlyPreEvents(Class<?> var1);

    @Message(value="Could not find the specified JGroups configuration file '%s'", id=365)
    public CacheConfigurationException jgroupsConfigurationNotFound(String var1);

    @Message(value="Unable to add a 'null' Custom Cache Store", id=366)
    public IllegalArgumentException unableToAddNullCustomStore();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="There was an issue with topology update for topology: %s", id=367)
    public void topologyUpdateError(int var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Memory approximation calculation for eviction is unsupported for the '%s' Java VM", id=368)
    public void memoryApproximationUnsupportedVM(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Ignoring asyncMarshalling configuration", id=369)
    public void ignoreAsyncMarshalling();

    @Message(value="Cache name '%s' cannot be used as it is a reserved, internal name", id=370)
    public IllegalArgumentException illegalCacheName(String var1);

    @Message(value="Cannot remove cache configuration '%s' because it is in use", id=371)
    public IllegalStateException configurationInUse(String var1);

    @Message(value="Statistics are enabled while attribute 'available' is set to false.", id=372)
    public CacheConfigurationException statisticsEnabledNotAvailable();

    @Message(value="Attempted to start a cache using configuration template '%s'", id=373)
    public CacheConfigurationException templateConfigurationStartAttempt(String var1);

    @Message(value="No such template '%s' when declaring '%s'", id=374)
    public CacheConfigurationException undeclaredConfiguration(String var1, String var2);

    @Message(value="Cannot use configuration '%s' as a template", id=375)
    public CacheConfigurationException noConfiguration(String var1);

    @Message(value="Interceptor stack is not supported in simple cache", id=376)
    public UnsupportedOperationException interceptorStackNotSupported();

    @Message(value="Explicit lock operations are not supported in simple cache", id=377)
    public UnsupportedOperationException lockOperationsNotSupported();

    @Message(value="Invocation batching not enabled in current configuration! Please enable it.", id=378)
    public CacheConfigurationException invocationBatchingNotEnabled();

    @Message(value="Map Reduce Framework is not supported in simple cache", id=379)
    public CacheConfigurationException mapReduceNotSupported();

    @Message(value="Distributed Executors Framework is not supported in simple cache", id=380)
    public CacheConfigurationException distributedExecutorsNotSupported();

    @Message(value="This configuration is not supported for simple cache", id=381)
    public CacheConfigurationException notSupportedInSimpleCache();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Global state persistence was enabled without specifying a location", id=382)
    public void missingGlobalStatePersistentLocation();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The eviction max-entries attribute has been deprecated. Please use the size attribute instead", id=383)
    public void evictionMaxEntriesDeprecated();

    @Message(value="Unable to broadcast invalidation messages", id=384)
    public RuntimeException unableToBroadcastInvalidation(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The data container class configuration has been deprecated.  This has no current replacement", id=385)
    public void dataContainerConfigurationDeprecated();

    @Message(value="Failed to read persisted state from file %s. Aborting.", id=386)
    public CacheConfigurationException failedReadingPersistentState(@Cause IOException var1, File var2);

    @Message(value="Failed to write state to file %s.", id=387)
    public CacheConfigurationException failedWritingGlobalState(@Cause IOException var1, File var2);

    @Message(value="The state file %s is not writable. Aborting.", id=388)
    public CacheConfigurationException nonWritableStateFile(File var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Loaded global state, version=%s timestamp=%s", id=389)
    public void globalStateLoad(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Persisted state, version=%s timestamp=%s", id=390)
    public void globalStateWrite(String var1, String var2);

    @Message(value="Recovery not supported with non transactional cache", id=391)
    public CacheConfigurationException recoveryNotSupportedWithNonTxCache();

    @Message(value="Recovery not supported with Synchronization", id=392)
    public CacheConfigurationException recoveryNotSupportedWithSynchronization();

    @Message(value="Recovery not supported with Asynchronous %s cache mode", id=393)
    public CacheConfigurationException recoveryNotSupportedWithAsync(String var1);

    @Message(value="Recovery not supported with asynchronous commit phase", id=394)
    public CacheConfigurationException recoveryNotSupportedWithAsyncCommit();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Transaction notifications are disabled.  This prevents cluster listeners from working properly!", id=395)
    public void transactionNotificationsDisabled();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Received unsolicited state from node %s for segment %d of cache %s", id=396)
    public void ignoringUnsolicitedState(Address var1, int var2, String var3);

    @Message(value="Could not migrate data for cache %s, check remote store config in the target cluster", id=397)
    public CacheException couldNotMigrateData(String var1);

    @Message(value="CH Factory '%s' cannot restore a persisted CH of class '%s'", id=398)
    public IllegalStateException persistentConsistentHashMismatch(String var1, String var2);

    @Message(value="Timeout while waiting for %d members in cluster. Last view had %s", id=399)
    public TimeoutException timeoutWaitingForInitialNodes(int var1, List<?> var2);

    @Message(value="Node %s was suspected", id=400)
    public SuspectException remoteNodeSuspected(Address var1);

    @Message(value="Node %s timed out, time : %s %s", id=401)
    public TimeoutException remoteNodeTimedOut(Address var1, long var2, TimeUnit var4);

    @Message(value="Timeout waiting for view %d. Current view is %d, current status is %s", id=402)
    public TimeoutException timeoutWaitingForView(int var1, int var2, Object var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="No indexable classes were defined for this indexed cache; switching to autodetection (support for autodetection will be removed in Infinispan 9.0).", id=403)
    public void noIndexableClassesDefined();

    @Message(value="The configured entity class %s is not indexable. Please remove it from the indexing configuration.", id=404)
    public CacheConfigurationException classNotIndexable(String var1);
}

