/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.collections;

import com.google.common.base.Function;
import java.util.Iterator;

public final class Iterables {
    private Iterables() {
    }

    public static <T> String toMultiRowString(Iterable<T> iterable) {
        StringBuilder builder = new StringBuilder("\n  - ");
        Iterator<T> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            T element = iterator.next();
            builder.append(element);
            if (!iterator.hasNext()) continue;
            builder.append(",\n  - ");
        }
        return builder.toString();
    }

    public static <F, T> Iterable<T> flatMap(Iterable<F> iterable, Function<F, Iterable<T>> function) {
        return com.google.common.collect.Iterables.concat((Iterable)com.google.common.collect.Iterables.transform(iterable, function));
    }
}

