/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.id;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.id.AbstractIdMapper;
import org.hibernate.envers.internal.entities.mapper.id.IdMapper;
import org.hibernate.envers.internal.entities.mapper.id.QueryParameterData;
import org.hibernate.envers.internal.entities.mapper.id.SimpleIdMapperBuilder;
import org.hibernate.envers.internal.tools.ReflectionTools;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.service.ServiceRegistry;

public class SingleIdMapper
extends AbstractIdMapper
implements SimpleIdMapperBuilder {
    private PropertyData propertyData;

    public SingleIdMapper(ServiceRegistry serviceRegistry) {
        super(serviceRegistry);
    }

    public SingleIdMapper(ServiceRegistry serviceRegistry, PropertyData propertyData) {
        this(serviceRegistry);
        this.propertyData = propertyData;
    }

    @Override
    public void add(PropertyData propertyData) {
        if (this.propertyData != null) {
            throw new AuditException("Only one property can be added!");
        }
        this.propertyData = propertyData;
    }

    @Override
    public boolean mapToEntityFromMap(Object obj, Map data) {
        if (data == null || obj == null) {
            return false;
        }
        Object value = data.get(this.propertyData.getName());
        if (value == null) {
            return false;
        }
        Setter setter = ReflectionTools.getSetter(obj.getClass(), this.propertyData, this.getServiceRegistry());
        setter.set(obj, value, null);
        return true;
    }

    @Override
    public Object mapToIdFromMap(Map data) {
        if (data == null) {
            return null;
        }
        return data.get(this.propertyData.getName());
    }

    @Override
    public Object mapToIdFromEntity(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof HibernateProxy) {
            HibernateProxy hibernateProxy = (HibernateProxy)data;
            return hibernateProxy.getHibernateLazyInitializer().getIdentifier();
        }
        Getter getter = ReflectionTools.getGetter(data.getClass(), this.propertyData, this.getServiceRegistry());
        return getter.get(data);
    }

    @Override
    public void mapToMapFromId(Map<String, Object> data, Object obj) {
        if (data != null) {
            data.put(this.propertyData.getName(), obj);
        }
    }

    @Override
    public void mapToMapFromEntity(Map<String, Object> data, Object obj) {
        if (obj == null) {
            data.put(this.propertyData.getName(), null);
        } else if (obj instanceof HibernateProxy) {
            HibernateProxy hibernateProxy = (HibernateProxy)obj;
            data.put(this.propertyData.getName(), hibernateProxy.getHibernateLazyInitializer().getIdentifier());
        } else {
            Getter getter = ReflectionTools.getGetter(obj.getClass(), this.propertyData, this.getServiceRegistry());
            data.put(this.propertyData.getName(), getter.get(obj));
        }
    }

    public void mapToEntityFromEntity(Object objTo, Object objFrom) {
        if (objTo == null || objFrom == null) {
            return;
        }
        Getter getter = ReflectionTools.getGetter(objFrom.getClass(), this.propertyData, this.getServiceRegistry());
        Setter setter = ReflectionTools.getSetter(objTo.getClass(), this.propertyData, this.getServiceRegistry());
        setter.set(objTo, getter.get(objFrom), null);
    }

    @Override
    public IdMapper prefixMappedProperties(String prefix) {
        return new SingleIdMapper(this.getServiceRegistry(), new PropertyData(prefix + this.propertyData.getName(), this.propertyData));
    }

    @Override
    public List<QueryParameterData> mapToQueryParametersFromId(Object obj) {
        ArrayList<QueryParameterData> ret = new ArrayList<QueryParameterData>();
        ret.add(new QueryParameterData(this.propertyData.getName(), obj));
        return ret;
    }
}

