/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.engine.impl;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.similarities.Similarity;
import org.hibernate.search.engine.impl.FilterDef;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.metadata.impl.EmbeddedTypeMetadata;
import org.hibernate.search.engine.metadata.impl.PropertyMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.filter.FilterKey;
import org.hibernate.search.filter.FullTextFilterImplementor;
import org.hibernate.search.filter.ShardSensitiveOnlyFilter;
import org.hibernate.search.filter.StandardFilterKey;
import org.hibernate.search.filter.impl.CachingWrapperFilter;
import org.hibernate.search.filter.impl.ChainedFilter;
import org.hibernate.search.filter.impl.DefaultFilterKey;
import org.hibernate.search.filter.impl.FullTextFilterImpl;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.query.engine.impl.AbstractHSQuery;
import org.hibernate.search.query.engine.impl.DocumentExtractorImpl;
import org.hibernate.search.query.engine.impl.FacetManagerImpl;
import org.hibernate.search.query.engine.impl.LazyQueryState;
import org.hibernate.search.query.engine.impl.QueryHits;
import org.hibernate.search.query.engine.impl.SortConfigurations;
import org.hibernate.search.query.engine.impl.TimeoutManagerImpl;
import org.hibernate.search.query.engine.spi.DocumentExtractor;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.reader.impl.MultiReaderFactory;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.impl.FilterCacheModeTypeHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class LuceneHSQuery
extends AbstractHSQuery
implements HSQuery {
    static final Log log = LoggerFactory.make();
    private static final FullTextFilterImplementor[] EMPTY_FULL_TEXT_FILTER_IMPLEMENTOR = new FullTextFilterImplementor[0];
    private Query luceneQuery;
    private boolean allowFieldSelectionInProjection = true;
    private Filter filter;
    private transient Set<Class<?>> classesAndSubclasses;
    private boolean needClassFilterClause;
    private Set<String> idFieldNames;
    private transient FacetManagerImpl facetManager;
    private Integer resultSize;

    public LuceneHSQuery(ExtendedSearchIntegrator extendedIntegrator) {
        super(extendedIntegrator);
    }

    @Override
    public HSQuery luceneQuery(Query query) {
        this.clearCachedResults();
        this.luceneQuery = query;
        return this;
    }

    @Override
    protected TimeoutManagerImpl buildTimeoutManager() {
        if (this.luceneQuery == null) {
            throw new AssertionFailure("Requesting TimeoutManager before setting luceneQuery()");
        }
        return new TimeoutManagerImpl(this.luceneQuery, this.timeoutExceptionFactory, this.extendedIntegrator.getTimingSource());
    }

    @Override
    public FacetManagerImpl getFacetManager() {
        if (this.facetManager == null) {
            this.facetManager = new FacetManagerImpl(this);
        }
        return this.facetManager;
    }

    @Override
    public Query getLuceneQuery() {
        return this.luceneQuery;
    }

    @Override
    public List<EntityInfo> queryEntityInfos() {
        LazyQueryState searcher = this.buildSearcher();
        if (searcher == null) {
            return Collections.emptyList();
        }
        try {
            int size;
            QueryHits queryHits = this.getQueryHits(searcher, this.calculateTopDocsRetrievalSize());
            int first = this.firstResult;
            int max = this.max(first, queryHits.getTotalHits());
            int n = size = max - first + 1 < 0 ? 0 : max - first + 1;
            if (size == 0) {
                List<EntityInfo> list = Collections.emptyList();
                return list;
            }
            ArrayList<EntityInfo> infos = new ArrayList<EntityInfo>(size);
            DocumentExtractor extractor = this.buildDocumentExtractor(searcher, queryHits, first, max);
            for (int index = first; index <= max; ++index) {
                infos.add(extractor.extract(index));
                if (index % 10 != 0) continue;
                this.getTimeoutManager().isTimedOut();
            }
            ArrayList<EntityInfo> arrayList = infos;
            return arrayList;
        }
        catch (IOException e) {
            throw new SearchException("Unable to query Lucene index", e);
        }
        finally {
            this.closeSearcher(searcher);
        }
    }

    private DocumentExtractor buildDocumentExtractor(LazyQueryState searcher, QueryHits queryHits, int first, int max) {
        return new DocumentExtractorImpl(queryHits, this.extendedIntegrator, this.projectedFields, this.idFieldNames, this.allowFieldSelectionInProjection, searcher, first, max, this.classesAndSubclasses);
    }

    @Override
    public DocumentExtractor queryDocumentExtractor() {
        LazyQueryState openSearcher = this.buildSearcher();
        try {
            QueryHits queryHits = this.getQueryHits(openSearcher, this.calculateTopDocsRetrievalSize());
            int max = this.max(this.firstResult, queryHits.getTotalHits());
            return this.buildDocumentExtractor(openSearcher, queryHits, this.firstResult, max);
        }
        catch (IOException e) {
            this.closeSearcher(openSearcher);
            throw new SearchException("Unable to query Lucene index", e);
        }
    }

    @Override
    public int queryResultSize() {
        if (this.resultSize == null) {
            this.getTimeoutManager().start();
            LazyQueryState searcher = this.buildSearcher(this.extendedIntegrator, false);
            if (searcher == null) {
                this.resultSize = 0;
            } else {
                try {
                    QueryHits queryHits = this.getQueryHits(searcher, 0);
                    this.resultSize = queryHits.getTotalHits();
                }
                catch (IOException e) {
                    throw new SearchException("Unable to query Lucene index", e);
                }
                finally {
                    this.closeSearcher(searcher);
                }
            }
        }
        return this.resultSize;
    }

    @Override
    public Explanation explain(int documentId) {
        Explanation explanation = null;
        LazyQueryState searcher = this.buildSearcher(this.extendedIntegrator, true);
        if (searcher == null) {
            throw new SearchException("Unable to build explanation for document id:" + documentId + ". no index found");
        }
        try {
            Query filteredQuery = this.filterQueryByTenantId(this.filterQueryByClasses(this.luceneQuery));
            this.buildFilters();
            explanation = searcher.explain(filteredQuery, documentId);
        }
        catch (IOException e) {
            throw new SearchException("Unable to query Lucene index and build explanation", e);
        }
        finally {
            this.closeSearcher(searcher);
        }
        return explanation;
    }

    private void closeSearcher(LazyQueryState searcherWithPayload) {
        if (searcherWithPayload == null) {
            return;
        }
        searcherWithPayload.close();
    }

    @Override
    protected void clearCachedResults() {
        this.resultSize = null;
    }

    @Override
    protected void extractFacetResults() {
        DocumentExtractor queryDocumentExtractor = this.queryDocumentExtractor();
        queryDocumentExtractor.close();
    }

    private QueryHits getQueryHits(LazyQueryState searcher, Integer n) throws IOException {
        this.buildFilters();
        boolean stats = this.extendedIntegrator.getStatistics().isStatisticsEnabled();
        long startTime = 0L;
        if (stats) {
            startTime = System.nanoTime();
        }
        QueryHits queryHits = n == null ? new QueryHits(searcher, this.filter, this.sort, this.getTimeoutManager(), this.facetManager.getFacetRequests(), this.timeoutExceptionFactory, this.spatialSearchCenter, this.spatialFieldName) : (0 == n ? new QueryHits(searcher, this.filter, null, 0, this.getTimeoutManager(), null, this.timeoutExceptionFactory, this.spatialSearchCenter, this.spatialFieldName) : new QueryHits(searcher, this.filter, this.sort, n, this.getTimeoutManager(), this.facetManager.getFacetRequests(), this.timeoutExceptionFactory, this.spatialSearchCenter, this.spatialFieldName));
        this.resultSize = queryHits.getTotalHits();
        if (stats) {
            this.extendedIntegrator.getStatisticsImplementor().searchExecuted(searcher.describeQuery(), System.nanoTime() - startTime);
        }
        this.facetManager.setFacetResults(queryHits.getFacets());
        return queryHits;
    }

    private Integer calculateTopDocsRetrievalSize() {
        if (this.maxResults == null) {
            return null;
        }
        long tmpMaxResult = (long)this.firstResult + (long)this.maxResults.intValue();
        if (tmpMaxResult >= Integer.MAX_VALUE) {
            return 0x7FFFFFFE;
        }
        if (tmpMaxResult == 0L) {
            return 1;
        }
        return (int)tmpMaxResult;
    }

    private LazyQueryState buildSearcher() {
        return this.buildSearcher(this.extendedIntegrator, null);
    }

    private LazyQueryState buildSearcher(ExtendedSearchIntegrator extendedIntegrator, Boolean forceScoring) {
        Map<Class<?>, EntityIndexBinding> indexBindings = extendedIntegrator.getIndexBindings();
        HashSet<IndexManager> targetedIndexes = new HashSet<IndexManager>();
        HashSet<String> idFieldNames = new HashSet<String>();
        Similarity searcherSimilarity = null;
        SortConfigurations.Builder sortConfigurations = new SortConfigurations.Builder();
        if (this.indexedTargetedEntities.size() == 0) {
            if (indexBindings.isEmpty()) {
                throw new SearchException("There are no mapped entities. Don't forget to add @Indexed to at least one class.");
            }
            for (EntityIndexBinding entityIndexBinding : indexBindings.values()) {
                DocumentBuilderIndexedEntity builder = entityIndexBinding.getDocumentBuilder();
                searcherSimilarity = this.checkSimilarity(searcherSimilarity, entityIndexBinding.getSimilarity());
                if (builder.getIdKeywordName() != null) {
                    idFieldNames.add(builder.getIdKeywordName());
                    this.allowFieldSelectionInProjection = this.allowFieldSelectionInProjection && builder.allowFieldSelectionInProjection();
                }
                List<IndexManager> indexManagers = this.getIndexManagers(entityIndexBinding);
                targetedIndexes.addAll(indexManagers);
                this.collectSortableFields(sortConfigurations, indexManagers, entityIndexBinding.getDocumentBuilder().getTypeMetadata());
            }
            this.classesAndSubclasses = null;
        } else {
            HashSet involvedClasses = new HashSet(this.indexedTargetedEntities.size());
            involvedClasses.addAll(this.indexedTargetedEntities);
            for (Class clazz : this.indexedTargetedEntities) {
                EntityIndexBinding indexBinder = indexBindings.get(clazz);
                if (indexBinder == null) continue;
                DocumentBuilderIndexedEntity documentBuilderIndexedEntity = indexBinder.getDocumentBuilder();
                involvedClasses.addAll(documentBuilderIndexedEntity.getMappedSubclasses());
            }
            Iterator iterator = involvedClasses.iterator();
            while (iterator.hasNext()) {
                Class clazz;
                clazz = (Class)iterator.next();
                EntityIndexBinding entityIndexBinding2 = indexBindings.get(clazz);
                if (entityIndexBinding2 == null) {
                    throw new SearchException("Not a mapped entity (don't forget to add @Indexed): " + clazz);
                }
                DocumentBuilderIndexedEntity documentBuilderIndexedEntity = entityIndexBinding2.getDocumentBuilder();
                if (documentBuilderIndexedEntity.getIdKeywordName() != null) {
                    idFieldNames.add(documentBuilderIndexedEntity.getIdKeywordName());
                    this.allowFieldSelectionInProjection = this.allowFieldSelectionInProjection && documentBuilderIndexedEntity.allowFieldSelectionInProjection();
                }
                List<IndexManager> indexManagers = this.getIndexManagers(entityIndexBinding2);
                targetedIndexes.addAll(indexManagers);
                this.collectSortableFields(sortConfigurations, indexManagers, documentBuilderIndexedEntity.getTypeMetadata());
                searcherSimilarity = this.checkSimilarity(searcherSimilarity, entityIndexBinding2.getSimilarity());
            }
            this.classesAndSubclasses = involvedClasses;
        }
        this.idFieldNames = idFieldNames;
        if (this.classesAndSubclasses != null) {
            for (IndexManager indexManager : targetedIndexes) {
                Set<Class<?>> classesInIndexManager = indexManager.getContainedTypes();
                if (classesInIndexManager.size() > 1) {
                    for (Class clazz : classesInIndexManager) {
                        if (this.classesAndSubclasses.contains(clazz)) continue;
                        this.needClassFilterClause = true;
                        break;
                    }
                }
                if (!this.needClassFilterClause) continue;
                break;
            }
        } else {
            this.classesAndSubclasses = extendedIntegrator.getIndexedTypes();
        }
        if (this.sort != null) {
            this.validateSortFields(extendedIntegrator, this.classesAndSubclasses);
        }
        IndexManager[] indexManagers = targetedIndexes.toArray(new IndexManager[targetedIndexes.size()]);
        IndexReader indexReader = MultiReaderFactory.openReader(sortConfigurations.build(), this.sort, indexManagers, extendedIntegrator.isIndexUninvertingAllowed());
        Query filteredQuery = this.filterQueryByTenantId(this.filterQueryByClasses(this.luceneQuery));
        String[] projection = this.projectedFields;
        if (Boolean.TRUE.equals(forceScoring)) {
            return new LazyQueryState(filteredQuery, indexReader, searcherSimilarity, extendedIntegrator, this.classesAndSubclasses, true, true);
        }
        if (Boolean.FALSE.equals(forceScoring)) {
            return new LazyQueryState(filteredQuery, indexReader, searcherSimilarity, extendedIntegrator, this.classesAndSubclasses, false, false);
        }
        if (this.sort != null && projection != null) {
            boolean bl;
            boolean bl2 = false;
            for (String field : projection) {
                if (!"__HSearch_Score".equals(field)) continue;
                bl = true;
                break;
            }
            if (bl) {
                return new LazyQueryState(filteredQuery, indexReader, searcherSimilarity, extendedIntegrator, this.classesAndSubclasses, true, false);
            }
        }
        return new LazyQueryState(filteredQuery, indexReader, searcherSimilarity, extendedIntegrator, this.classesAndSubclasses, false, false);
    }

    private void collectSortableFields(SortConfigurations.Builder sortConfigurations, Iterable<IndexManager> indexManagers, TypeMetadata typeMetadata) {
        for (IndexManager indexManager : indexManagers) {
            sortConfigurations.setIndex(indexManager.getIndexName());
            sortConfigurations.setEntityType(typeMetadata.getType());
            sortConfigurations.addSortableFields(typeMetadata.getClassBridgeSortableFieldMetadata());
            sortConfigurations.addSortableFields(typeMetadata.getIdPropertyMetadata().getSortableFieldMetadata());
            for (PropertyMetadata property : typeMetadata.getAllPropertyMetadata()) {
                sortConfigurations.addSortableFields(property.getSortableFieldMetadata());
            }
            for (EmbeddedTypeMetadata embeddedType : typeMetadata.getEmbeddedTypeMetadata()) {
                this.collectSortableFields(sortConfigurations, embeddedType);
            }
        }
    }

    private void collectSortableFields(SortConfigurations.Builder sortConfigurations, EmbeddedTypeMetadata embeddedTypeMetadata) {
        sortConfigurations.addSortableFields(embeddedTypeMetadata.getClassBridgeSortableFieldMetadata());
        for (PropertyMetadata property : embeddedTypeMetadata.getAllPropertyMetadata()) {
            sortConfigurations.addSortableFields(property.getSortableFieldMetadata());
        }
        for (EmbeddedTypeMetadata embeddedType : embeddedTypeMetadata.getEmbeddedTypeMetadata()) {
            this.collectSortableFields(sortConfigurations, embeddedType);
        }
    }

    private Similarity checkSimilarity(Similarity similarity, Similarity entitySimilarity) {
        if (similarity == null) {
            similarity = entitySimilarity;
        } else if (!similarity.getClass().equals(entitySimilarity.getClass())) {
            throw new SearchException("Cannot perform search on two entities with differing Similarity implementations (" + similarity.getClass().getName() + " & " + entitySimilarity.getClass().getName() + ")");
        }
        return similarity;
    }

    private List<IndexManager> getIndexManagers(EntityIndexBinding binding) {
        FullTextFilterImplementor[] fullTextFilters = this.getFullTextFilters();
        List<IndexManager> indexManagers = Arrays.asList(binding.getSelectionStrategy().getIndexManagersForQuery(fullTextFilters));
        for (IndexManager indexManager : indexManagers) {
            if (indexManager instanceof DirectoryBasedIndexManager) continue;
            throw log.cannotRunLuceneQueryTargetingEntityIndexedWithNonDirectoryBasedIndexManager(binding.getDocumentBuilder().getBeanClass(), this.luceneQuery.toString());
        }
        return indexManagers;
    }

    private FullTextFilterImplementor[] getFullTextFilters() {
        FullTextFilterImplementor[] fullTextFilters = this.filterDefinitions != null && !this.filterDefinitions.isEmpty() ? this.filterDefinitions.values().toArray(new FullTextFilterImplementor[this.filterDefinitions.size()]) : EMPTY_FULL_TEXT_FILTER_IMPLEMENTOR;
        return fullTextFilters;
    }

    private void buildFilters() {
        ChainedFilter chainedFilter = new ChainedFilter();
        if (!this.filterDefinitions.isEmpty()) {
            for (FullTextFilterImpl fullTextFilter : this.filterDefinitions.values()) {
                Filter filter = this.buildLuceneFilter(fullTextFilter);
                if (filter == null) continue;
                chainedFilter.addFilter(filter);
            }
        }
        if (this.userFilter != null) {
            chainedFilter.addFilter(this.userFilter);
        }
        if (this.getFacetManager().getFacetFilter() != null) {
            chainedFilter.addFilter(this.facetManager.getFacetFilter());
        }
        this.filter = chainedFilter.isEmpty() ? null : chainedFilter;
    }

    private Filter buildLuceneFilter(FullTextFilterImpl fullTextFilter) {
        FilterDef def = this.extendedIntegrator.getFilterDefinition(fullTextFilter.getName());
        if (this.isPreQueryFilterOnly(def)) {
            return null;
        }
        if (!FilterCacheModeTypeHelper.cacheInstance(def.getCacheMode())) {
            Object filterOrFactory = this.createFilterInstance(fullTextFilter, def);
            return this.createFilter(def, filterOrFactory);
        }
        return this.createOrGetLuceneFilterFromCache(fullTextFilter, def);
    }

    private Filter createOrGetLuceneFilterFromCache(FullTextFilterImpl fullTextFilter, FilterDef def) {
        boolean hasCustomKey = def.getKeyMethod() != null;
        Object filterOrFactory = hasCustomKey ? this.createFilterInstance(fullTextFilter, def) : null;
        FilterKey key = this.createFilterKey(def, filterOrFactory, fullTextFilter);
        Filter filter = this.extendedIntegrator.getFilterCachingStrategy().getCachedFilter(key);
        if (filter == null) {
            filter = this.createFilter(def, hasCustomKey ? filterOrFactory : this.createFilterInstance(fullTextFilter, def));
            this.extendedIntegrator.getFilterCachingStrategy().addCachedFilter(key, filter);
        }
        return filter;
    }

    private boolean isPreQueryFilterOnly(FilterDef def) {
        return def.getImpl().equals(ShardSensitiveOnlyFilter.class);
    }

    private Filter createFilter(FilterDef def, Object filterOrFactory) {
        Filter filter;
        if (def.getFactoryMethod() != null) {
            try {
                filter = (Filter)def.getFactoryMethod().invoke(filterOrFactory, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new SearchException("Unable to access @Factory method: " + def.getImpl().getName() + "." + def.getFactoryMethod().getName(), e);
            }
            catch (ClassCastException e) {
                throw new SearchException("Factory method does not return a org.apache.lucene.search.Filter class: " + def.getImpl().getName() + "." + def.getFactoryMethod().getName(), e);
            }
        }
        try {
            filter = (Filter)filterOrFactory;
        }
        catch (ClassCastException e) {
            throw new SearchException("Filter implementation does not implement the Filter interface: " + def.getImpl().getName() + ". " + (def.getFactoryMethod() != null ? def.getFactoryMethod().getName() : ""), e);
        }
        filter = this.addCachingWrapperFilter(filter, def);
        return filter;
    }

    private Filter addCachingWrapperFilter(Filter filter, FilterDef def) {
        if (FilterCacheModeTypeHelper.cacheResults(def.getCacheMode())) {
            int cachingWrapperFilterSize = this.extendedIntegrator.getFilterCacheBitResultsSize();
            filter = new CachingWrapperFilter(filter, cachingWrapperFilterSize);
        }
        return filter;
    }

    private FilterKey createFilterKey(FilterDef def, Object filterOrFactory, FullTextFilterImpl fullTextFilter) {
        FilterKey key = null;
        if (def.getKeyMethod() == null) {
            key = new DefaultFilterKey(def.getName(), fullTextFilter.getParameters());
        } else {
            try {
                key = (FilterKey)def.getKeyMethod().invoke(filterOrFactory, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new SearchException("Unable to access @Key method: " + def.getImpl().getName() + "." + def.getKeyMethod().getName());
            }
            catch (ClassCastException e) {
                throw new SearchException("@Key method does not return FilterKey: " + def.getImpl().getName() + "." + def.getKeyMethod().getName());
            }
            key.setImpl(def.getImpl());
            StandardFilterKey wrapperKey = new StandardFilterKey();
            wrapperKey.addParameter(def.getName());
            wrapperKey.addParameter(key);
            key = wrapperKey;
        }
        return key;
    }

    private Object createFilterInstance(FullTextFilterImpl fullTextFilter, FilterDef def) {
        Object instance = ClassLoaderHelper.instanceFromClass(Object.class, def.getImpl(), "@FullTextFilterDef");
        for (Map.Entry<String, Object> entry : fullTextFilter.getParameters().entrySet()) {
            def.invoke(entry.getKey(), instance, entry.getValue());
        }
        return instance;
    }

    private Query filterQueryByClasses(Query luceneQuery) {
        if (!this.needClassFilterClause) {
            return luceneQuery;
        }
        BooleanQuery.Builder classFilterBuilder = new BooleanQuery.Builder();
        for (Class<?> clazz : this.classesAndSubclasses) {
            Term t = new Term("_hibernate_class", clazz.getName());
            TermQuery termQuery = new TermQuery(t);
            classFilterBuilder.add((Query)termQuery, BooleanClause.Occur.SHOULD);
        }
        BooleanQuery classFilter = classFilterBuilder.build();
        BooleanQuery.Builder combinedQueryBuilder = new BooleanQuery.Builder();
        combinedQueryBuilder.add(luceneQuery, BooleanClause.Occur.MUST);
        combinedQueryBuilder.add((Query)classFilter, BooleanClause.Occur.FILTER);
        return combinedQueryBuilder.build();
    }

    private Query filterQueryByTenantId(Query luceneQuery) {
        if (this.tenantId == null) {
            return luceneQuery;
        }
        TermQuery tenantIdFilter = new TermQuery(new Term("__HSearch_TenantId", this.tenantId));
        tenantIdFilter.setBoost(0.0f);
        BooleanQuery.Builder combinedQueryBuilder = new BooleanQuery.Builder();
        combinedQueryBuilder.add(luceneQuery, BooleanClause.Occur.MUST);
        combinedQueryBuilder.add((Query)tenantIdFilter, BooleanClause.Occur.FILTER);
        return combinedQueryBuilder.build();
    }

    private int max(int first, int totalHits) {
        if (this.maxResults == null) {
            return totalHits - 1;
        }
        return this.maxResults + first < totalHits ? first + this.maxResults - 1 : totalHits - 1;
    }
}

