/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.hibernate.search.analyzer.impl.AnalyzerReference;
import org.hibernate.search.analyzer.impl.LuceneAnalyzerReference;
import org.hibernate.search.util.impl.ScopedAnalyzer;

public final class ScopedAnalyzerReference
implements AnalyzerReference {
    private final Map<String, AnalyzerReference> analyzers;
    private final AnalyzerReference globalAnalyzer;

    private ScopedAnalyzerReference(AnalyzerReference globalAnalyzer, Map<String, AnalyzerReference> analyzers) {
        this.globalAnalyzer = globalAnalyzer;
        this.analyzers = Collections.unmodifiableMap(analyzers);
    }

    private static Analyzer luceneAnalyzer(AnalyzerReference scopedAnalyzer) {
        Analyzer analyzer = scopedAnalyzer.unwrap(LuceneAnalyzerReference.class).getAnalyzer();
        return analyzer;
    }

    public boolean isCompositeOfSameInstances(ScopedAnalyzerReference other) {
        if (this.globalAnalyzer != other.globalAnalyzer) {
            return false;
        }
        if (this.analyzers.size() != other.analyzers.size()) {
            return false;
        }
        for (String fieldname : this.analyzers.keySet()) {
            if (this.analyzers.get(fieldname) == other.analyzers.get(fieldname)) continue;
            return false;
        }
        return true;
    }

    @Override
    public <T extends AnalyzerReference> boolean is(Class<T> analyzerType) {
        return ScopedAnalyzerReference.class.isAssignableFrom(analyzerType);
    }

    @Override
    public <T extends AnalyzerReference> T unwrap(Class<T> analyzerType) {
        if (LuceneAnalyzerReference.class.isAssignableFrom(analyzerType)) {
            return (T)new LuceneAnalyzerReference((Analyzer)ScopedAnalyzerReference.createScopedAnalyzer(this.globalAnalyzer, this.analyzers));
        }
        return (T)this;
    }

    private static ScopedAnalyzer createScopedAnalyzer(AnalyzerReference globalAnalyzer, Map<String, AnalyzerReference> analyzers) {
        ScopedAnalyzer analyzer = ScopedAnalyzerReference.createScopedAnalyzer(globalAnalyzer);
        for (Map.Entry<String, AnalyzerReference> entry : analyzers.entrySet()) {
            if (!entry.getValue().is(LuceneAnalyzerReference.class)) continue;
            analyzer.addScopedAnalyzer(entry.getKey(), ScopedAnalyzerReference.luceneAnalyzer(entry.getValue()));
        }
        return analyzer;
    }

    private static ScopedAnalyzer createScopedAnalyzer(AnalyzerReference globalAnalyzer) {
        Analyzer analyzer = globalAnalyzer.is(LuceneAnalyzerReference.class) ? ScopedAnalyzerReference.luceneAnalyzer(globalAnalyzer) : null;
        return new ScopedAnalyzer(analyzer);
    }

    @Override
    public void close() {
        if (this.globalAnalyzer != null) {
            this.globalAnalyzer.close();
        }
        for (AnalyzerReference entry : this.analyzers.values()) {
            entry.close();
        }
    }

    public static class Builder {
        private final Map<String, AnalyzerReference> analyzers;
        private AnalyzerReference globalAnalyzer;

        public Builder(ScopedAnalyzerReference original) {
            this.analyzers = new HashMap<String, AnalyzerReference>(original.analyzers);
            this.globalAnalyzer = original.globalAnalyzer;
        }

        public Builder(AnalyzerReference globalAnalyzer) {
            this.analyzers = new HashMap<String, AnalyzerReference>();
            this.globalAnalyzer = globalAnalyzer;
        }

        public Builder addAnalyzer(String scope, AnalyzerReference analyzer) {
            this.analyzers.put(scope, analyzer);
            return this;
        }

        public Builder setGlobalAnalyzer(AnalyzerReference globalAnalyzer) {
            this.globalAnalyzer = globalAnalyzer;
            return this;
        }

        public ScopedAnalyzerReference build() {
            return new ScopedAnalyzerReference(this.globalAnalyzer, this.analyzers);
        }
    }
}

