/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.river;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import org.jboss.marshalling.MarshallerObjectInputStream;
import org.jboss.marshalling.TraceInformation;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.reflect.SerializableField;
import org.jboss.marshalling.river.BlockUnmarshaller;
import org.jboss.marshalling.river.RiverUnmarshaller;
import org.jboss.marshalling.river.SerializableClassDescriptor;
import org.jboss.marshalling.util.BooleanReadField;
import org.jboss.marshalling.util.ByteReadField;
import org.jboss.marshalling.util.CharReadField;
import org.jboss.marshalling.util.DoubleReadField;
import org.jboss.marshalling.util.FloatReadField;
import org.jboss.marshalling.util.IntReadField;
import org.jboss.marshalling.util.LongReadField;
import org.jboss.marshalling.util.ObjectReadField;
import org.jboss.marshalling.util.ReadField;
import org.jboss.marshalling.util.ShortReadField;

class RiverObjectInputStream
extends MarshallerObjectInputStream {
    private static final int OFF = 0;
    private static final int UNREAD_FIELDS = 1;
    private static final int UNREAD_FIELDS_EOB = 2;
    private static final int ON = 3;
    private final RiverUnmarshaller unmarshaller;
    private final BlockUnmarshaller blockUnmarshaller;
    private int state = 0;
    private SerializableClassDescriptor serializableClassDescriptor;
    private Object current;
    private int restoreIdx;

    protected RiverObjectInputStream(RiverUnmarshaller riverUnmarshaller, BlockUnmarshaller delegateUnmarshaller) throws IOException, SecurityException {
        super((Unmarshaller)delegateUnmarshaller);
        this.unmarshaller = riverUnmarshaller;
        this.blockUnmarshaller = delegateUnmarshaller;
    }

    private int getAndSet(int set) {
        try {
            int n = this.state;
            return n;
        }
        finally {
            this.state = set;
        }
    }

    public void defaultReadObject() throws IOException, ClassNotFoundException {
        int old = this.getAndSet(3);
        switch (old) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new NotActiveException("readFields() may only be called when the fields have not yet been read");
            }
        }
        try {
            this.unmarshaller.readFields(this.current, this.serializableClassDescriptor, false);
            if (old == 2) {
                this.restoreIdx = this.blockUnmarshaller.tempEndOfStream();
            }
        }
        finally {
            this.serializableClassDescriptor = null;
            this.current = null;
        }
    }

    void discardReadObject() throws IOException {
        int old = this.getAndSet(3);
        switch (old) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new NotActiveException("readFields() may only be called when the fields have not yet been read");
            }
        }
        try {
            this.unmarshaller.discardFields(this.serializableClassDescriptor);
            if (old == 2) {
                this.restoreIdx = this.blockUnmarshaller.tempEndOfStream();
            }
        }
        finally {
            this.serializableClassDescriptor = null;
            this.current = null;
        }
    }

    public ObjectInputStream.GetField readFields() throws IOException, ClassNotFoundException {
        int old = this.getAndSet(3);
        switch (old) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new NotActiveException("readFields() may only be called when the fields have not yet been read");
            }
        }
        SerializableField[] streamFields = this.serializableClassDescriptor.getFields();
        int cnt = streamFields.length;
        final ReadField[] readFields = new ReadField[cnt];
        for (int i = 0; i < cnt; ++i) {
            SerializableField field = streamFields[i];
            try {
                switch (field.getKind()) {
                    case BOOLEAN: {
                        readFields[i] = new BooleanReadField(field, this.unmarshaller.readBoolean());
                        break;
                    }
                    case BYTE: {
                        readFields[i] = new ByteReadField(field, this.unmarshaller.readByte());
                        break;
                    }
                    case CHAR: {
                        readFields[i] = new CharReadField(field, this.unmarshaller.readChar());
                        break;
                    }
                    case DOUBLE: {
                        readFields[i] = new DoubleReadField(field, this.unmarshaller.readDouble());
                        break;
                    }
                    case FLOAT: {
                        readFields[i] = new FloatReadField(field, this.unmarshaller.readFloat());
                        break;
                    }
                    case INT: {
                        readFields[i] = new IntReadField(field, this.unmarshaller.readInt());
                        break;
                    }
                    case LONG: {
                        readFields[i] = new LongReadField(field, this.unmarshaller.readLong());
                        break;
                    }
                    case OBJECT: {
                        readFields[i] = new ObjectReadField(field, this.unmarshaller.readObject());
                        break;
                    }
                    case SHORT: {
                        readFields[i] = new ShortReadField(field, this.unmarshaller.readShort());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Wrong field type");
                    }
                }
                continue;
            }
            catch (IOException e) {
                TraceInformation.addFieldInformation((Throwable)e, (String)field.getName());
                throw e;
            }
            catch (ClassNotFoundException e) {
                TraceInformation.addFieldInformation((Throwable)e, (String)field.getName());
                throw e;
            }
            catch (RuntimeException e) {
                TraceInformation.addFieldInformation((Throwable)e, (String)field.getName());
                throw e;
            }
        }
        if (old == 2) {
            this.restoreIdx = this.blockUnmarshaller.tempEndOfStream();
        }
        return new ObjectInputStream.GetField(){

            @Override
            public ObjectStreamClass getObjectStreamClass() {
                throw new UnsupportedOperationException("TODO...");
            }

            private ReadField find(String name) {
                if (name == null) {
                    throw new NullPointerException("name is null");
                }
                for (ReadField field : readFields) {
                    if (!name.equals(field.getName())) continue;
                    return field;
                }
                return null;
            }

            @Override
            public boolean defaulted(String name) throws IOException {
                ReadField field = this.find(name);
                return field == null || field.isDefaulted();
            }

            @Override
            public boolean get(String name, boolean val) throws IOException {
                ReadField field = this.find(name);
                return field == null || field.isDefaulted() ? val : field.getBoolean();
            }

            @Override
            public byte get(String name, byte val) throws IOException {
                ReadField field = this.find(name);
                return field == null || field.isDefaulted() ? val : field.getByte();
            }

            @Override
            public char get(String name, char val) throws IOException {
                ReadField field = this.find(name);
                return field == null || field.isDefaulted() ? val : field.getChar();
            }

            @Override
            public short get(String name, short val) throws IOException {
                ReadField field = this.find(name);
                return field == null || field.isDefaulted() ? val : field.getShort();
            }

            @Override
            public int get(String name, int val) throws IOException {
                ReadField field = this.find(name);
                return field == null || field.isDefaulted() ? val : field.getInt();
            }

            @Override
            public long get(String name, long val) throws IOException {
                ReadField field = this.find(name);
                return field == null || field.isDefaulted() ? val : field.getLong();
            }

            @Override
            public float get(String name, float val) throws IOException {
                ReadField field = this.find(name);
                return field == null || field.isDefaulted() ? val : field.getFloat();
            }

            @Override
            public double get(String name, double val) throws IOException {
                ReadField field = this.find(name);
                return field == null || field.isDefaulted() ? val : field.getDouble();
            }

            @Override
            public Object get(String name, Object val) throws IOException {
                ReadField field = this.find(name);
                return field == null || field.isDefaulted() ? val : field.getObject();
            }
        };
    }

    public void registerValidation(ObjectInputValidation obj, int prio) throws NotActiveException, InvalidObjectException {
        this.unmarshaller.addValidation(obj, prio);
    }

    protected SerializableClassDescriptor swapClass(SerializableClassDescriptor descriptor) {
        try {
            SerializableClassDescriptor serializableClassDescriptor = this.serializableClassDescriptor;
            return serializableClassDescriptor;
        }
        finally {
            this.serializableClassDescriptor = descriptor;
        }
    }

    protected Object swapCurrent(Object obj) {
        try {
            Object object = this.current;
            return object;
        }
        finally {
            this.current = obj;
        }
    }

    protected int start() {
        return this.getAndSet(1);
    }

    protected void finish(int restoreState) throws IOException {
        switch (this.getAndSet(restoreState)) {
            case 0: {
                break;
            }
            case 3: {
                break;
            }
            case 1: 
            case 2: {
                this.unmarshaller.discardFields(this.serializableClassDescriptor);
                return;
            }
            default: {
                throw new IllegalStateException("Unknown state");
            }
        }
    }

    private void checkState() throws IOException {
        switch (this.state) {
            case 0: {
                throw new NotActiveException("Object stream not active");
            }
            case 3: {
                return;
            }
            case 1: 
            case 2: {
                this.discardReadObject();
                return;
            }
        }
        throw new IllegalStateException("Unknown state");
    }

    protected Object readObjectOverride() throws IOException, ClassNotFoundException {
        this.checkState();
        return super.readObjectOverride();
    }

    public Object readUnshared() throws IOException, ClassNotFoundException {
        this.checkState();
        return super.readUnshared();
    }

    public int read() throws IOException {
        this.checkState();
        return super.read();
    }

    public int read(byte[] buf) throws IOException {
        this.checkState();
        return super.read(buf);
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        this.checkState();
        return super.read(buf, off, len);
    }

    public boolean readBoolean() throws IOException {
        this.checkState();
        return super.readBoolean();
    }

    public byte readByte() throws IOException {
        this.checkState();
        return super.readByte();
    }

    public int readUnsignedByte() throws IOException {
        this.checkState();
        return super.readUnsignedByte();
    }

    public char readChar() throws IOException {
        this.checkState();
        return super.readChar();
    }

    public short readShort() throws IOException {
        this.checkState();
        return super.readShort();
    }

    public int readUnsignedShort() throws IOException {
        this.checkState();
        return super.readUnsignedShort();
    }

    public int readInt() throws IOException {
        this.checkState();
        return super.readInt();
    }

    public long readLong() throws IOException {
        this.checkState();
        return super.readLong();
    }

    public float readFloat() throws IOException {
        this.checkState();
        return super.readFloat();
    }

    public double readDouble() throws IOException {
        this.checkState();
        return super.readDouble();
    }

    public void readFully(byte[] buf) throws IOException {
        this.checkState();
        super.readFully(buf);
    }

    public void readFully(byte[] buf, int off, int len) throws IOException {
        this.checkState();
        super.readFully(buf, off, len);
    }

    public int skipBytes(int len) throws IOException {
        this.checkState();
        return super.skipBytes(len);
    }

    @Deprecated
    public String readLine() throws IOException {
        this.checkState();
        return super.readLine();
    }

    public String readUTF() throws IOException {
        this.checkState();
        return super.readUTF();
    }

    public long skip(long n) throws IOException {
        this.checkState();
        return super.skip(n);
    }

    protected void fullReset() {
        this.state = 0;
        this.serializableClassDescriptor = null;
        this.current = null;
    }

    protected void noCustomData() {
        this.state = 2;
    }

    protected int getRestoreIdx() {
        return this.restoreIdx;
    }
}

