/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.ha;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ColocatedPolicyConfiguration;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.messaging.activemq.ActiveMQReloadRequiredHandlers;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.ha.HAAttributes;
import org.wildfly.extension.messaging.activemq.ha.ManagementHelper;
import org.wildfly.extension.messaging.activemq.ha.SharedStoreMasterDefinition;
import org.wildfly.extension.messaging.activemq.ha.SharedStoreSlaveDefinition;

public class SharedStoreColocatedDefinition
extends PersistentResourceDefinition {
    public static final PathElement PATH = PathElement.pathElement((String)"ha-policy", (String)"shared-store-colocated");
    public static Collection<AttributeDefinition> ATTRIBUTES = Collections.unmodifiableList(Arrays.asList(HAAttributes.REQUEST_BACKUP, HAAttributes.BACKUP_REQUEST_RETRIES, HAAttributes.BACKUP_REQUEST_RETRY_INTERVAL, HAAttributes.MAX_BACKUPS, HAAttributes.BACKUP_PORT_OFFSET));
    public static final SharedStoreColocatedDefinition INSTANCE = new SharedStoreColocatedDefinition();

    private SharedStoreColocatedDefinition() {
        super(PATH, MessagingExtension.getResourceDescriptionResolver("ha-policy"), (OperationStepHandler)ManagementHelper.createAddOperation("ha-policy", false, ATTRIBUTES), (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ActiveMQReloadRequiredHandlers.WriteAttributeHandler writeAttribute = new ActiveMQReloadRequiredHandlers.WriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition attribute : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attribute, null, (OperationStepHandler)writeAttribute);
        }
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }

    protected List<? extends PersistentResourceDefinition> getChildren() {
        return Collections.unmodifiableList(Arrays.asList(new PersistentResourceDefinition[]{SharedStoreMasterDefinition.CONFIGURATION_INSTANCE, SharedStoreSlaveDefinition.CONFIGURATION_INSTANCE}));
    }

    static HAPolicyConfiguration buildConfiguration(OperationContext context, ModelNode model) throws OperationFailedException {
        ColocatedPolicyConfiguration haPolicyConfiguration = new ColocatedPolicyConfiguration().setRequestBackup(HAAttributes.REQUEST_BACKUP.resolveModelAttribute(context, model).asBoolean()).setBackupRequestRetries(HAAttributes.BACKUP_REQUEST_RETRIES.resolveModelAttribute(context, model).asInt()).setBackupRequestRetryInterval(HAAttributes.BACKUP_REQUEST_RETRY_INTERVAL.resolveModelAttribute(context, model).asLong()).setMaxBackups(HAAttributes.MAX_BACKUPS.resolveModelAttribute(context, model).asInt()).setBackupPortOffset(HAAttributes.BACKUP_PORT_OFFSET.resolveModelAttribute(context, model).asInt());
        ModelNode masterConfigurationModel = model.get(new String[]{"configuration", "master"});
        HAPolicyConfiguration masterConfiguration = SharedStoreMasterDefinition.buildConfiguration(context, masterConfigurationModel);
        haPolicyConfiguration.setLiveConfig(masterConfiguration);
        ModelNode slaveConfigurationModel = model.get(new String[]{"configuration", "slave"});
        HAPolicyConfiguration slaveConfiguration = SharedStoreSlaveDefinition.buildConfiguration(context, slaveConfigurationModel);
        haPolicyConfiguration.setBackupConfig(slaveConfiguration);
        return haPolicyConfiguration;
    }
}

