/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.configuration;

import javax.net.ssl.SSLContext;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.server.core.configuration.SslConfiguration;
import org.infinispan.server.core.logging.JavaLog;
import org.infinispan.util.logging.LogFactory;

public class SslConfigurationBuilder
implements Builder<SslConfiguration> {
    private static final JavaLog log = (JavaLog)LogFactory.getLog(SslConfigurationBuilder.class, JavaLog.class);
    private boolean enabled = false;
    private boolean requireClientAuth = false;
    private String keyStoreFileName;
    private char[] keyStorePassword;
    private SSLContext sslContext;
    private String trustStoreFileName;
    private char[] trustStorePassword;

    SslConfigurationBuilder() {
    }

    public SslConfigurationBuilder disable() {
        this.enabled = false;
        return this;
    }

    public SslConfigurationBuilder enable() {
        this.enabled = true;
        return this;
    }

    public SslConfigurationBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public SslConfigurationBuilder requireClientAuth(boolean requireClientAuth) {
        this.requireClientAuth = requireClientAuth;
        return this;
    }

    public SslConfigurationBuilder sslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public SslConfigurationBuilder keyStoreFileName(String keyStoreFileName) {
        this.keyStoreFileName = keyStoreFileName;
        return this;
    }

    public SslConfigurationBuilder keyStorePassword(char[] keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
        return this;
    }

    public SslConfigurationBuilder trustStoreFileName(String trustStoreFileName) {
        this.trustStoreFileName = trustStoreFileName;
        return this;
    }

    public SslConfigurationBuilder trustStorePassword(char[] trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
        return this;
    }

    public void validate() {
        if (this.enabled) {
            if (this.sslContext == null) {
                if (this.keyStoreFileName == null) {
                    throw log.noSSLKeyManagerConfiguration();
                }
                if (this.keyStoreFileName != null && this.keyStorePassword == null) {
                    throw log.missingKeyStorePassword(this.keyStoreFileName);
                }
                if (this.trustStoreFileName == null) {
                    throw log.noSSLTrustManagerConfiguration();
                }
                if (this.trustStoreFileName != null && this.trustStorePassword == null) {
                    throw log.missingTrustStorePassword(this.trustStoreFileName);
                }
            } else if (this.keyStoreFileName != null || this.trustStoreFileName != null) {
                throw log.xorSSLContext();
            }
        }
    }

    public SslConfiguration create() {
        return new SslConfiguration(this.enabled, this.requireClientAuth, this.keyStoreFileName, this.keyStorePassword, this.sslContext, this.trustStoreFileName, this.trustStorePassword);
    }

    public SslConfigurationBuilder read(SslConfiguration template) {
        this.enabled = template.enabled();
        this.requireClientAuth = template.requireClientAuth();
        this.keyStoreFileName = template.keyStoreFileName();
        this.keyStorePassword = template.keyStorePassword();
        this.sslContext = template.sslContext();
        this.trustStoreFileName = template.trustStoreFileName();
        this.trustStorePassword = template.trustStorePassword();
        return this;
    }
}

