/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.infinispan.commands.DataCommand;
import org.infinispan.commands.LocalFlagAffectedCommand;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.RpcException;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PartitionHandlingInterceptor
extends CommandInterceptor {
    private static final Log log = LogFactory.getLog(PartitionHandlingInterceptor.class);
    private PartitionHandlingManager partitionHandlingManager;
    private Transport transport;
    private DistributionManager distributionManager;

    @Inject
    void init(PartitionHandlingManager partitionHandlingManager, Transport transport, DistributionManager distributionManager) {
        this.partitionHandlingManager = partitionHandlingManager;
        this.transport = transport;
        this.distributionManager = distributionManager;
    }

    private boolean performPartitionCheck(InvocationContext ctx, LocalFlagAffectedCommand command) {
        if (!ctx.isOriginLocal()) {
            return true;
        }
        Set<Flag> flags = command.getFlags();
        return flags == null || !flags.contains((Object)Flag.CACHE_MODE_LOCAL);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleSingleWrite(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleSingleWrite(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleSingleWrite(ctx, command);
    }

    protected Object handleSingleWrite(InvocationContext ctx, DataWriteCommand command) throws Throwable {
        if (this.performPartitionCheck(ctx, command)) {
            this.partitionHandlingManager.checkWrite(command.getKey());
        }
        return this.handleDefault(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        if (this.performPartitionCheck(ctx, command)) {
            for (Object k : command.getAffectedKeys()) {
                this.partitionHandlingManager.checkWrite(k);
            }
        }
        return this.handleDefault(ctx, command);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        if (this.performPartitionCheck(ctx, command)) {
            this.partitionHandlingManager.checkClear();
        }
        return this.handleDefault(ctx, command);
    }

    @Override
    public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
        return this.handleSingleWrite(ctx, command);
    }

    @Override
    public Object visitKeySetCommand(InvocationContext ctx, KeySetCommand command) throws Throwable {
        if (this.performPartitionCheck(ctx, command)) {
            this.partitionHandlingManager.checkBulkRead();
        }
        return this.handleDefault(ctx, command);
    }

    @Override
    public Object visitEntrySetCommand(InvocationContext ctx, EntrySetCommand command) throws Throwable {
        if (this.performPartitionCheck(ctx, command)) {
            this.partitionHandlingManager.checkBulkRead();
        }
        return this.handleDefault(ctx, command);
    }

    @Override
    public final Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.handleDataReadCommand(ctx, command);
    }

    @Override
    public final Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        return this.handleDataReadCommand(ctx, command);
    }

    private Object handleDataReadCommand(InvocationContext ctx, DataCommand command) throws Throwable {
        Object result;
        Object key = command.getKey();
        try {
            result = this.invokeNextInterceptor(ctx, command);
        }
        catch (RpcException e) {
            if (this.performPartitionCheck(ctx, command)) {
                throw this.getLog().degradedModeKeyUnavailable(key);
            }
            throw e;
        }
        this.postOperationPartitionCheck(ctx, command, key);
        return result;
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (this.partitionHandlingManager.getAvailabilityMode() != AvailabilityMode.AVAILABLE && !command.isOnePhaseCommit() && ctx.hasModifications()) {
            for (Object key : ctx.getAffectedKeys()) {
                this.partitionHandlingManager.checkWrite(key);
            }
        }
        Object result = super.visitPrepareCommand(ctx, command);
        if (ctx.isOriginLocal()) {
            this.postTxCommandCheck(ctx);
        }
        return result;
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        Object result = super.visitCommitCommand(ctx, command);
        if (ctx.isOriginLocal()) {
            this.postTxCommandCheck(ctx);
        }
        return result;
    }

    protected void postTxCommandCheck(TxInvocationContext ctx) {
        if (this.partitionHandlingManager.getAvailabilityMode() != AvailabilityMode.AVAILABLE && !this.partitionHandlingManager.isTransactionPartiallyCommitted(ctx.getGlobalTransaction()) && ctx.hasModifications()) {
            for (Object key : ctx.getAffectedKeys()) {
                this.partitionHandlingManager.checkWrite(key);
            }
        }
    }

    private void postOperationPartitionCheck(InvocationContext ctx, DataCommand command, Object key) throws Throwable {
        if (this.performPartitionCheck(ctx, command)) {
            this.partitionHandlingManager.checkRead(key);
        }
    }

    @Override
    public Object visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        Map result;
        try {
            result = (Map)super.visitGetAllCommand(ctx, command);
        }
        catch (RpcException e) {
            if (this.performPartitionCheck(ctx, command)) {
                throw this.getLog().degradedModeKeysUnavailable(command.getKeys());
            }
            throw e;
        }
        if (this.performPartitionCheck(ctx, command)) {
            for (Object key : command.getKeys()) {
                this.partitionHandlingManager.checkRead(key);
            }
            if (result.size() != command.getKeys().size()) {
                HashSet missingKeys = new HashSet(command.getKeys());
                missingKeys.removeAll(result.keySet());
                Iterator it = missingKeys.iterator();
                while (it.hasNext()) {
                    Object key = it.next();
                    if (!InfinispanCollections.containsAny(this.transport.getMembers(), this.distributionManager.locate(key))) continue;
                    it.remove();
                }
                if (!missingKeys.isEmpty()) {
                    throw this.getLog().degradedModeKeysUnavailable(missingKeys);
                }
            }
        }
        return result;
    }
}

