/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.configuration;

import java.lang.invoke.MethodHandles;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.server.hotrod.configuration.AuthenticationConfigurationBuilder;
import org.infinispan.server.hotrod.configuration.HotRodServerChildConfigurationBuilder;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.hotrod.logging.JavaLog;
import org.infinispan.util.logging.LogFactory;

public class HotRodServerConfigurationBuilder
extends ProtocolServerConfigurationBuilder<HotRodServerConfiguration, HotRodServerConfigurationBuilder>
implements Builder<HotRodServerConfiguration>,
HotRodServerChildConfigurationBuilder {
    private JavaLog log = (JavaLog)LogFactory.getLog(MethodHandles.lookup().lookupClass(), JavaLog.class);
    private final AuthenticationConfigurationBuilder authentication = new AuthenticationConfigurationBuilder(this);
    private String proxyHost;
    private int proxyPort = -1;
    private long topologyLockTimeout = 10000L;
    private long topologyReplTimeout = 10000L;
    private boolean topologyAwaitInitialTransfer = true;
    private boolean topologyStateTransfer = true;

    public HotRodServerConfigurationBuilder() {
        super(11222);
    }

    public HotRodServerConfigurationBuilder self() {
        return this;
    }

    @Override
    public AuthenticationConfigurationBuilder authentication() {
        return this.authentication;
    }

    @Override
    public HotRodServerConfigurationBuilder proxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
        return this;
    }

    @Override
    public HotRodServerConfigurationBuilder proxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        return this;
    }

    @Override
    public HotRodServerConfigurationBuilder topologyLockTimeout(long topologyLockTimeout) {
        this.topologyLockTimeout = topologyLockTimeout;
        return this;
    }

    @Override
    public HotRodServerConfigurationBuilder topologyReplTimeout(long topologyReplTimeout) {
        this.topologyReplTimeout = topologyReplTimeout;
        return this;
    }

    @Override
    public HotRodServerConfigurationBuilder topologyAwaitInitialTransfer(boolean topologyAwaitInitialTransfer) {
        this.topologyAwaitInitialTransfer = topologyAwaitInitialTransfer;
        return this;
    }

    @Override
    public HotRodServerConfigurationBuilder topologyStateTransfer(boolean topologyStateTransfer) {
        this.topologyStateTransfer = topologyStateTransfer;
        return this;
    }

    public HotRodServerConfiguration create() {
        return new HotRodServerConfiguration(this.defaultCacheName, this.proxyHost == null ? this.host : this.proxyHost, this.proxyPort < 0 ? this.port : this.proxyPort, this.topologyLockTimeout, this.topologyReplTimeout, this.topologyAwaitInitialTransfer, this.topologyStateTransfer, this.name, this.host, this.port, this.idleTimeout, this.recvBufSize, this.sendBufSize, this.ssl.create(), this.tcpNoDelay, this.workerThreads, this.authentication.create(), this.ignoredCaches);
    }

    public HotRodServerConfigurationBuilder read(HotRodServerConfiguration template) {
        super.read((ProtocolServerConfiguration)template);
        this.proxyHost = template.proxyHost();
        this.proxyPort = template.proxyPort();
        this.topologyLockTimeout = template.topologyLockTimeout();
        this.topologyReplTimeout = template.topologyReplTimeout();
        this.topologyAwaitInitialTransfer = template.topologyAwaitInitialTransfer();
        this.topologyStateTransfer = template.topologyStateTransfer();
        return this;
    }

    public void validate() {
        super.validate();
        if (this.proxyHost == null && this.host == null) {
            throw this.log.missingHostAddress();
        }
        this.authentication.validate();
    }

    public HotRodServerConfiguration build(boolean validate) {
        if (validate) {
            this.validate();
        }
        return this.create();
    }

    public HotRodServerConfiguration build() {
        return this.build(true);
    }
}

