/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.io.Serializable;
import org.hibernate.cache.spi.access.RegionAccessStrategy;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionImplementor;

public final class CacheHelper {
    private CacheHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Serializable fromSharedCache(SessionImplementor session, Object cacheKey, RegionAccessStrategy cacheAccessStrategy) {
        SessionEventListenerManager eventListenerManager = session.getEventListenerManager();
        Serializable cachedValue = null;
        eventListenerManager.cacheGetStart();
        try {
            cachedValue = (Serializable)cacheAccessStrategy.get(session, cacheKey, session.getTimestamp());
            eventListenerManager.cacheGetEnd(cachedValue != null);
        }
        catch (Throwable throwable) {
            eventListenerManager.cacheGetEnd(cachedValue != null);
            throw throwable;
        }
        return cachedValue;
    }
}

