/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton.election;

import java.net.UnknownHostException;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.singleton.election.Preference;

public class OutboundSocketBindingPreference
implements Preference {
    private final Value<OutboundSocketBinding> binding;

    public OutboundSocketBindingPreference(Value<OutboundSocketBinding> binding) {
        this.binding = binding;
    }

    public boolean preferred(Node node) {
        OutboundSocketBinding binding = (OutboundSocketBinding)this.binding.getValue();
        try {
            return binding.getResolvedDestinationAddress().equals(node.getSocketAddress().getAddress()) && binding.getDestinationPort() == node.getSocketAddress().getPort();
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

