/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso;

import io.undertow.security.api.AuthenticatedSessionManager;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.BatchContext;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.web.sso.SSO;
import org.wildfly.clustering.web.sso.Sessions;
import org.wildfly.clustering.web.undertow.sso.InvalidatableSingleSignOn;
import org.wildfly.clustering.web.undertow.sso.SessionManagerRegistry;

public class DistributableSingleSignOn
implements InvalidatableSingleSignOn {
    private final SSO<AuthenticatedSessionManager.AuthenticatedSession, String, Void> sso;
    private final SessionManagerRegistry registry;
    private final Batcher<Batch> batcher;
    private final Batch batch;
    private final SessionListener listener;

    public DistributableSingleSignOn(SSO<AuthenticatedSessionManager.AuthenticatedSession, String, Void> sso, SessionManagerRegistry registry, Batcher<Batch> batcher, Batch batch) {
        this.sso = sso;
        this.registry = registry;
        this.batcher = batcher;
        this.batch = batch;
        this.listener = new SessionIdChangeListener(sso, batcher, batch);
    }

    public String getId() {
        return this.sso.getId();
    }

    public Account getAccount() {
        try (BatchContext context = this.batcher.resumeBatch(this.batch);){
            Account account = ((AuthenticatedSessionManager.AuthenticatedSession)this.sso.getAuthentication()).getAccount();
            return account;
        }
    }

    public String getMechanismName() {
        try (BatchContext context = this.batcher.resumeBatch(this.batch);){
            String string = ((AuthenticatedSessionManager.AuthenticatedSession)this.sso.getAuthentication()).getMechanism();
            return string;
        }
    }

    public Iterator<Session> iterator() {
        try (BatchContext context = this.batcher.resumeBatch(this.batch);){
            Sessions sessions = this.sso.getSessions();
            Set deployments = sessions.getDeployments();
            ArrayList<InvalidatableSession> result = new ArrayList<InvalidatableSession>(deployments.size());
            for (String deployment : sessions.getDeployments()) {
                SessionManager manager;
                String sessionId = sessions.getSession((Object)deployment);
                if (sessionId == null || (manager = this.registry.getSessionManager(deployment)) == null) continue;
                result.add(new InvalidatableSession(manager, sessionId));
            }
            Iterator<Session> iterator = result.iterator();
            return iterator;
        }
    }

    public boolean contains(Session session) {
        try (BatchContext context = this.batcher.resumeBatch(this.batch);){
            boolean bl = this.sso.getSessions().getDeployments().contains(session.getSessionManager().getDeploymentName());
            return bl;
        }
    }

    public void add(Session session) {
        try (BatchContext context = this.batcher.resumeBatch(this.batch);){
            this.sso.getSessions().addSession((Object)session.getSessionManager().getDeploymentName(), session.getId());
        }
        session.getSessionManager().registerSessionListener(this.listener);
    }

    public void remove(Session session) {
        try (BatchContext context = this.batcher.resumeBatch(this.batch);){
            this.sso.getSessions().removeSession((Object)session.getSessionManager().getDeploymentName());
        }
        session.getSessionManager().removeSessionListener(this.listener);
    }

    public Session getSession(SessionManager manager) {
        try (BatchContext context = this.batcher.resumeBatch(this.batch);){
            String sessionId = this.sso.getSessions().getSession((Object)manager.getDeploymentName());
            InvalidatableSession invalidatableSession = sessionId != null ? new InvalidatableSession(manager, sessionId) : null;
            return invalidatableSession;
        }
    }

    public void close() {
        if (this.batch.isActive()) {
            try (BatchContext context = this.batcher.resumeBatch(this.batch);){
                this.batch.close();
            }
        }
    }

    @Override
    public void invalidate() {
        boolean active = this.batch.isActive();
        try (BatchContext context = active ? this.batcher.resumeBatch(this.batch) : null;
             Batch batch = active ? this.batch : this.batcher.createBatch();){
            this.sso.invalidate();
        }
    }

    private static class SessionIdChangeListener
    implements SessionListener {
        private final SSO<AuthenticatedSessionManager.AuthenticatedSession, String, Void> sso;
        private final Batcher<Batch> batcher;
        private final Batch batch;

        SessionIdChangeListener(SSO<AuthenticatedSessionManager.AuthenticatedSession, String, Void> sso, Batcher<Batch> batcher, Batch batch) {
            this.sso = sso;
            this.batcher = batcher;
            this.batch = batch;
        }

        public void sessionIdChanged(Session session, String oldSessionId) {
            boolean active = this.batch.isActive();
            try (BatchContext context = active ? this.batcher.resumeBatch(this.batch) : null;
                 Batch batch = active ? this.batch : this.batcher.createBatch();){
                String deployment = session.getSessionManager().getDeploymentName();
                Sessions sessions = this.sso.getSessions();
                sessions.removeSession((Object)deployment);
                sessions.addSession((Object)deployment, session.getId());
            }
        }

        public void attributeAdded(Session session, String name, Object value) {
        }

        public void attributeRemoved(Session session, String name, Object value) {
        }

        public void attributeUpdated(Session session, String name, Object newValue, Object oldValue) {
        }

        public void sessionCreated(Session session, HttpServerExchange exchange) {
        }

        public void sessionDestroyed(Session session, HttpServerExchange exchange, SessionListener.SessionDestroyedReason reason) {
        }
    }

    private static class SimpleSessionConfig
    implements SessionConfig {
        private final String id;

        SimpleSessionConfig(String id) {
            this.id = id;
        }

        public String findSessionId(HttpServerExchange exchange) {
            return this.id;
        }

        public void setSessionId(HttpServerExchange exchange, String sessionId) {
            throw new UnsupportedOperationException();
        }

        public void clearSession(HttpServerExchange exchange, String sessionId) {
            throw new UnsupportedOperationException();
        }

        public SessionConfig.SessionCookieSource sessionCookieSource(HttpServerExchange exchange) {
            throw new UnsupportedOperationException();
        }

        public String rewriteUrl(String originalUrl, String sessionId) {
            throw new UnsupportedOperationException();
        }
    }

    private static class InvalidatableSession
    implements Session {
        private final SessionManager manager;
        private final String sessionId;

        InvalidatableSession(SessionManager manager, String sessionId) {
            this.manager = manager;
            this.sessionId = sessionId;
        }

        public String getId() {
            return this.sessionId;
        }

        public SessionManager getSessionManager() {
            return this.manager;
        }

        public void invalidate(HttpServerExchange exchange) {
            Session session = this.manager.getSession(exchange, (SessionConfig)new SimpleSessionConfig(this.sessionId));
            if (session != null) {
                session.invalidate(exchange);
            }
        }

        public String changeSessionId(HttpServerExchange exchange, SessionConfig config) {
            throw new UnsupportedOperationException();
        }

        public Object getAttribute(String name) {
            throw new UnsupportedOperationException();
        }

        public Set<String> getAttributeNames() {
            throw new UnsupportedOperationException();
        }

        public long getCreationTime() {
            throw new UnsupportedOperationException();
        }

        public long getLastAccessedTime() {
            throw new UnsupportedOperationException();
        }

        public int getMaxInactiveInterval() {
            throw new UnsupportedOperationException();
        }

        public Object removeAttribute(String name) {
            throw new UnsupportedOperationException();
        }

        public void requestDone(HttpServerExchange exchange) {
            throw new UnsupportedOperationException();
        }

        public Object setAttribute(String name, Object value) {
            throw new UnsupportedOperationException();
        }

        public void setMaxInactiveInterval(int interval) {
            throw new UnsupportedOperationException();
        }
    }
}

