/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.embedded.logging;

import java.io.File;
import java.lang.reflect.Method;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.modules.ModuleLoader;
import org.jboss.vfs.VirtualFile;
import org.wildfly.core.embedded.EmbeddedProcessStartException;

@MessageLogger(projectCode="WFLYEMB", length=4)
public interface EmbeddedLogger
extends BasicLogger {
    public static final EmbeddedLogger ROOT_LOGGER = Logger.getMessageLogger(EmbeddedLogger.class, "org.jboss.as.embedded");

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1, value="Could not close handle to mounted %s")
    public void cannotCloseFile(@Cause Throwable var1, VirtualFile var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=2, value="Could not load class file %s")
    public void cannotLoadClassFile(@Cause Throwable var1, VirtualFile var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3, value="Exception closing file %s")
    public void errorClosingFile(@Cause Throwable var1, VirtualFile var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=4, value="Failed to undeploy %s")
    public void failedToUndeploy(@Cause Throwable var1, File var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=5, value="File on ClassPath could not be found: %s")
    public void fileNotFound(VirtualFile var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=6, value="Encountered unknown file type, skipping: %s")
    public void skippingUnknownFileType(VirtualFile var1);

    @Message(id=7, value="Could not mount file '%s'")
    public RuntimeException cannotMountFile(@Cause Throwable var1, String var2);

    @Message(id=8, value="Could not read contents of %s")
    public RuntimeException cannotReadContent(@Cause Throwable var1, VirtualFile var2);

    @Message(id=9, value="One or more exclusion values must be specified")
    public IllegalArgumentException exclusionValuesRequired();

    @Message(id=11, value="Invalid JBoss home directory: %s")
    public IllegalStateException invalidJBossHome(String var1);

    @Message(id=12, value="Invalid module path: %s")
    public IllegalArgumentException invalidModulePath(String var1);

    @Message(id=13, value="%s was not of type File[], File, String[] or String, but of type %s")
    public RuntimeException invalidModuleType(String var1, Class<?> var2);

    @Message(id=14, value="Cannot load module %s from: %s")
    public RuntimeException moduleLoaderError(@Cause Throwable var1, String var2, ModuleLoader var3);

    @Message(id=15, value="%s is null")
    public IllegalArgumentException nullVar(String var1);

    @Message(id=16, value="Cannot find system property: %s")
    public IllegalStateException systemPropertyNotFound(String var1);

    @Message(id=17, value="Cannot load embedded server factory: %s")
    public IllegalStateException cannotLoadEmbeddedServerFactory(@Cause ClassNotFoundException var1, String var2);

    @Message(id=18, value="Cannot get reflective method '%s' for: %s")
    public IllegalStateException cannotGetReflectiveMethod(@Cause NoSuchMethodException var1, String var2, String var3);

    @Message(id=19, value="Cannot create standalone server using factory: %s")
    public IllegalStateException cannotCreateStandaloneServer(@Cause Throwable var1, Method var2);

    @Message(id=20, value="Cannot setup embedded process")
    public IllegalStateException cannotSetupEmbeddedServer(@Cause Throwable var1);

    @Message(id=21, value="Cannot start embedded process")
    public EmbeddedProcessStartException cannotStartEmbeddedServer(@Cause Throwable var1);

    @Message(id=22, value="Cannot invoke '%s' on embedded process")
    public IllegalStateException cannotInvokeStandaloneServer(@Cause Throwable var1, String var2);

    @Message(id=23, value="The embedded server is stopping and invocations on the ModelControllerClient are not available")
    public IllegalStateException processIsStopping();

    @Message(id=24, value="The embedded server is reloading and invocations on the ModelControllerClient are not yet available")
    public IllegalStateException processIsReloading();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=25, value="Unable to configure embedded server logging from %s")
    public void cannotConfigureBootLogging(File var1);

    @Message(id=26, value="Cannot create host controller using factory: %s")
    public IllegalStateException cannotCreateHostController(@Cause Throwable var1, Method var2);
}

