/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.transport;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.time.Instant;
import org.infinispan.server.core.transport.NettyTransport;

public class StatsChannelHandler
extends ChannelDuplexHandler {
    private final NettyTransport transport;
    public static AttributeKey<Integer> bytesRead = AttributeKey.valueOf((String)"__bytesRead");
    public static AttributeKey<Instant> startInstant = AttributeKey.valueOf((String)"__startInstant");

    public StatsChannelHandler(NettyTransport transport) {
        this.transport = transport;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        int readable = this.getByteSize(msg);
        Attribute count = ctx.channel().attr(bytesRead);
        count.set((Object)readable);
        Attribute start2 = ctx.channel().attr(startInstant);
        start2.set((Object)Instant.now());
        this.transport.updateTotalBytesRead(readable);
        super.channelRead(ctx, msg);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.transport.acceptedChannels().add(ctx.channel());
        super.channelActive(ctx);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        this.transport.updateTotalBytesWritten(this.getByteSize(msg));
        super.write(ctx, msg, promise);
    }

    int getByteSize(Object msg) {
        if (msg instanceof ByteBuf) {
            return ((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof ByteBufHolder) {
            return ((ByteBufHolder)msg).content().readableBytes();
        }
        return -1;
    }
}

