/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledDirectByteBuf;
import java.nio.ByteBuffer;
import org.xnio.Pooled;
import org.xnio.netty.buffer.XnioByteBufAllocator;
import org.xnio.netty.buffer.XnioByteBufUtil;

final class XnioDirectByteBuf
extends UnpooledDirectByteBuf {
    private Pooled<ByteBuffer> pooled;

    XnioDirectByteBuf(ByteBufAllocator alloc, int initialCapacity, int maxCapacity) {
        super(alloc, initialCapacity, maxCapacity);
    }

    public ByteBuf capacity(int newCapacity) {
        this.ensureAccessible();
        if (newCapacity < 0 || newCapacity > this.maxCapacity()) {
            throw new IllegalArgumentException("newCapacity: " + newCapacity);
        }
        Pooled<ByteBuffer> oldPooled = this.pooled;
        super.capacity(newCapacity);
        if (oldPooled != this.pooled) {
            oldPooled.free();
        }
        return this;
    }

    protected ByteBuffer allocateDirect(int initialCapacity) {
        Pooled<ByteBuffer> pooled = XnioByteBufUtil.allocateDirect(((XnioByteBufAllocator)this.alloc()).pool, initialCapacity);
        this.pooled = pooled;
        return (ByteBuffer)pooled.getResource();
    }

    protected void freeDirect(ByteBuffer buffer) {
        XnioByteBufUtil.freeDirect(buffer, (ByteBuffer)this.pooled.getResource());
    }

    protected void deallocate() {
        super.deallocate();
        this.pooled.free();
    }
}

