/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.handlers;

import io.undertow.server.HttpHandler;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.requestcontroller.ControlPoint;
import org.wildfly.extension.requestcontroller.RequestController;
import org.wildfly.extension.undertow.deployment.GlobalRequestControllerHandler;
import org.wildfly.extension.undertow.logging.UndertowLogger;

public class HandlerService
implements Service<HttpHandler> {
    private final HttpHandler httpHandler;
    private final InjectedValue<RequestController> requestControllerInjectedValue = new InjectedValue();
    private volatile ControlPoint controlPoint;
    private volatile HttpHandler realHandler;
    private final String name;

    public HandlerService(HttpHandler httpHandler, String name) {
        this.httpHandler = httpHandler;
        this.name = name;
    }

    public void start(StartContext context) throws StartException {
        UndertowLogger.ROOT_LOGGER.tracef("starting handler: %s", this.httpHandler);
        if (this.requestControllerInjectedValue.getOptionalValue() != null) {
            this.controlPoint = ((RequestController)this.requestControllerInjectedValue.getValue()).getControlPoint("org.wildfly.extension.undertow.handlers", this.name);
            this.realHandler = new GlobalRequestControllerHandler(this.httpHandler, this.controlPoint);
        } else {
            this.realHandler = this.httpHandler;
        }
    }

    public void stop(StopContext context) {
        if (this.controlPoint != null) {
            ((RequestController)this.requestControllerInjectedValue.getValue()).removeControlPoint(this.controlPoint);
            this.controlPoint = null;
        }
    }

    public HttpHandler getValue() throws IllegalStateException, IllegalArgumentException {
        return this.realHandler;
    }

    public InjectedValue<RequestController> getRequestControllerInjectedValue() {
        return this.requestControllerInjectedValue;
    }
}

