/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.parsing;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.parsing.WriteUtils;
import org.jboss.as.domain.management.access.AccessAuthorizationResourceDefinition;
import org.jboss.as.domain.management.access.ApplicationClassificationConfigResourceDefinition;
import org.jboss.as.domain.management.access.ApplicationClassificationTypeResourceDefinition;
import org.jboss.as.domain.management.access.HostScopedRolesResourceDefinition;
import org.jboss.as.domain.management.access.PrincipalResourceDefinition;
import org.jboss.as.domain.management.access.RoleMappingResourceDefinition;
import org.jboss.as.domain.management.access.SensitivityClassificationTypeResourceDefinition;
import org.jboss.as.domain.management.access.SensitivityResourceDefinition;
import org.jboss.as.domain.management.access.ServerGroupScopedRoleResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class AccessControlXml {
    private final Namespace namespace;

    private AccessControlXml(Namespace namespace) {
        this.namespace = namespace;
    }

    public static AccessControlXml newInstance(Namespace namespace) {
        return new AccessControlXml(namespace);
    }

    public void parseAccessControlConstraints(XMLExtendedStreamReader reader, ModelNode accAuthzAddr, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case VAULT_EXPRESSION_SENSITIVITY: {
                    ModelNode vaultAddr = accAuthzAddr.clone().add("constraint", "vault-expression");
                    this.parseClassificationType(reader, vaultAddr, list, true);
                    continue block5;
                }
                case SENSITIVE_CLASSIFICATIONS: {
                    ModelNode sensAddr = accAuthzAddr.clone().add("constraint", "sensitivity-classification");
                    this.parseSensitiveClassifications(reader, sensAddr, list);
                    continue block5;
                }
                case APPLICATION_CLASSIFICATIONS: {
                    ModelNode applAddr = accAuthzAddr.clone().add("constraint", "application-classification");
                    this.parseApplicationClassifications(reader, applAddr, list);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    public void parseAccessControlRoleMapping(XMLExtendedStreamReader reader, ModelNode accContAddr, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            if (element == Element.ROLE) {
                this.parseRole(reader, accContAddr, list);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    public void parseServerGroupScopedRoles(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        String scopedRoleType = ServerGroupScopedRoleResourceDefinition.PATH_ELEMENT.getKey();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case ROLE: {
                    this.parseScopedRole(reader, address, list, scopedRoleType, Element.SERVER_GROUP, ServerGroupScopedRoleResourceDefinition.BASE_ROLE, ServerGroupScopedRoleResourceDefinition.SERVER_GROUPS, true);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    public void parseHostScopedRoles(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        String scopedRoleType = HostScopedRolesResourceDefinition.PATH_ELEMENT.getKey();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case ROLE: {
                    this.parseScopedRole(reader, address, list, scopedRoleType, Element.HOST, HostScopedRolesResourceDefinition.BASE_ROLE, HostScopedRolesResourceDefinition.HOSTS, false);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseScopedRole(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> ops, String scopedRoleType, Element listElement, SimpleAttributeDefinition baseRoleDefinition, ListAttributeDefinition listDefinition, boolean requireChildren) throws XMLStreamException {
        ModelNode addOp = Util.createAddOperation();
        ops.add(addOp);
        ModelNode ourAddress = addOp.get("address").set(address);
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.BASE_ROLE);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case NAME: {
                    ourAddress.add(scopedRoleType, value);
                    continue block4;
                }
                case BASE_ROLE: {
                    baseRoleDefinition.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        boolean missingChildren = requireChildren;
        while (reader.hasNext() && reader.nextTag() != 2) {
            boolean named = false;
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            if (element == listElement) {
                missingChildren = false;
                int groupCount = reader.getAttributeCount();
                for (int i = 0; i < groupCount; ++i) {
                    String value = reader.getAttributeValue(i);
                    if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
                    required.remove(attribute);
                    if (attribute != Attribute.NAME) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    named = true;
                    listDefinition.parseAndAddParameterElement(value, addOp, (XMLStreamReader)reader);
                }
            } else {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            if (!named) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.NAME));
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }
        if (missingChildren) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(listElement));
        }
    }

    private void parseRole(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ModelNode add = new ModelNode();
        list.add(add);
        String name = null;
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block8;
                }
                case INCLUDE_ALL: {
                    RoleMappingResourceDefinition.INCLUDE_ALL.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        ModelNode addr = address.clone().add("role-mapping", name);
        add.get("address").set(addr);
        add.get("operation").set("add");
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case INCLUDE: {
                    this.parseIncludeExclude(reader, addr, "include", list);
                    continue block9;
                }
                case EXCLUDE: {
                    this.parseIncludeExclude(reader, addr, "exclude", list);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseIncludeExclude(XMLExtendedStreamReader reader, ModelNode parentAddress, String incExcType, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case GROUP: {
                    this.parsePrincipal(reader, parentAddress, incExcType, "group", list);
                    continue block4;
                }
                case USER: {
                    this.parsePrincipal(reader, parentAddress, incExcType, "user", list);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parsePrincipal(XMLExtendedStreamReader reader, ModelNode parentAddress, String incExcType, String principalType, List<ModelNode> list) throws XMLStreamException {
        String alias = null;
        String realm = null;
        String name = null;
        ModelNode addOp = new ModelNode();
        addOp.get("operation").set("add");
        addOp.get("type").set(principalType);
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case ALIAS: {
                    alias = value;
                    continue block5;
                }
                case NAME: {
                    name = value;
                    PrincipalResourceDefinition.NAME.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block5;
                }
                case REALM: {
                    realm = value;
                    PrincipalResourceDefinition.REALM.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        String addrValue = alias == null ? AccessControlXml.generateAlias(principalType, name, realm) : alias;
        ModelNode addAddr = parentAddress.clone().add(incExcType, addrValue);
        addOp.get("address").set(addAddr);
        list.add(addOp);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    static String generateAlias(String type, String name, String realm) {
        return type + "-" + name + (realm != null ? "@" + realm : "");
    }

    private void parseSensitiveClassifications(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SENSITIVE_CLASSIFICATION: {
                    this.parseSensitivityClassification(reader, address, list);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseClassificationType(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, boolean vault) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String name = null;
        String type = null;
        HashMap<String, ModelNode> values = new HashMap<String, ModelNode>();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block7;
                }
                case TYPE: {
                    type = value;
                    continue block7;
                }
                case REQUIRES_READ: {
                    values.put(SensitivityResourceDefinition.CONFIGURED_REQUIRES_READ.getName(), SensitivityResourceDefinition.CONFIGURED_REQUIRES_READ.parse(value, (XMLStreamReader)reader));
                    continue block7;
                }
                case REQUIRES_WRITE: {
                    values.put(SensitivityResourceDefinition.CONFIGURED_REQUIRES_WRITE.getName(), SensitivityResourceDefinition.CONFIGURED_REQUIRES_WRITE.parse(value, (XMLStreamReader)reader));
                    continue block7;
                }
                case REQUIRES_ADDRESSABLE: {
                    if (!vault) {
                        values.put(SensitivityResourceDefinition.CONFIGURED_REQUIRES_ADDRESSABLE.getName(), SensitivityResourceDefinition.CONFIGURED_REQUIRES_ADDRESSABLE.parse(value, (XMLStreamReader)reader));
                        continue block7;
                    }
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null && !vault) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        if (type == null && !vault) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.TYPE));
        }
        ModelNode newAddress = vault ? address : address.clone().add(SensitivityClassificationTypeResourceDefinition.PATH_ELEMENT.getKey(), type).add(SensitivityResourceDefinition.PATH_ELEMENT.getKey(), name);
        for (Map.Entry entry : values.entrySet()) {
            list.add(Util.getWriteAttributeOperation((ModelNode)newAddress, (String)((String)entry.getKey()), (ModelNode)((ModelNode)entry.getValue())));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseApplicationClassifications(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case APPLICATION_CLASSIFICATION: {
                    this.parseApplicationClassification(reader, address, list);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseApplicationClassification(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        String name = null;
        String type = null;
        Boolean applicationValue = null;
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block5;
                }
                case TYPE: {
                    type = value;
                    continue block5;
                }
                case APPLICATION: {
                    applicationValue = Boolean.valueOf(value);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
        }
        if (type == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.TYPE));
        }
        if (applicationValue == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.APPLICATION));
        }
        ModelNode newAddress = address.clone().add(ApplicationClassificationTypeResourceDefinition.PATH_ELEMENT.getKey(), type).add(ApplicationClassificationConfigResourceDefinition.PATH_ELEMENT.getKey(), name);
        list.add(Util.getWriteAttributeOperation((ModelNode)newAddress, (String)ApplicationClassificationConfigResourceDefinition.CONFIGURED_APPLICATION.getName(), (String)applicationValue.toString()));
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseSensitivityClassification(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        this.parseClassificationType(reader, address, list, false);
    }

    public void writeAccessControl(XMLExtendedStreamWriter writer, ModelNode accessAuthorization) throws XMLStreamException {
        ModelNode serverGroupRoles;
        if (accessAuthorization == null || !accessAuthorization.isDefined()) {
            return;
        }
        boolean hasServerGroupRoles = accessAuthorization.hasDefined("server-group-scoped-role");
        boolean hasHostRoles = accessAuthorization.hasDefined("host-scoped-role") || accessAuthorization.hasDefined("host-scoped-roles");
        boolean hasRoleMapping = accessAuthorization.hasDefined("role-mapping");
        Map<String, Map<String, Set<String>>> configuredAccessConstraints = AccessControlXml.getConfiguredAccessConstraints(accessAuthorization);
        boolean hasProvider = accessAuthorization.hasDefined(AccessAuthorizationResourceDefinition.PROVIDER.getName());
        boolean hasCombinationPolicy = accessAuthorization.hasDefined(AccessAuthorizationResourceDefinition.PERMISSION_COMBINATION_POLICY.getName());
        if (!(hasProvider || hasCombinationPolicy || hasServerGroupRoles || hasHostRoles || hasRoleMapping || configuredAccessConstraints.size() != 0)) {
            return;
        }
        writer.writeStartElement(Element.ACCESS_CONTROL.getLocalName());
        AccessAuthorizationResourceDefinition.PROVIDER.marshallAsAttribute(accessAuthorization, (XMLStreamWriter)writer);
        AccessAuthorizationResourceDefinition.PERMISSION_COMBINATION_POLICY.marshallAsAttribute(accessAuthorization, (XMLStreamWriter)writer);
        if (hasServerGroupRoles && (serverGroupRoles = accessAuthorization.get("server-group-scoped-role")).asInt() > 0) {
            this.writeServerGroupScopedRoles(writer, serverGroupRoles);
        }
        if (hasHostRoles && (serverGroupRoles = accessAuthorization.get("host-scoped-role")).asInt() > 0) {
            this.writeHostScopedRoles(writer, serverGroupRoles);
        }
        if (hasRoleMapping) {
            this.writeRoleMapping(writer, accessAuthorization);
        }
        if (configuredAccessConstraints.size() > 0) {
            this.writeAccessConstraints(writer, accessAuthorization, configuredAccessConstraints);
        }
        writer.writeEndElement();
    }

    private void writeServerGroupScopedRoles(XMLExtendedStreamWriter writer, ModelNode scopedRoles) throws XMLStreamException {
        writer.writeStartElement(Element.SERVER_GROUP_SCOPED_ROLES.getLocalName());
        for (Property property : scopedRoles.asPropertyList()) {
            writer.writeStartElement(Element.ROLE.getLocalName());
            writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
            ModelNode value = property.getValue();
            ServerGroupScopedRoleResourceDefinition.BASE_ROLE.marshallAsAttribute(value, (XMLStreamWriter)writer);
            ServerGroupScopedRoleResourceDefinition.SERVER_GROUPS.marshallAsElement(value, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeHostScopedRoles(XMLExtendedStreamWriter writer, ModelNode scopedRoles) throws XMLStreamException {
        writer.writeStartElement(Element.HOST_SCOPED_ROLES.getLocalName());
        for (Property property : scopedRoles.asPropertyList()) {
            writer.writeStartElement(Element.ROLE.getLocalName());
            writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
            ModelNode value = property.getValue();
            HostScopedRolesResourceDefinition.BASE_ROLE.marshallAsAttribute(value, (XMLStreamWriter)writer);
            HostScopedRolesResourceDefinition.HOSTS.marshallAsElement(value, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeAccessConstraints(XMLExtendedStreamWriter writer, ModelNode accessAuthorization, Map<String, Map<String, Set<String>>> configuredConstraints) throws XMLStreamException {
        ModelNode model;
        Map<String, Set<String>> constraints;
        writer.writeStartElement(Element.CONSTRAINTS.getLocalName());
        if (configuredConstraints.containsKey(SensitivityResourceDefinition.VAULT_ELEMENT.getKey())) {
            writer.writeEmptyElement(Element.VAULT_EXPRESSION_SENSITIVITY.getLocalName());
            ModelNode model2 = accessAuthorization.get(new String[]{SensitivityResourceDefinition.VAULT_ELEMENT.getKey(), SensitivityResourceDefinition.VAULT_ELEMENT.getValue()});
            SensitivityResourceDefinition.CONFIGURED_REQUIRES_READ.marshallAsAttribute(model2, (XMLStreamWriter)writer);
            SensitivityResourceDefinition.CONFIGURED_REQUIRES_WRITE.marshallAsAttribute(model2, (XMLStreamWriter)writer);
        }
        if (configuredConstraints.containsKey("sensitivity-classification")) {
            writer.writeStartElement(Element.SENSITIVE_CLASSIFICATIONS.getLocalName());
            constraints = configuredConstraints.get("sensitivity-classification");
            for (Map.Entry<String, Set<String>> entry : constraints.entrySet()) {
                for (String classification : entry.getValue()) {
                    writer.writeEmptyElement(Element.SENSITIVE_CLASSIFICATION.getLocalName());
                    model = accessAuthorization.get(new String[]{"constraint", "sensitivity-classification", "type", entry.getKey(), "classification", classification});
                    WriteUtils.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.TYPE, (String)entry.getKey());
                    WriteUtils.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.NAME, (String)classification);
                    SensitivityResourceDefinition.CONFIGURED_REQUIRES_ADDRESSABLE.marshallAsAttribute(model, (XMLStreamWriter)writer);
                    SensitivityResourceDefinition.CONFIGURED_REQUIRES_READ.marshallAsAttribute(model, (XMLStreamWriter)writer);
                    SensitivityResourceDefinition.CONFIGURED_REQUIRES_WRITE.marshallAsAttribute(model, (XMLStreamWriter)writer);
                }
            }
            writer.writeEndElement();
        }
        if (configuredConstraints.containsKey("application-classification")) {
            writer.writeStartElement(Element.APPLICATION_CLASSIFICATIONS.getLocalName());
            constraints = configuredConstraints.get("application-classification");
            for (Map.Entry<String, Set<String>> entry : constraints.entrySet()) {
                for (String classification : entry.getValue()) {
                    writer.writeEmptyElement(Element.APPLICATION_CLASSIFICATION.getLocalName());
                    model = accessAuthorization.get(new String[]{"constraint", "application-classification", "type", entry.getKey(), "classification", classification});
                    WriteUtils.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.TYPE, (String)entry.getKey());
                    WriteUtils.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.NAME, (String)classification);
                    ApplicationClassificationConfigResourceDefinition.CONFIGURED_APPLICATION.marshallAsAttribute(model, (XMLStreamWriter)writer);
                }
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeRoleMapping(XMLExtendedStreamWriter writer, ModelNode accessAuthorization) throws XMLStreamException {
        writer.writeStartElement(Element.ROLE_MAPPING.getLocalName());
        if (accessAuthorization.hasDefined("role-mapping")) {
            ModelNode roleMappings = accessAuthorization.get("role-mapping");
            for (Property variable : roleMappings.asPropertyList()) {
                writer.writeStartElement(Element.ROLE.getLocalName());
                WriteUtils.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.NAME, (String)variable.getName());
                ModelNode role = variable.getValue();
                RoleMappingResourceDefinition.INCLUDE_ALL.marshallAsAttribute(role, (XMLStreamWriter)writer);
                if (role.hasDefined("include")) {
                    this.writeIncludeExclude(writer, Element.INCLUDE.getLocalName(), role.get("include"));
                }
                if (role.hasDefined("exclude")) {
                    this.writeIncludeExclude(writer, Element.EXCLUDE.getLocalName(), role.get("exclude"));
                }
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    private void writeIncludeExclude(XMLExtendedStreamWriter writer, String elementName, ModelNode includeExclude) throws XMLStreamException {
        List list = includeExclude.asPropertyList();
        if (list.isEmpty()) {
            return;
        }
        writer.writeStartElement(elementName);
        for (Property current : list) {
            this.writePrincipal(writer, current.getName(), current.getValue());
        }
        writer.writeEndElement();
    }

    private void writePrincipal(XMLExtendedStreamWriter writer, String alias, ModelNode principal) throws XMLStreamException {
        String elementName = principal.require("type").asString().equalsIgnoreCase("group") ? Element.GROUP.getLocalName() : Element.USER.getLocalName();
        writer.writeStartElement(elementName);
        String realm = principal.get("realm").isDefined() ? principal.require("realm").asString() : null;
        String name = principal.require("name").asString();
        String expectedAlias = AccessControlXml.generateAlias(elementName, name, realm);
        if (!alias.equals(expectedAlias)) {
            WriteUtils.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.ALIAS, (String)alias);
        }
        PrincipalResourceDefinition.REALM.marshallAsAttribute(principal, (XMLStreamWriter)writer);
        PrincipalResourceDefinition.NAME.marshallAsAttribute(principal, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    static Map<String, Map<String, Set<String>>> getConfiguredAccessConstraints(ModelNode accessAuthorization) {
        HashMap<String, Map<String, Set<String>>> configuredConstraints = new HashMap<String, Map<String, Set<String>>>();
        if (accessAuthorization != null && accessAuthorization.hasDefined("constraint")) {
            ModelNode constraint = accessAuthorization.get("constraint");
            configuredConstraints.putAll(AccessControlXml.getVaultConstraints(constraint));
            configuredConstraints.putAll(AccessControlXml.getSensitivityClassificationConstraints(constraint));
            configuredConstraints.putAll(AccessControlXml.getApplicationClassificationConstraints(constraint));
        }
        return configuredConstraints;
    }

    static Map<String, Map<String, Set<String>>> getVaultConstraints(ModelNode constraint) {
        ModelNode classification;
        HashMap<String, Map<String, Set<String>>> configuredConstraints = new HashMap<String, Map<String, Set<String>>>();
        if (constraint.hasDefined("vault-expression") && ((classification = constraint.require("vault-expression")).hasDefined(SensitivityResourceDefinition.CONFIGURED_REQUIRES_WRITE.getName()) || classification.hasDefined(SensitivityResourceDefinition.CONFIGURED_REQUIRES_READ.getName()))) {
            configuredConstraints.put(SensitivityResourceDefinition.VAULT_ELEMENT.getKey(), Collections.emptyMap());
        }
        return configuredConstraints;
    }

    static Map<String, Map<String, Set<String>>> getSensitivityClassificationConstraints(ModelNode constraint) {
        ModelNode sensitivityParent;
        HashMap<String, Map<String, Set<String>>> configuredConstraints = new HashMap<String, Map<String, Set<String>>>();
        if (constraint.hasDefined("sensitivity-classification") && (sensitivityParent = constraint.require("sensitivity-classification")).hasDefined("type")) {
            for (Property typeProperty : sensitivityParent.get("type").asPropertyList()) {
                if (!typeProperty.getValue().hasDefined("classification")) continue;
                for (Property sensitivityProperty : typeProperty.getValue().get("classification").asPropertyList()) {
                    TreeSet<String> types;
                    ModelNode classification = sensitivityProperty.getValue();
                    if (!classification.hasDefined(SensitivityResourceDefinition.CONFIGURED_REQUIRES_ADDRESSABLE.getName()) && !classification.hasDefined(SensitivityResourceDefinition.CONFIGURED_REQUIRES_WRITE.getName()) && !classification.hasDefined(SensitivityResourceDefinition.CONFIGURED_REQUIRES_READ.getName())) continue;
                    TreeMap<String, TreeSet<String>> constraintMap = (TreeMap<String, TreeSet<String>>)configuredConstraints.get("sensitivity-classification");
                    if (constraintMap == null) {
                        constraintMap = new TreeMap<String, TreeSet<String>>();
                        configuredConstraints.put("sensitivity-classification", constraintMap);
                    }
                    if ((types = (TreeSet<String>)constraintMap.get(typeProperty.getName())) == null) {
                        types = new TreeSet<String>();
                        constraintMap.put(typeProperty.getName(), types);
                    }
                    types.add(sensitivityProperty.getName());
                }
            }
        }
        return configuredConstraints;
    }

    static Map<String, Map<String, Set<String>>> getApplicationClassificationConstraints(ModelNode constraint) {
        ModelNode appTypeParent;
        HashMap<String, Map<String, Set<String>>> configuredConstraints = new HashMap<String, Map<String, Set<String>>>();
        if (constraint.hasDefined("application-classification") && (appTypeParent = constraint.require("application-classification")).hasDefined("type")) {
            for (Property typeProperty : appTypeParent.get("type").asPropertyList()) {
                if (!typeProperty.getValue().hasDefined("classification")) continue;
                for (Property applicationProperty : typeProperty.getValue().get("classification").asPropertyList()) {
                    TreeSet<String> types;
                    ModelNode applicationType = applicationProperty.getValue();
                    if (!applicationType.hasDefined(ApplicationClassificationConfigResourceDefinition.CONFIGURED_APPLICATION.getName())) continue;
                    TreeMap<String, TreeSet<String>> constraintMap = (TreeMap<String, TreeSet<String>>)configuredConstraints.get("application-classification");
                    if (constraintMap == null) {
                        constraintMap = new TreeMap<String, TreeSet<String>>();
                        configuredConstraints.put("application-classification", constraintMap);
                    }
                    if ((types = (TreeSet<String>)constraintMap.get(typeProperty.getName())) == null) {
                        types = new TreeSet<String>();
                        constraintMap.put(typeProperty.getName(), types);
                    }
                    types.add(applicationProperty.getName());
                }
            }
        }
        return configuredConstraints;
    }
}

