/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.process;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.as.process.ManagedProcess;
import org.jboss.as.process.ProcessControllerServerHandler;
import org.jboss.as.process.ProcessMessageHandler;
import org.jboss.as.process.logging.ProcessLogger;
import org.jboss.as.process.protocol.Connection;
import org.jboss.as.process.protocol.ProtocolServer;
import org.jboss.as.process.protocol.StreamUtils;

public final class ProcessController {
    private final Object lock = new Object();
    private final ProtocolServer server;
    private final Map<String, ManagedProcess> processes = Collections.synchronizedMap(new HashMap());
    private final Map<Key, ManagedProcess> processesByKey = new HashMap<Key, ManagedProcess>();
    private final Set<Connection> managedConnections = new CopyOnWriteArraySet<Connection>();
    private volatile boolean shutdown;
    public static final short AUTH_BYTES_LENGTH = 16;
    public static final short AUTH_BYTES_ENCODED_LENGTH = 24;
    private final PrintStream stdout;
    private final PrintStream stderr;

    public ProcessController(ProtocolServer.Configuration configuration, PrintStream stdout, PrintStream stderr) throws IOException {
        this.stdout = stdout;
        this.stderr = stderr;
        configuration.setConnectionHandler(new ProcessControllerServerHandler(this));
        ProtocolServer server = new ProtocolServer(configuration);
        server.start();
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addManagedConnection(Connection connection) {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            this.managedConnections.add(connection);
        }
    }

    void removeManagedConnection(Connection connection) {
        this.managedConnections.remove(connection);
    }

    public void addProcess(String processName, List<String> command, Map<String, String> env, String workingDirectory, boolean isPrivileged, boolean respawn) {
        byte[] authBytes = new byte[16];
        new Random(new SecureRandom().nextLong()).nextBytes(authBytes);
        String authKey = Base64.getEncoder().encodeToString(authBytes);
        this.addProcess(processName, authKey, command, env, workingDirectory, isPrivileged, respawn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProcess(String processName, String authKey, List<String> command, Map<String, String> env, String workingDirectory, boolean isPrivileged, boolean respawn) {
        for (String s : command) {
            if (s != null) continue;
            throw ProcessLogger.ROOT_LOGGER.nullCommandComponent();
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            Map<String, ManagedProcess> processes = this.processes;
            if (processes.containsKey(processName)) {
                ProcessLogger.ROOT_LOGGER.duplicateProcessName(processName);
                return;
            }
            ManagedProcess process = new ManagedProcess(processName, command, env, workingDirectory, this.lock, this, authKey, isPrivileged, respawn);
            processes.put(processName, process);
            this.processesByKey.put(new Key(authKey.getBytes(Charset.forName("US-ASCII"))), process);
            this.processAdded(processName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProcess(String processName) {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            Map<String, ManagedProcess> processes = this.processes;
            ManagedProcess process = processes.get(processName);
            if (process == null) {
                ProcessLogger.ROOT_LOGGER.attemptToStartNonExistentProcess(processName);
                return;
            }
            process.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopProcess(String processName) {
        Object object = this.lock;
        synchronized (object) {
            Map<String, ManagedProcess> processes = this.processes;
            ManagedProcess process = processes.get(processName);
            if (process == null) {
                ProcessLogger.ROOT_LOGGER.attemptToStopNonExistentProcess(processName);
                return;
            }
            process.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyProcess(String processName) {
        Object object = this.lock;
        synchronized (object) {
            Map<String, ManagedProcess> processes = this.processes;
            ManagedProcess process = processes.get(processName);
            if (process == null) {
                return;
            }
            process.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killProcess(String processName) {
        Object object = this.lock;
        synchronized (object) {
            Map<String, ManagedProcess> processes = this.processes;
            ManagedProcess process = processes.get(processName);
            if (process == null) {
                return;
            }
            process.kill();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProcess(String processName) {
        Object object = this.lock;
        synchronized (object) {
            Map<String, ManagedProcess> processes = this.processes;
            ManagedProcess process = processes.get(processName);
            if (process == null) {
                ProcessLogger.ROOT_LOGGER.attemptToRemoveNonExistentProcess(processName);
                return;
            }
            boolean removed = processes.remove(processName) != null;
            this.processesByKey.remove(new Key(process.getAuthKey().getBytes(Charset.forName("US-ASCII"))));
            if (removed) {
                this.processRemoved(processName);
            }
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendStdin(String recipient, InputStream source) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            Map<String, ManagedProcess> processes = this.processes;
            ManagedProcess process = processes.get(recipient);
            if (process == null) {
                return;
            }
            process.sendStdin(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            ProcessLogger.ROOT_LOGGER.shuttingDown();
            this.shutdown = true;
            ManagedProcess hc = this.processes.get("Host Controller");
            if (hc != null && hc.isRunning()) {
                hc.shutdown();
                while (this.processes.containsKey("Host Controller")) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            for (ManagedProcess process : this.processes.values()) {
                process.shutdown();
            }
            while (!this.processes.isEmpty()) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            ProcessLogger.ROOT_LOGGER.shutdownComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedProcess getServerByAuthCode(byte[] code) {
        Object object = this.lock;
        synchronized (object) {
            return this.processesByKey.get(new Key(code));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processAdded(String processName) {
        Object object = this.lock;
        synchronized (object) {
            for (Connection connection : this.managedConnections) {
                try {
                    OutputStream os = connection.writeMessage();
                    try {
                        os.write(16);
                        StreamUtils.writeUTFZBytes(os, processName);
                        os.close();
                    }
                    finally {
                        StreamUtils.safeClose(os);
                    }
                }
                catch (IOException e) {
                    ProcessLogger.ROOT_LOGGER.failedToWriteMessage("PROCESS_ADDED", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processStarted(String processName) {
        Object object = this.lock;
        synchronized (object) {
            for (Connection connection : this.managedConnections) {
                try {
                    OutputStream os = connection.writeMessage();
                    try {
                        os.write(17);
                        StreamUtils.writeUTFZBytes(os, processName);
                        os.close();
                    }
                    finally {
                        StreamUtils.safeClose(os);
                    }
                }
                catch (IOException e) {
                    ProcessLogger.ROOT_LOGGER.failedToWriteMessage("PROCESS_STARTED", e);
                    this.removeManagedConnection(connection);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processStopped(String processName, long uptime) {
        Object object = this.lock;
        synchronized (object) {
            for (Connection connection : this.managedConnections) {
                try {
                    OutputStream os = connection.writeMessage();
                    try {
                        os.write(18);
                        StreamUtils.writeUTFZBytes(os, processName);
                        StreamUtils.writeLong(os, uptime);
                        os.close();
                    }
                    finally {
                        StreamUtils.safeClose(os);
                    }
                }
                catch (IOException e) {
                    ProcessLogger.ROOT_LOGGER.failedToWriteMessage("PROCESS_STOPPED", e);
                    this.removeManagedConnection(connection);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processRemoved(String processName) {
        Object object = this.lock;
        synchronized (object) {
            for (Connection connection : this.managedConnections) {
                try {
                    OutputStream os = connection.writeMessage();
                    try {
                        os.write(19);
                        StreamUtils.writeUTFZBytes(os, processName);
                        os.close();
                    }
                    finally {
                        StreamUtils.safeClose(os);
                    }
                }
                catch (IOException e) {
                    ProcessLogger.ROOT_LOGGER.failedToWriteMessage("PROCESS_REMOVED " + processName, e);
                    this.removeManagedConnection(connection);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendInventory() {
        Object object = this.lock;
        synchronized (object) {
            for (Connection connection : this.managedConnections) {
                try {
                    OutputStream os = connection.writeMessage();
                    try {
                        os.write(20);
                        Collection<ManagedProcess> processCollection = this.processes.values();
                        StreamUtils.writeInt(os, processCollection.size());
                        for (ManagedProcess process : processCollection) {
                            StreamUtils.writeUTFZBytes(os, process.getProcessName());
                            os.write(process.getAuthKey().getBytes(Charset.forName("US-ASCII")));
                            StreamUtils.writeBoolean(os, process.isRunning());
                            StreamUtils.writeBoolean(os, process.isStopping());
                        }
                        os.close();
                    }
                    finally {
                        StreamUtils.safeClose(os);
                    }
                }
                catch (IOException e) {
                    ProcessLogger.ROOT_LOGGER.failedToWriteMessage("PROCESS_INVENTORY", e);
                    this.removeManagedConnection(connection);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendReconnectProcess(String processName, String scheme, String hostName, int port, boolean managementSubsystemEndpoint, String asAuthKey) {
        Object object = this.lock;
        synchronized (object) {
            ManagedProcess process = this.processes.get(processName);
            if (process == null) {
                ProcessLogger.ROOT_LOGGER.attemptToReconnectNonExistentProcess(processName);
                return;
            }
            process.reconnect(scheme, hostName, port, managementSubsystemEndpoint, asAuthKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void operationFailed(String processName, ProcessMessageHandler.OperationType operationType) {
        Object object = this.lock;
        synchronized (object) {
            for (Connection connection : this.managedConnections) {
                try {
                    OutputStream os = connection.writeMessage();
                    try {
                        os.write(22);
                        os.write(operationType.getCode());
                        StreamUtils.writeUTFZBytes(os, processName);
                        os.close();
                    }
                    finally {
                        StreamUtils.safeClose(os);
                    }
                }
                catch (IOException e) {
                    ProcessLogger.ROOT_LOGGER.failedToWriteMessage("OPERATION_FAILED", e);
                    this.removeManagedConnection(connection);
                }
            }
        }
    }

    int getOngoingProcessCount() {
        return this.shutdown ? 0 : this.processes.size();
    }

    public ProtocolServer getServer() {
        return this.server;
    }

    PrintStream getStdout() {
        return this.stdout;
    }

    PrintStream getStderr() {
        return this.stderr;
    }

    private static final class Key {
        private final byte[] authKey;
        private final int hashCode;

        public Key(byte[] authKey) {
            this.authKey = authKey;
            this.hashCode = Arrays.hashCode(authKey);
        }

        public boolean equals(Object other) {
            return other instanceof Key && this.equals((Key)other);
        }

        public boolean equals(Key other) {
            return this == other || other != null && Arrays.equals(this.authKey, other.authKey);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

