/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.server.hotrod.CacheDecodeContext;
import org.infinispan.server.hotrod.ContextHandler;
import org.infinispan.server.hotrod.Response;
import org.infinispan.server.hotrod.logging.JavaLog;

public class ResponseWriting {
    private static final JavaLog log = (JavaLog)LogFactory.getLog(ContextHandler.class, JavaLog.class);

    private ResponseWriting() {
    }

    public static void writeResponse(CacheDecodeContext ctx, Channel ch, Object response) {
        if (response != null) {
            if (ctx.isTrace()) {
                log.tracef("Write response %s", response);
            }
            if (response instanceof Response) {
                ch.writeAndFlush(response);
            } else if (response instanceof ByteBuf[]) {
                for (ByteBuf buf : (ByteBuf[])response) {
                    ch.write((Object)buf);
                }
                ch.flush();
            } else if (response instanceof byte[]) {
                ch.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])((byte[])response)));
            } else if (response instanceof CharSequence) {
                ch.writeAndFlush((Object)Unpooled.copiedBuffer((CharSequence)((CharSequence)response), (Charset)CharsetUtil.UTF_8));
            } else {
                ch.writeAndFlush(response);
            }
        }
    }
}

