/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.extended;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;

public class PathConverter
extends AbstractSingleValueConverter {
    public boolean canConvert(Class type) {
        return Path.class.isAssignableFrom(type);
    }

    public Object fromString(String str) {
        try {
            URI uri = new URI(str);
            if (uri.getScheme() == null) {
                return Paths.get(str, new String[0]);
            }
            return Paths.get(uri);
        }
        catch (URISyntaxException e) {
            throw new ConversionException(e);
        }
    }

    public String toString(Object obj) {
        Path path = (Path)obj;
        if (path.getFileSystem() == FileSystems.getDefault()) {
            return path.toString();
        }
        return path.toUri().toString();
    }
}

