/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.relay;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.annotations.XmlElement;
import org.jgroups.annotations.XmlInclude;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.protocols.FORWARD_TO_COORD;
import org.jgroups.protocols.relay.Relayer;
import org.jgroups.protocols.relay.RouteStatusListener;
import org.jgroups.protocols.relay.SiteAddress;
import org.jgroups.protocols.relay.SiteMaster;
import org.jgroups.protocols.relay.SiteUUID;
import org.jgroups.protocols.relay.config.RelayConfig;
import org.jgroups.stack.AddressGenerator;
import org.jgroups.stack.Protocol;
import org.jgroups.util.ExtendedUUID;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;
import org.w3c.dom.Node;

@XmlInclude(schema={"relay.xsd"}, type=XmlInclude.Type.IMPORT, namespace="urn:jgroups:relay:1.0", alias="relay")
@XmlElement(name="RelayConfiguration", type="relay:RelayConfigurationType")
@MBean(description="RELAY2 protocol")
public class RELAY2
extends Protocol {
    @Property(description="Name of the site (needs to be defined in the configuration)", writable=false)
    protected String site;
    @Property(description="Name of the relay configuration", writable=false)
    protected String config;
    @Property(description="Whether or not this node can become the site master. If false, and we become the coordinator, we won't start the bridge(s)", writable=false)
    protected boolean can_become_site_master = true;
    @Property(description="Maximum number of site masters. Setting this to a value greater than 1 means that we can have multiple site masters. If the value is greater than the number of cluster nodes, everyone in the site will be a site master (and thus join the global cluster", writable=false)
    protected int max_site_masters = 1;
    @Property(description="Whether or not we generate our own addresses in which we use can_become_site_master. If this property is false, can_become_site_master is ignored")
    protected boolean enable_address_tagging = false;
    @Property(description="Whether or not to relay multicast (dest=null) messages")
    protected boolean relay_multicasts = true;
    @Property(description="If true, the creation of the relay channel (and the connect()) are done in the background. Async relay creation is recommended, so the view callback won't be blocked")
    protected boolean async_relay_creation = true;
    @Property(description="If true, logs a warning if the FORWARD_TO_COORD protocol is not found. This property might get deprecated soon")
    protected boolean warn_when_ftc_missing = false;
    protected final Map<String, RelayConfig.SiteConfig> sites = new HashMap<String, RelayConfig.SiteConfig>();
    protected RelayConfig.SiteConfig site_config;
    @ManagedAttribute(description="Whether this member is a site master")
    protected volatile boolean is_site_master = false;
    protected volatile List<Address> site_masters;
    protected volatile Relayer relayer;
    protected TimeScheduler timer;
    protected volatile Address local_addr;
    protected volatile List<Address> members = new ArrayList<Address>(11);
    @ManagedAttribute(description="FORWARD_TO_COORD protocol is present below the current protocol")
    protected boolean forwarding_protocol_present;
    @Property(description="If true, a site master forwards messages received from other sites to randomly chosen members of the local site for load balancing, reducing work for itself")
    protected boolean can_forward_local_cluster = false;
    protected short[] prots_above;
    protected volatile RouteStatusListener route_status_listener;
    protected final AtomicLong forward_to_site_master = new AtomicLong(0L);
    protected final AtomicLong forward_sm_time = new AtomicLong(0L);
    protected final AtomicLong relayed = new AtomicLong(0L);
    protected final AtomicLong relayed_time = new AtomicLong(0L);
    protected final AtomicLong forward_to_local_mbr = new AtomicLong(0L);
    protected final AtomicLong forward_to_local_mbr_time = new AtomicLong(0L);
    protected final AtomicLong local_deliveries = new AtomicLong(0L);
    protected final AtomicLong local_delivery_time = new AtomicLong(0L);

    public RELAY2 site(String site_name) {
        this.site = site_name;
        return this;
    }

    public RELAY2 config(String cfg) {
        this.config = cfg;
        return this;
    }

    public RELAY2 canBecomeSiteMaster(boolean flag) {
        this.can_become_site_master = flag;
        return this;
    }

    public RELAY2 enableAddressTagging(boolean flag) {
        this.enable_address_tagging = flag;
        return this;
    }

    public RELAY2 relayMulticasts(boolean flag) {
        this.relay_multicasts = flag;
        return this;
    }

    public RELAY2 asyncRelayCreation(boolean flag) {
        this.async_relay_creation = flag;
        return this;
    }

    public String site() {
        return this.site;
    }

    public List<String> siteNames() {
        return this.getSites();
    }

    public String config() {
        return this.config;
    }

    public boolean canBecomeSiteMaster() {
        return this.can_become_site_master;
    }

    public boolean enableAddressTagging() {
        return this.enable_address_tagging;
    }

    public boolean relayMulticasts() {
        return this.relay_multicasts;
    }

    public boolean asyncRelayCreation() {
        return this.async_relay_creation;
    }

    public Address getLocalAddress() {
        return this.local_addr;
    }

    public TimeScheduler getTimer() {
        return this.timer;
    }

    public void incrementRelayed() {
        this.relayed.incrementAndGet();
    }

    public void addToRelayedTime(long delta) {
        this.relayed_time.addAndGet(delta);
    }

    public RouteStatusListener getRouteStatusListener() {
        return this.route_status_listener;
    }

    public void setRouteStatusListener(RouteStatusListener l) {
        this.route_status_listener = l;
    }

    @ManagedAttribute(description="Number of messages forwarded to the local SiteMaster")
    public long getNumForwardedToSiteMaster() {
        return this.forward_to_site_master.get();
    }

    @ManagedAttribute(description="The total time (in ms) spent forwarding messages to the local SiteMaster")
    public long getTimeForwardingToSM() {
        return TimeUnit.MILLISECONDS.convert(this.forward_sm_time.get(), TimeUnit.NANOSECONDS);
    }

    @ManagedAttribute(description="The average number of messages / s for forwarding messages to the local SiteMaster")
    public long getAvgMsgsForwardingToSM() {
        return this.getTimeForwardingToSM() > 0L ? (long)((double)this.getNumForwardedToSiteMaster() / ((double)this.getTimeForwardingToSM() / 1000.0)) : 0L;
    }

    @ManagedAttribute(description="Number of messages sent by this SiteMaster to a remote SiteMaster")
    public long getNumRelayed() {
        return this.relayed.get();
    }

    @ManagedAttribute(description="The total time (ms) spent relaying messages from this SiteMaster to remote SiteMasters")
    public long getTimeRelaying() {
        return TimeUnit.MILLISECONDS.convert(this.relayed_time.get(), TimeUnit.NANOSECONDS);
    }

    @ManagedAttribute(description="The average number of messages / s for relaying messages from this SiteMaster to remote SiteMasters")
    public long getAvgMsgsRelaying() {
        return this.getTimeRelaying() > 0L ? (long)((double)this.getNumRelayed() / ((double)this.getTimeRelaying() / 1000.0)) : 0L;
    }

    @ManagedAttribute(description="Number of messages (received from a remote Sitemaster and) delivered by this SiteMaster to a local node")
    public long getNumForwardedToLocalMbr() {
        return this.forward_to_local_mbr.get();
    }

    @ManagedAttribute(description="The total time (in ms) spent forwarding messages to a member in the same site")
    public long getTimeForwardingToLocalMbr() {
        return TimeUnit.MILLISECONDS.convert(this.forward_to_local_mbr_time.get(), TimeUnit.NANOSECONDS);
    }

    @ManagedAttribute(description="The average number of messages / s for forwarding messages to a member in the same site")
    public long getAvgMsgsForwardingToLocalMbr() {
        return this.getTimeForwardingToLocalMbr() > 0L ? (long)((double)this.getNumForwardedToLocalMbr() / ((double)this.getTimeForwardingToLocalMbr() / 1000.0)) : 0L;
    }

    @ManagedAttribute(description="Number of messages delivered locally, e.g. received and delivered to self")
    public long getNumLocalDeliveries() {
        return this.local_deliveries.get();
    }

    @ManagedAttribute(description="The total time (ms) spent delivering received messages locally")
    public long getTimeDeliveringLocally() {
        return TimeUnit.MILLISECONDS.convert(this.local_delivery_time.get(), TimeUnit.NANOSECONDS);
    }

    @ManagedAttribute(description="The average number of messages / s for delivering received messages locally")
    public long getAvgMsgsDeliveringLocally() {
        return this.getTimeDeliveringLocally() > 0L ? (long)((double)this.getNumLocalDeliveries() / ((double)this.getTimeDeliveringLocally() / 1000.0)) : 0L;
    }

    @ManagedAttribute(description="Whether or not this instance is a site master")
    public boolean isSiteMaster() {
        return this.relayer != null;
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.forward_to_site_master.set(0L);
        this.forward_sm_time.set(0L);
        this.relayed.set(0L);
        this.relayed_time.set(0L);
        this.forward_to_local_mbr.set(0L);
        this.forward_to_local_mbr_time.set(0L);
        this.local_deliveries.set(0L);
        this.local_delivery_time.set(0L);
    }

    public View getBridgeView(String cluster_name) {
        Relayer tmp = this.relayer;
        return tmp != null ? tmp.getBridgeView(cluster_name) : null;
    }

    public RELAY2 addSite(String site_name, RelayConfig.SiteConfig cfg) {
        this.sites.put(site_name, cfg);
        return this;
    }

    public List<String> getSites() {
        return this.sites.isEmpty() ? Collections.emptyList() : new ArrayList<String>(this.sites.keySet());
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.configure();
    }

    public void configure() throws Exception {
        List<Integer> available_down_services;
        this.timer = this.getTransport().getTimer();
        if (this.site == null) {
            throw new IllegalArgumentException("site cannot be null");
        }
        if (this.max_site_masters < 1) {
            this.log.warn("max_size_masters was " + this.max_site_masters + ", changed to 1");
            this.max_site_masters = 1;
        }
        if (this.config != null) {
            this.parseSiteConfiguration(this.sites);
        }
        this.site_config = this.sites.get(this.site);
        if (this.site_config == null) {
            throw new Exception("site configuration for \"" + this.site + "\" not found in " + this.config);
        }
        this.log.trace(this.local_addr + ": site configuration:\n" + this.site_config);
        if (!this.site_config.getForwards().isEmpty()) {
            this.log.warn(this.local_addr + ": forwarding routes are currently not supported and will be ignored. This will change " + "with hierarchical routing (https://issues.jboss.org/browse/JGRP-1506)");
        }
        boolean bl = this.forwarding_protocol_present = (available_down_services = this.getDownServices()) != null && available_down_services.contains(105);
        if (!this.forwarding_protocol_present && this.warn_when_ftc_missing && this.log.isWarnEnabled()) {
            this.log.warn(this.local_addr + ": " + FORWARD_TO_COORD.class.getSimpleName() + " protocol not found below; " + "unable to re-submit messages to the new coordinator if the current coordinator crashes");
        }
        if (this.enable_address_tagging) {
            JChannel ch = this.getProtocolStack().getChannel();
            ch.addAddressGenerator(new AddressGenerator(){

                @Override
                public Address generateAddress() {
                    ExtendedUUID retval = ExtendedUUID.randomUUID();
                    if (RELAY2.this.can_become_site_master) {
                        retval.setFlag((short)2);
                    }
                    return retval;
                }
            });
        }
        this.prots_above = this.getIdsAbove();
    }

    @Override
    public void stop() {
        super.stop();
        this.is_site_master = false;
        this.log.trace(this.local_addr + ": ceased to be site master; closing bridges");
        if (this.relayer != null) {
            this.relayer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseSiteConfiguration(Map<String, RelayConfig.SiteConfig> map) throws Exception {
        InputStream input = null;
        try {
            input = ConfiguratorFactory.getConfigStream(this.config);
            RelayConfig.parse(input, map);
        }
        finally {
            Util.close((Closeable)input);
        }
    }

    @Override
    public void parse(Node node) throws Exception {
        RelayConfig.parse(node, this.sites);
    }

    @ManagedOperation(description="Prints the contents of the routing table. Only available if we're the current coordinator (site master)")
    public String printRoutes() {
        return this.relayer != null ? this.relayer.printRoutes() : "n/a (not site master)";
    }

    public JChannel getBridge(String site_name) {
        Relayer tmp = this.relayer;
        Relayer.Route route = tmp != null ? tmp.getRoute(site_name) : null;
        return route != null ? route.bridge() : null;
    }

    public Relayer.Route getRoute(String site_name) {
        Relayer tmp = this.relayer;
        return tmp != null ? tmp.getRoute(site_name) : null;
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                SiteUUID sender;
                Message msg = (Message)evt.getArg();
                Address dest = msg.getDest();
                if (dest == null || !(dest instanceof SiteAddress)) break;
                SiteAddress target = (SiteAddress)dest;
                Address src = msg.getSrc();
                SiteUUID siteUUID = sender = src instanceof SiteMaster ? new SiteMaster(((SiteMaster)src).getSite()) : new SiteUUID((UUID)this.local_addr, UUID.get(this.local_addr), this.site);
                if (this.local_addr instanceof ExtendedUUID) {
                    ((ExtendedUUID)sender).addContents((ExtendedUUID)this.local_addr);
                }
                if (target.getSite().equals(this.site)) {
                    if (this.local_addr.equals(target) || target instanceof SiteMaster && this.is_site_master) {
                        long start = this.stats ? System.nanoTime() : 0L;
                        this.forwardTo(this.local_addr, target, sender, msg, false);
                        if (this.stats) {
                            this.local_delivery_time.addAndGet(System.nanoTime() - start);
                            this.local_deliveries.incrementAndGet();
                        }
                    } else {
                        this.deliverLocally(target, sender, msg);
                    }
                    return null;
                }
                if (!this.is_site_master) {
                    long start = this.stats ? System.nanoTime() : 0L;
                    Address site_master = this.pickSiteMaster();
                    if (site_master == null) {
                        throw new IllegalStateException("site master is null");
                    }
                    this.forwardTo(site_master, target, sender, msg, this.max_site_masters == 1);
                    if (this.stats) {
                        this.forward_sm_time.addAndGet(System.nanoTime() - start);
                        this.forward_to_site_master.incrementAndGet();
                    }
                } else {
                    this.route(target, sender, msg);
                }
                return null;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 6: {
                this.handleView((View)evt.getArg());
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Relay2Header hdr = (Relay2Header)msg.getHeader(this.id);
                Address dest = msg.getDest();
                if (hdr == null) {
                    if (dest != null || !this.is_site_master || !this.relay_multicasts || msg.isFlagSet(Message.Flag.NO_RELAY)) break;
                    Address src = msg.getSrc();
                    SiteUUID sender = new SiteUUID((UUID)msg.getSrc(), UUID.get(msg.getSrc()), this.site);
                    if (src instanceof ExtendedUUID) {
                        sender.addContents((ExtendedUUID)src);
                    }
                    this.sendToBridges(sender, msg, this.site);
                    break;
                }
                if (dest != null) {
                    this.handleMessage(hdr, msg);
                } else {
                    this.deliver(null, hdr.original_sender, msg);
                }
                return null;
            }
            case 6: {
                this.handleView((View)evt.getArg());
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public void up(MessageBatch batch) {
        for (Message msg : batch) {
            Relay2Header hdr = (Relay2Header)msg.getHeader(this.id);
            Address dest = msg.getDest();
            if (hdr == null) {
                if (dest != null || !this.is_site_master || !this.relay_multicasts || msg.isFlagSet(Message.Flag.NO_RELAY)) continue;
                Address src = msg.getSrc();
                SiteUUID sender = new SiteUUID((UUID)msg.getSrc(), UUID.get(msg.getSrc()), this.site);
                if (src instanceof ExtendedUUID) {
                    sender.addContents((ExtendedUUID)src);
                }
                this.sendToBridges(sender, msg, this.site);
                continue;
            }
            batch.remove(msg);
            if (dest != null) {
                this.handleMessage(hdr, msg);
                continue;
            }
            this.deliver(null, hdr.original_sender, msg);
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    protected void handleRelayMessage(Relay2Header hdr, Message msg) {
        if (hdr.final_dest != null) {
            Message message = msg;
            Relay2Header header = hdr;
            if (header.type == 1 && this.can_forward_local_cluster) {
                SiteUUID site_uuid = (SiteUUID)hdr.final_dest;
                int index = (int)Util.random(this.members.size()) - 1;
                UUID tmp = (UUID)this.members.get(index);
                SiteUUID final_dest = new SiteUUID(tmp, site_uuid.getName(), site_uuid.getSite());
                if (!((Object)final_dest).equals(hdr.final_dest)) {
                    message = this.copy(msg);
                    header = new Relay2Header(1, final_dest, hdr.original_sender);
                    message.putHeader(this.id, header);
                }
            }
            this.handleMessage(header, message);
        } else {
            Message copy = this.copy(msg).dest(null).src(null).putHeader(this.id, hdr);
            this.down_prot.down(new Event(1, copy));
        }
    }

    protected void handleMessage(Relay2Header hdr, Message msg) {
        switch (hdr.type) {
            case 1: {
                this.route((SiteAddress)hdr.final_dest, (SiteAddress)hdr.original_sender, msg);
                break;
            }
            case 2: {
                this.up_prot.up(new Event(104, hdr.final_dest));
                break;
            }
            case 3: {
                break;
            }
            default: {
                this.log.error("type " + hdr.type + " unknown");
            }
        }
    }

    protected void route(SiteAddress dest, SiteAddress sender, Message msg) {
        String target_site = dest.getSite();
        if (target_site.equals(this.site)) {
            if (this.local_addr.equals(dest) || dest instanceof SiteMaster && this.is_site_master) {
                this.deliver(dest, sender, msg);
            } else {
                this.deliverLocally(dest, sender, msg);
            }
            return;
        }
        Relayer tmp = this.relayer;
        if (tmp == null) {
            this.log.warn(this.local_addr + ": not site master; dropping message");
            return;
        }
        Relayer.Route route = tmp.getRoute(target_site);
        if (route == null) {
            this.log.error(this.local_addr + ": no route to " + target_site + ": dropping message");
            this.sendSiteUnreachableTo(sender, target_site);
        } else {
            route.send(dest, sender, msg);
        }
    }

    protected void sendToBridges(Address sender, Message msg, String ... excluded_sites) {
        List<Relayer.Route> routes;
        Relayer tmp = this.relayer;
        List<Relayer.Route> list = routes = tmp != null ? tmp.getRoutes(excluded_sites) : null;
        if (routes == null) {
            return;
        }
        for (Relayer.Route route : routes) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.local_addr + ": relaying multicast message from " + sender + " via route " + route);
            }
            try {
                route.send(null, sender, msg);
            }
            catch (Exception ex) {
                this.log.error(this.local_addr + ": failed relaying message from " + sender + " via route " + route, ex);
            }
        }
    }

    protected void sendSiteUnreachableTo(Address dest, String target_site) {
        Message msg = new Message(dest).setFlag(Message.Flag.OOB, Message.Flag.INTERNAL).src(new SiteUUID((UUID)this.local_addr, UUID.get(this.local_addr), this.site)).putHeader(this.id, new Relay2Header(2, new SiteMaster(target_site), null));
        this.down_prot.down(new Event(1, msg));
    }

    protected void forwardTo(Address next_dest, SiteAddress final_dest, Address original_sender, Message msg, boolean forward_to_current_coord) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + ": forwarding message to final destination " + final_dest + " to " + (forward_to_current_coord ? " the current coordinator" : next_dest));
        }
        Message copy = this.copy(msg).dest(next_dest).src(null);
        Relay2Header hdr = new Relay2Header(1, final_dest, original_sender);
        copy.putHeader(this.id, hdr);
        if (forward_to_current_coord && this.forwarding_protocol_present) {
            this.down_prot.down(new Event(105, copy));
        } else {
            this.down_prot.down(new Event(1, copy));
        }
    }

    protected void deliverLocally(SiteAddress dest, SiteAddress sender, Message msg) {
        Address local_dest;
        boolean send_to_coord = false;
        if (dest instanceof SiteUUID) {
            if (dest instanceof SiteMaster) {
                local_dest = this.pickSiteMaster();
                if (local_dest == null) {
                    throw new IllegalStateException("site master was null");
                }
                send_to_coord = true;
            } else {
                SiteUUID tmp = (SiteUUID)dest;
                local_dest = new UUID(tmp.getMostSignificantBits(), tmp.getLeastSignificantBits());
            }
        } else {
            local_dest = dest;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + ": delivering message to " + dest + " in local cluster");
        }
        long start = this.stats ? System.nanoTime() : 0L;
        this.forwardTo(local_dest, dest, sender, msg, send_to_coord);
        if (this.stats) {
            this.forward_to_local_mbr_time.addAndGet(System.nanoTime() - start);
            this.forward_to_local_mbr.incrementAndGet();
        }
    }

    protected void deliver(Address dest, Address sender, Message msg) {
        try {
            Message copy = this.copy(msg).dest(dest).src(sender);
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.local_addr + ": delivering message from " + sender);
            }
            long start = this.stats ? System.nanoTime() : 0L;
            this.up_prot.up(new Event(1, copy));
            if (this.stats) {
                this.local_delivery_time.addAndGet(System.nanoTime() - start);
                this.local_deliveries.incrementAndGet();
            }
        }
        catch (Exception e) {
            this.log.error(Util.getMessage("FailedDeliveringMessage"), e);
        }
    }

    protected Message copy(Message msg) {
        return msg.copy(true, (short)200, this.prots_above);
    }

    public void handleView(View view) {
        this.members = view.getMembers();
        List<Address> old_site_masters = this.site_masters;
        List<Address> new_site_masters = this.determineSiteMasters(view);
        boolean become_site_master = new_site_masters.contains(this.local_addr) && (old_site_masters == null || !old_site_masters.contains(this.local_addr));
        boolean cease_site_master = old_site_masters != null && old_site_masters.contains(this.local_addr) && !new_site_masters.contains(this.local_addr);
        this.site_masters = new_site_masters;
        if (become_site_master) {
            this.is_site_master = true;
            final String bridge_name = "_" + UUID.get(this.local_addr);
            if (this.relayer != null) {
                this.relayer.stop();
            }
            final Relayer tmp = this.relayer = new Relayer(this, this.log);
            if (this.async_relay_creation) {
                this.timer.execute(new Runnable(){

                    @Override
                    public void run() {
                        RELAY2.this.startRelayer(tmp, bridge_name);
                    }
                });
            } else {
                this.startRelayer(this.relayer, bridge_name);
            }
        } else if (cease_site_master) {
            this.is_site_master = false;
            this.log.trace(this.local_addr + ": ceased to be site master; closing bridges");
            if (this.relayer != null) {
                this.relayer.stop();
            }
        }
    }

    protected void startRelayer(Relayer rel, String bridge_name) {
        try {
            this.log.trace(this.local_addr + ": became site master; starting bridges");
            rel.start(this.site_config.getBridges(), bridge_name, this.site);
        }
        catch (Throwable t) {
            this.log.error(this.local_addr + ": failed starting relayer", t);
        }
    }

    protected List<Address> determineSiteMasters(View view) {
        Address tmp;
        ArrayList<Address> retval = new ArrayList<Address>(view.size());
        int selected = 0;
        for (Address member : view) {
            if (member instanceof ExtendedUUID && !((ExtendedUUID)member).isFlagSet((short)2) || selected++ >= this.max_site_masters) continue;
            retval.add(member);
        }
        if (retval.isEmpty() && (tmp = Util.getCoordinator(view)) != null) {
            retval.add(Util.getCoordinator(view));
        }
        return retval;
    }

    protected Address pickSiteMaster() {
        return Util.pickRandomElement(this.site_masters);
    }

    public static class Relay2Header
    extends Header {
        public static final byte DATA = 1;
        public static final byte SITE_UNREACHABLE = 2;
        public static final byte HOST_UNREACHABLE = 3;
        protected byte type;
        protected Address final_dest;
        protected Address original_sender;

        public Relay2Header() {
        }

        public Relay2Header(byte type, Address final_dest, Address original_sender) {
            this.type = type;
            this.final_dest = final_dest;
            this.original_sender = original_sender;
        }

        @Override
        public int size() {
            return 1 + Util.size(this.final_dest) + Util.size(this.original_sender);
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeByte(this.type);
            Util.writeAddress(this.final_dest, out);
            Util.writeAddress(this.original_sender, out);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.type = in.readByte();
            this.final_dest = Util.readAddress(in);
            this.original_sender = Util.readAddress(in);
        }

        @Override
        public String toString() {
            return Relay2Header.typeToString(this.type) + " [dest=" + this.final_dest + ", sender=" + this.original_sender + "]";
        }

        protected static String typeToString(byte type) {
            switch (type) {
                case 1: {
                    return "DATA";
                }
                case 2: {
                    return "SITE_UNREACHABLE";
                }
                case 3: {
                    return "HOST_UNREACHABLE";
                }
            }
            return "<unknown>";
        }
    }
}

