/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.network;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import org.jboss.as.network.ManagedBinding;
import org.jboss.as.network.ManagedSocketBinding;
import org.jboss.as.network.SocketBindingManager;

public class ManagedServerSocketBinding
extends ServerSocket
implements ManagedBinding {
    private final String name;
    private final SocketBindingManager socketBindings;
    private final boolean metrics;
    private volatile long acceptCount = 0L;

    ManagedServerSocketBinding(SocketBindingManager socketBindings) throws IOException {
        this(null, socketBindings, false);
    }

    ManagedServerSocketBinding(SocketBindingManager socketBindings, boolean metrics) throws IOException {
        this(null, socketBindings, metrics);
    }

    ManagedServerSocketBinding(String name, SocketBindingManager socketBindings) throws IOException {
        this(name, socketBindings, false);
    }

    ManagedServerSocketBinding(String name, SocketBindingManager socketBindings, boolean metrics) throws IOException {
        this.name = name;
        this.socketBindings = socketBindings;
        this.metrics = metrics;
    }

    @Override
    public String getSocketBindingName() {
        return this.name;
    }

    @Override
    public InetSocketAddress getBindAddress() {
        return (InetSocketAddress)InetSocketAddress.class.cast(this.getLocalSocketAddress());
    }

    @Override
    public void bind(SocketAddress endpoint, int backlog) throws IOException {
        super.bind(endpoint, backlog);
        if (this.name != null) {
            this.socketBindings.getNamedRegistry().registerBinding(this);
        } else {
            this.socketBindings.getUnnamedRegistry().registerBinding(this);
        }
    }

    @Override
    public Socket accept() throws IOException {
        Socket socket = this.metrics ? new ManagedSocketBinding(this.socketBindings.getUnnamedRegistry()) : new Socket();
        this.implAccept(socket);
        if (this.metrics) {
            ++this.acceptCount;
        }
        return socket;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.name != null) {
                this.socketBindings.getNamedRegistry().unregisterBinding(this);
            } else {
                this.socketBindings.getUnnamedRegistry().unregisterBinding(this);
            }
        }
        finally {
            super.close();
        }
    }

    public long getAcceptCount() {
        return this.acceptCount;
    }
}

