/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.pojo.descriptor;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.jboss.as.pojo.BeanState;
import org.jboss.as.pojo.descriptor.BaseBeanFactory;
import org.jboss.as.pojo.descriptor.BeanMetaDataConfig;
import org.jboss.as.pojo.descriptor.ConfigVisitor;
import org.jboss.as.pojo.descriptor.ConfigVisitorNode;
import org.jboss.as.pojo.descriptor.LifecycleConfig;
import org.jboss.as.pojo.descriptor.ModuleConfig;
import org.jboss.as.pojo.descriptor.PropertyConfig;
import org.jboss.as.pojo.descriptor.ValueConfig;

public class BeanFactoryMetaDataConfig
extends BeanMetaDataConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final BeanMetaDataConfig bean;

    public BeanFactoryMetaDataConfig(BeanMetaDataConfig bean) {
        this.bean = bean;
        this.setName(bean.getName());
        bean.setName(this.getName() + "_Bean");
        this.setBeanClass(BaseBeanFactory.class.getName());
        ModuleConfig moduleConfig = new ModuleConfig();
        moduleConfig.setModuleName("org.jboss.as.pojo");
        this.setModule(moduleConfig);
        PropertyConfig pc = new PropertyConfig();
        pc.setPropertyName("bmd");
        ValueConfig vc = new ValueConfig(){

            @Override
            protected Object getClassValue(Class<?> type) {
                return BeanFactoryMetaDataConfig.this.bean;
            }
        };
        pc.setValue(vc);
        this.setProperties(Collections.singleton(pc));
        LifecycleConfig ignoredLifecycle = new LifecycleConfig();
        ignoredLifecycle.setIgnored(true);
        this.setCreate(ignoredLifecycle);
        this.setStart(ignoredLifecycle);
        this.setStop(ignoredLifecycle);
        this.setDestroy(ignoredLifecycle);
    }

    @Override
    protected void addChildren(ConfigVisitor visitor, List<ConfigVisitorNode> nodes) {
        nodes.add(this.bean);
        BeanState state = visitor.getState();
        if (state == BeanState.NOT_INSTALLED) {
            nodes.add(this.getModule());
        }
        if (state == BeanState.INSTANTIATED) {
            nodes.addAll(this.getProperties());
        }
    }
}

