/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.exceptions.ParallelOperationException;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

public abstract class ParallelHotRodOperation<T, SUBOP extends HotRodOperation>
extends HotRodOperation {
    private static final Log log = LogFactory.getLog(ParallelHotRodOperation.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    protected final TransportFactory transportFactory;
    protected final CompletionService<T> completionService;

    protected ParallelHotRodOperation(Codec codec, TransportFactory transportFactory, byte[] cacheName, AtomicInteger topologyId, int flags, Configuration cfg, ExecutorService executorService) {
        super(codec, flags, cfg, cacheName, topologyId);
        this.transportFactory = transportFactory;
        this.completionService = new ExecutorCompletionService<T>(executorService);
    }

    public T execute() {
        List<SUBOP> operations = this.mapOperations();
        if (operations.isEmpty()) {
            return this.createCollector();
        }
        if (operations.size() == 1) {
            return this.executeSequential((HotRodOperation)operations.get(0));
        }
        return this.executeParallel(operations);
    }

    private T executeSequential(SUBOP subop) {
        T collector = this.createCollector();
        this.combine(collector, ((HotRodOperation)subop).execute());
        return collector;
    }

    private T executeParallel(List<SUBOP> operations) {
        HashSet<Future<T>> remainingTasks = new HashSet<Future<T>>(operations.size());
        for (HotRodOperation operation : operations) {
            remainingTasks.add(this.completionService.submit(() -> operation.execute()));
        }
        T collector = this.createCollector();
        for (int i = 0; i < operations.size(); ++i) {
            try {
                Future<T> result = this.completionService.take();
                this.combine(collector, result.get());
                remainingTasks.remove(result);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.cancelRemainingTasks(remainingTasks);
                throw new ParallelOperationException(e);
            }
            catch (RuntimeException | ExecutionException e) {
                this.cancelRemainingTasks(remainingTasks);
                throw new ParallelOperationException(e);
            }
        }
        return collector;
    }

    private void cancelRemainingTasks(Set<Future<T>> remainingTasks) {
        remainingTasks.forEach(task -> task.cancel(true));
    }

    protected abstract List<SUBOP> mapOperations();

    protected abstract T createCollector();

    protected abstract void combine(T var1, T var2);
}

