/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.util.ReadOnlySegmentAwareIterator;
import org.infinispan.util.AbstractDelegatingSet;

public class ReadOnlySegmentAwareSet<E>
extends AbstractDelegatingSet<E> {
    protected final Set<E> set;
    protected final ConsistentHash ch;
    protected final Set<Integer> allowedSegments;

    public ReadOnlySegmentAwareSet(Set<E> set, ConsistentHash ch, Set<Integer> allowedSegments) {
        this.set = Collections.unmodifiableSet(set);
        this.ch = ch;
        this.allowedSegments = allowedSegments;
    }

    @Override
    protected Set<E> delegate() {
        return this.set;
    }

    protected boolean valueAllowed(Object obj) {
        int segment = this.ch.getSegment(obj);
        return this.allowedSegments.contains(segment);
    }

    @Override
    public boolean contains(Object o) {
        if (this.valueAllowed(o)) {
            return super.contains(o);
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object obj : c) {
            if (!this.valueAllowed(obj) || super.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        Iterator<E> iter = this.iterator();
        return !iter.hasNext();
    }

    @Override
    public int size() {
        Iterator<E> iter = this.iterator();
        int count = 0;
        while (iter.hasNext()) {
            iter.next();
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<E> iterator() {
        return new ReadOnlySegmentAwareIterator(super.iterator(), this.ch, this.allowedSegments);
    }
}

