/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.status;

import java.util.LinkedList;
import java.util.List;
import org.infinispan.xsite.status.AbstractSiteStatusBuilder;
import org.infinispan.xsite.status.ContainerMixedSiteStatus;
import org.infinispan.xsite.status.SiteStatus;

public class ContainerSiteStatusBuilder
extends AbstractSiteStatusBuilder<String> {
    private final List<String> mixedCaches = new LinkedList<String>();

    public void mixedOn(String cacheName) {
        this.mixedCaches.add(cacheName);
    }

    public void addCacheName(String cacheName, SiteStatus status) {
        if (status.isOnline()) {
            this.onlineOn(cacheName);
        } else if (status.isOffline()) {
            this.offlineOn(cacheName);
        } else {
            this.mixedOn(cacheName);
        }
    }

    @Override
    protected boolean isOnline() {
        return super.isOnline() && this.mixedCaches.isEmpty();
    }

    @Override
    protected boolean isOffline() {
        return super.isOffline() && this.mixedCaches.isEmpty();
    }

    @Override
    protected SiteStatus createMixedStatus(List<String> onlineElements, List<String> offlineElements) {
        return new ContainerMixedSiteStatus(onlineElements, offlineElements, this.mixedCaches);
    }
}

