/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.bridge.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XASession;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionRolledbackException;
import javax.transaction.xa.XAResource;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.api.core.client.FailoverEventListener;
import org.apache.activemq.artemis.api.core.client.FailoverEventType;
import org.apache.activemq.artemis.jms.bridge.ActiveMQJMSBridgeLogger;
import org.apache.activemq.artemis.jms.bridge.ConnectionFactoryFactory;
import org.apache.activemq.artemis.jms.bridge.DestinationFactory;
import org.apache.activemq.artemis.jms.bridge.JMSBridge;
import org.apache.activemq.artemis.jms.bridge.JMSBridgeControl;
import org.apache.activemq.artemis.jms.bridge.QualityOfServiceMode;
import org.apache.activemq.artemis.jms.bridge.impl.JMSBridgeControlImpl;
import org.apache.activemq.artemis.jms.client.ActiveMQConnection;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;
import org.apache.activemq.artemis.jms.server.ActiveMQJMSServerBundle;
import org.apache.activemq.artemis.service.extensions.ServiceUtils;
import org.apache.activemq.artemis.service.extensions.xa.recovery.ActiveMQRegistry;
import org.apache.activemq.artemis.service.extensions.xa.recovery.XARecoveryConfig;
import org.apache.activemq.artemis.utils.DefaultSensitiveStringCodec;
import org.apache.activemq.artemis.utils.PasswordMaskingUtil;

public final class JMSBridgeImpl
implements JMSBridge {
    private static final String[] RESOURCE_RECOVERY_CLASS_NAMES = new String[]{"org.jboss.as.messaging.jms.AS7RecoveryRegistry"};
    private static boolean trace = ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled();
    private static final int TEN_YEARS = 315360000;
    private static final long DEFAULT_FAILOVER_TIMEOUT = 60000L;
    private final Object lock = new Object();
    private String sourceUsername;
    private String sourcePassword;
    private String targetUsername;
    private String targetPassword;
    private TransactionManager tm;
    private String selector;
    private long failureRetryInterval;
    private int maxRetries;
    private QualityOfServiceMode qualityOfServiceMode;
    private int maxBatchSize;
    private long maxBatchTime;
    private String subName;
    private String clientID;
    private volatile boolean addMessageIDInHeader;
    private boolean started;
    private final Object stoppingGuard = new Object();
    private boolean stopping = false;
    private final LinkedList<Message> messages = new LinkedList();
    private ConnectionFactoryFactory sourceCff;
    private ConnectionFactoryFactory targetCff;
    private DestinationFactory sourceDestinationFactory;
    private DestinationFactory targetDestinationFactory;
    private Connection sourceConn;
    private Connection targetConn;
    private Destination sourceDestination;
    private Destination targetDestination;
    private Session sourceSession;
    private Session targetSession;
    private MessageConsumer sourceConsumer;
    private MessageProducer targetProducer;
    private BatchTimeChecker timeChecker;
    private ExecutorService executor = this.createExecutor();
    private long batchExpiryTime;
    private boolean paused;
    private Transaction tx;
    private boolean failed;
    private boolean connectedSource = false;
    private boolean connectedTarget = false;
    private int forwardMode;
    private MBeanServer mbeanServer;
    private ObjectName objectName;
    private boolean useMaskedPassword = false;
    private String passwordCodec;
    private long failoverTimeout;
    private static final int FORWARD_MODE_XA = 0;
    private static final int FORWARD_MODE_LOCALTX = 1;
    private static final int FORWARD_MODE_NONTX = 2;
    private ActiveMQRegistry registry;
    private ClassLoader moduleTccl;

    public JMSBridgeImpl() {
    }

    public JMSBridgeImpl(ConnectionFactoryFactory sourceCff, ConnectionFactoryFactory targetCff, DestinationFactory sourceDestinationFactory, DestinationFactory targetDestinationFactory, String sourceUsername, String sourcePassword, String targetUsername, String targetPassword, String selector, long failureRetryInterval, int maxRetries, QualityOfServiceMode qosMode, int maxBatchSize, long maxBatchTime, String subName, String clientID, boolean addMessageIDInHeader) {
        this(sourceCff, targetCff, sourceDestinationFactory, targetDestinationFactory, sourceUsername, sourcePassword, targetUsername, targetPassword, selector, failureRetryInterval, maxRetries, qosMode, maxBatchSize, maxBatchTime, subName, clientID, addMessageIDInHeader, null, null);
    }

    public JMSBridgeImpl(ConnectionFactoryFactory sourceCff, ConnectionFactoryFactory targetCff, DestinationFactory sourceDestinationFactory, DestinationFactory targetDestinationFactory, String sourceUsername, String sourcePassword, String targetUsername, String targetPassword, String selector, long failureRetryInterval, int maxRetries, QualityOfServiceMode qosMode, int maxBatchSize, long maxBatchTime, String subName, String clientID, boolean addMessageIDInHeader, MBeanServer mbeanServer, String objectName) {
        this(sourceCff, targetCff, sourceDestinationFactory, targetDestinationFactory, sourceUsername, sourcePassword, targetUsername, targetPassword, selector, failureRetryInterval, maxRetries, qosMode, maxBatchSize, maxBatchTime, subName, clientID, addMessageIDInHeader, mbeanServer, objectName, 60000L);
    }

    public JMSBridgeImpl(ConnectionFactoryFactory sourceCff, ConnectionFactoryFactory targetCff, DestinationFactory sourceDestinationFactory, DestinationFactory targetDestinationFactory, String sourceUsername, String sourcePassword, String targetUsername, String targetPassword, String selector, long failureRetryInterval, int maxRetries, QualityOfServiceMode qosMode, int maxBatchSize, long maxBatchTime, String subName, String clientID, boolean addMessageIDInHeader, MBeanServer mbeanServer, String objectName, long failoverTimeout) {
        this();
        this.sourceCff = sourceCff;
        this.targetCff = targetCff;
        this.sourceDestinationFactory = sourceDestinationFactory;
        this.targetDestinationFactory = targetDestinationFactory;
        this.sourceUsername = sourceUsername;
        this.sourcePassword = sourcePassword;
        this.targetUsername = targetUsername;
        this.targetPassword = targetPassword;
        this.selector = selector;
        this.failureRetryInterval = failureRetryInterval;
        this.maxRetries = maxRetries;
        this.qualityOfServiceMode = qosMode;
        this.maxBatchSize = maxBatchSize;
        this.maxBatchTime = maxBatchTime;
        this.subName = subName;
        this.clientID = clientID;
        this.addMessageIDInHeader = addMessageIDInHeader;
        this.failoverTimeout = failoverTimeout;
        this.checkParams();
        if (mbeanServer != null) {
            if (objectName != null) {
                this.mbeanServer = mbeanServer;
                try {
                    JMSBridgeControlImpl controlBean = new JMSBridgeControlImpl(this);
                    this.objectName = ObjectName.getInstance(objectName);
                    StandardMBean mbean = new StandardMBean(controlBean, JMSBridgeControl.class);
                    mbeanServer.registerMBean(mbean, this.objectName);
                    ActiveMQJMSBridgeLogger.LOGGER.debug("Registered JMSBridge instance as: " + this.objectName.getCanonicalName());
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to register JMSBridge MBean", e);
                }
            } else {
                throw new IllegalArgumentException("objectName is required when specifying an MBeanServer");
            }
        }
        if (trace) {
            ActiveMQJMSBridgeLogger.LOGGER.trace("Created " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() throws Exception {
        boolean ok;
        Object object = this.stoppingGuard;
        synchronized (object) {
            this.stopping = false;
        }
        this.moduleTccl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        this.locateRecoveryRegistry();
        if (this.started) {
            ActiveMQJMSBridgeLogger.LOGGER.errorBridgeAlreadyStarted();
            return;
        }
        if (trace) {
            ActiveMQJMSBridgeLogger.LOGGER.trace("Starting " + this);
        }
        if (this.executor.isShutdown()) {
            this.executor = this.createExecutor();
        }
        this.initPasswords();
        this.checkParams();
        if (this.qualityOfServiceMode.equals((Object)QualityOfServiceMode.ONCE_AND_ONLY_ONCE) && this.sourceCff != this.targetCff) {
            if (this.tm == null) {
                this.tm = ServiceUtils.getTransactionManager();
            }
            if (this.tm == null) {
                ActiveMQJMSBridgeLogger.LOGGER.jmsBridgeTransactionManagerMissing(this.qualityOfServiceMode);
                throw new RuntimeException();
            }
            Transaction toResume = null;
            try {
                toResume = this.tm.suspend();
                ok = this.setupJMSObjects();
            }
            finally {
                if (toResume != null) {
                    this.tm.resume(toResume);
                }
            }
        } else {
            ok = this.setupJMSObjects();
        }
        if (ok) {
            this.connectedSource = true;
            this.connectedTarget = true;
            this.startSource();
        } else {
            ActiveMQJMSBridgeLogger.LOGGER.errorStartingBridge();
            this.handleFailureOnStartup();
        }
    }

    private void startSource() throws JMSException {
        this.sourceConn.start();
        this.started = true;
        if (this.maxBatchTime != -1L) {
            if (trace) {
                ActiveMQJMSBridgeLogger.LOGGER.trace("Starting time checker thread");
            }
            this.timeChecker = new BatchTimeChecker();
            this.executor.execute(this.timeChecker);
            this.batchExpiryTime = System.currentTimeMillis() + this.maxBatchTime;
            if (trace) {
                ActiveMQJMSBridgeLogger.LOGGER.trace("Started time checker thread");
            }
        }
        this.executor.execute(new SourceReceiver());
        if (trace) {
            ActiveMQJMSBridgeLogger.LOGGER.trace("Started " + this);
        }
    }

    private void initPasswords() throws ActiveMQException {
        if (this.useMaskedPassword) {
            DefaultSensitiveStringCodec codecInstance = new DefaultSensitiveStringCodec();
            if (this.passwordCodec != null) {
                codecInstance = PasswordMaskingUtil.getCodec((String)this.passwordCodec);
            }
            try {
                if (this.sourcePassword != null) {
                    this.sourcePassword = (String)codecInstance.decode((Object)this.sourcePassword);
                }
                if (this.targetPassword != null) {
                    this.targetPassword = (String)codecInstance.decode((Object)this.targetPassword);
                }
            }
            catch (Exception e) {
                throw ActiveMQJMSServerBundle.BUNDLE.errorDecodingPassword(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        Object object = this.stoppingGuard;
        synchronized (object) {
            if (this.stopping) {
                return;
            }
            this.stopping = true;
        }
        object = this;
        synchronized (object) {
            block27: {
                block26: {
                    if (trace) {
                        ActiveMQJMSBridgeLogger.LOGGER.trace("Stopping " + this);
                    }
                    if (!this.connectedSource && this.sourceConn != null) {
                        this.sourceConn.close();
                    }
                    if (!this.connectedTarget && this.targetConn != null) {
                        this.targetConn.close();
                    }
                    Object object2 = this.lock;
                    synchronized (object2) {
                        this.started = false;
                        this.executor.shutdownNow();
                    }
                    boolean ok = this.executor.awaitTermination(60L, TimeUnit.SECONDS);
                    if (!ok) {
                        throw new Exception("fail to stop JMS Bridge");
                    }
                    if (this.tx != null) {
                        block25: {
                            if (trace) {
                                ActiveMQJMSBridgeLogger.LOGGER.trace("Rolling back remaining tx");
                            }
                            try {
                                this.tx.rollback();
                            }
                            catch (Exception ignore) {
                                if (!trace) break block25;
                                ActiveMQJMSBridgeLogger.LOGGER.trace("Failed to rollback", ignore);
                            }
                        }
                        if (trace) {
                            ActiveMQJMSBridgeLogger.LOGGER.trace("Rolled back remaining tx");
                        }
                    }
                    try {
                        this.sourceConn.close();
                    }
                    catch (Exception ignore) {
                        if (!trace) break block26;
                        ActiveMQJMSBridgeLogger.LOGGER.trace("Failed to close source conn", ignore);
                    }
                }
                if (this.targetConn != null) {
                    try {
                        this.targetConn.close();
                    }
                    catch (Exception ignore) {
                        if (!trace) break block27;
                        ActiveMQJMSBridgeLogger.LOGGER.trace("Failed to close target conn", ignore);
                    }
                }
            }
            if (trace) {
                ActiveMQJMSBridgeLogger.LOGGER.trace("Stopped " + this);
            }
        }
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    public void destroy() {
        if (this.mbeanServer != null && this.objectName != null) {
            try {
                this.mbeanServer.unregisterMBean(this.objectName);
            }
            catch (Exception e) {
                ActiveMQJMSBridgeLogger.LOGGER.errorUnregisteringBridge(this.objectName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void pause() throws Exception {
        if (trace) {
            ActiveMQJMSBridgeLogger.LOGGER.trace("Pausing " + this);
        }
        Object object = this.lock;
        synchronized (object) {
            this.paused = true;
            this.sourceConn.stop();
        }
        if (trace) {
            ActiveMQJMSBridgeLogger.LOGGER.trace("Paused " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void resume() throws Exception {
        if (trace) {
            ActiveMQJMSBridgeLogger.LOGGER.trace("Resuming " + this);
        }
        Object object = this.lock;
        synchronized (object) {
            this.paused = false;
            this.sourceConn.start();
        }
        if (trace) {
            ActiveMQJMSBridgeLogger.LOGGER.trace("Resumed " + this);
        }
    }

    @Override
    public DestinationFactory getSourceDestinationFactory() {
        return this.sourceDestinationFactory;
    }

    @Override
    public void setSourceDestinationFactory(DestinationFactory dest) {
        this.checkBridgeNotStarted();
        JMSBridgeImpl.checkNotNull(dest, "TargetDestinationFactory");
        this.sourceDestinationFactory = dest;
    }

    @Override
    public DestinationFactory getTargetDestinationFactory() {
        return this.targetDestinationFactory;
    }

    @Override
    public void setTargetDestinationFactory(DestinationFactory dest) {
        this.checkBridgeNotStarted();
        JMSBridgeImpl.checkNotNull(dest, "TargetDestinationFactory");
        this.targetDestinationFactory = dest;
    }

    @Override
    public synchronized String getSourceUsername() {
        return this.sourceUsername;
    }

    @Override
    public synchronized void setSourceUsername(String name) {
        this.checkBridgeNotStarted();
        this.sourceUsername = name;
    }

    @Override
    public synchronized String getSourcePassword() {
        return this.sourcePassword;
    }

    @Override
    public synchronized void setSourcePassword(String pwd) {
        this.checkBridgeNotStarted();
        this.sourcePassword = pwd;
    }

    @Override
    public synchronized String getTargetUsername() {
        return this.targetUsername;
    }

    @Override
    public synchronized void setTargetUsername(String name) {
        this.checkBridgeNotStarted();
        this.targetUsername = name;
    }

    @Override
    public synchronized String getTargetPassword() {
        return this.targetPassword;
    }

    @Override
    public synchronized void setTargetPassword(String pwd) {
        this.checkBridgeNotStarted();
        this.targetPassword = pwd;
    }

    @Override
    public synchronized String getSelector() {
        return this.selector;
    }

    @Override
    public synchronized void setSelector(String selector) {
        this.checkBridgeNotStarted();
        this.selector = selector;
    }

    @Override
    public synchronized long getFailureRetryInterval() {
        return this.failureRetryInterval;
    }

    @Override
    public synchronized void setFailureRetryInterval(long interval) {
        this.checkBridgeNotStarted();
        if (interval < 1L) {
            throw new IllegalArgumentException("FailureRetryInterval must be >= 1");
        }
        this.failureRetryInterval = interval;
    }

    @Override
    public synchronized int getMaxRetries() {
        return this.maxRetries;
    }

    @Override
    public synchronized void setMaxRetries(int retries) {
        this.checkBridgeNotStarted();
        JMSBridgeImpl.checkValidValue(retries, "MaxRetries");
        this.maxRetries = retries;
    }

    @Override
    public synchronized QualityOfServiceMode getQualityOfServiceMode() {
        return this.qualityOfServiceMode;
    }

    @Override
    public synchronized void setQualityOfServiceMode(QualityOfServiceMode mode) {
        this.checkBridgeNotStarted();
        JMSBridgeImpl.checkNotNull((Object)mode, "QualityOfServiceMode");
        this.qualityOfServiceMode = mode;
    }

    @Override
    public synchronized int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    @Override
    public synchronized void setMaxBatchSize(int size) {
        this.checkBridgeNotStarted();
        JMSBridgeImpl.checkMaxBatchSize(size);
        this.maxBatchSize = size;
    }

    @Override
    public synchronized long getMaxBatchTime() {
        return this.maxBatchTime;
    }

    @Override
    public synchronized void setMaxBatchTime(long time) {
        this.checkBridgeNotStarted();
        JMSBridgeImpl.checkValidValue(time, "MaxBatchTime");
        this.maxBatchTime = time;
    }

    @Override
    public synchronized String getSubscriptionName() {
        return this.subName;
    }

    @Override
    public synchronized void setSubscriptionName(String subname) {
        this.checkBridgeNotStarted();
        this.subName = subname;
    }

    @Override
    public synchronized String getClientID() {
        return this.clientID;
    }

    @Override
    public synchronized void setClientID(String clientID) {
        this.checkBridgeNotStarted();
        this.clientID = clientID;
    }

    @Override
    public boolean isAddMessageIDInHeader() {
        return this.addMessageIDInHeader;
    }

    @Override
    public void setAddMessageIDInHeader(boolean value) {
        this.addMessageIDInHeader = value;
    }

    @Override
    public synchronized boolean isPaused() {
        return this.paused;
    }

    @Override
    public synchronized boolean isFailed() {
        return this.failed;
    }

    @Override
    public synchronized void setSourceConnectionFactoryFactory(ConnectionFactoryFactory cff) {
        this.checkBridgeNotStarted();
        JMSBridgeImpl.checkNotNull(cff, "SourceConnectionFactoryFactory");
        this.sourceCff = cff;
    }

    @Override
    public synchronized void setTargetConnectionFactoryFactory(ConnectionFactoryFactory cff) {
        this.checkBridgeNotStarted();
        JMSBridgeImpl.checkNotNull(cff, "TargetConnectionFactoryFactory");
        this.targetCff = cff;
    }

    @Override
    public void setTransactionManager(TransactionManager tm) {
        this.tm = tm;
    }

    private synchronized void checkParams() {
        JMSBridgeImpl.checkNotNull(this.sourceCff, "sourceCff");
        JMSBridgeImpl.checkNotNull(this.targetCff, "targetCff");
        JMSBridgeImpl.checkNotNull(this.sourceDestinationFactory, "sourceDestinationFactory");
        JMSBridgeImpl.checkNotNull(this.targetDestinationFactory, "targetDestinationFactory");
        JMSBridgeImpl.checkValidValue(this.failureRetryInterval, "failureRetryInterval");
        JMSBridgeImpl.checkValidValue(this.maxRetries, "maxRetries");
        if (this.failureRetryInterval == -1L && this.maxRetries > 0) {
            throw new IllegalArgumentException("If failureRetryInterval == -1 maxRetries must be set to -1");
        }
        JMSBridgeImpl.checkMaxBatchSize(this.maxBatchSize);
        JMSBridgeImpl.checkValidValue(this.maxBatchTime, "maxBatchTime");
        JMSBridgeImpl.checkNotNull((Object)this.qualityOfServiceMode, "qualityOfServiceMode");
    }

    private static void checkNotNull(Object obj, String name) {
        if (obj == null) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
    }

    private void checkBridgeNotStarted() {
        if (this.started) {
            throw new IllegalStateException("Cannot set bridge attributes while it is started");
        }
    }

    private static void checkValidValue(long value, String name) {
        if (value != -1L && value <= 0L) {
            throw new IllegalArgumentException(name + " must be > 0 or -1");
        }
    }

    private static void checkMaxBatchSize(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("maxBatchSize must be >= 1");
        }
    }

    private void enlistResources(Transaction tx) throws Exception {
        if (trace) {
            ActiveMQJMSBridgeLogger.LOGGER.trace("Enlisting resources in tx");
        }
        XAResource resSource = ((XASession)this.sourceSession).getXAResource();
        tx.enlistResource(resSource);
        XAResource resDest = ((XASession)this.targetSession).getXAResource();
        tx.enlistResource(resDest);
        if (trace) {
            ActiveMQJMSBridgeLogger.LOGGER.trace("Enlisted resources in tx");
        }
    }

    private void delistResources(Transaction tx) {
        block7: {
            block6: {
                if (trace) {
                    ActiveMQJMSBridgeLogger.LOGGER.trace("Delisting resources from tx");
                }
                XAResource resSource = ((XASession)this.sourceSession).getXAResource();
                try {
                    tx.delistResource(resSource, 0x4000000);
                }
                catch (Exception e) {
                    if (!trace) break block6;
                    ActiveMQJMSBridgeLogger.LOGGER.trace("Failed to delist source resource", e);
                }
            }
            XAResource resDest = ((XASession)this.targetSession).getXAResource();
            try {
                tx.delistResource(resDest, 0x4000000);
            }
            catch (Exception e) {
                if (!trace) break block7;
                ActiveMQJMSBridgeLogger.LOGGER.trace("Failed to delist target resource", e);
            }
        }
        if (trace) {
            ActiveMQJMSBridgeLogger.LOGGER.trace("Delisted resources from tx");
        }
    }

    private Transaction startTx() throws Exception {
        if (trace) {
            ActiveMQJMSBridgeLogger.LOGGER.trace("Starting JTA transaction");
        }
        if (this.tm == null) {
            this.tm = ServiceUtils.getTransactionManager();
        }
        this.tm.setTransactionTimeout(315360000);
        this.tm.begin();
        Transaction tx = this.tm.getTransaction();
        this.tm.suspend();
        if (trace) {
            ActiveMQJMSBridgeLogger.LOGGER.trace("Started JTA transaction");
        }
        return tx;
    }

    private Connection createConnection(String username, String password, ConnectionFactoryFactory cff, String clientID, boolean isXA, boolean isSource) throws Exception {
        ActiveMQConnectionFactory activeMQCF;
        XAConnection conn;
        Object cf = cff.createConnectionFactory();
        if (cf instanceof ActiveMQConnectionFactory && this.registry != null) {
            this.registry.register(XARecoveryConfig.newConfig((ActiveMQConnectionFactory)((ActiveMQConnectionFactory)cf), (String)username, (String)password, null));
        }
        if (this.qualityOfServiceMode == QualityOfServiceMode.ONCE_AND_ONLY_ONCE && !(cf instanceof XAConnectionFactory)) {
            throw new IllegalArgumentException("Connection factory must be XAConnectionFactory");
        }
        if (username == null) {
            if (isXA) {
                if (trace) {
                    ActiveMQJMSBridgeLogger.LOGGER.trace("Creating an XA connection");
                }
                conn = ((XAConnectionFactory)cf).createXAConnection();
            } else {
                if (trace) {
                    ActiveMQJMSBridgeLogger.LOGGER.trace("Creating a non XA connection");
                }
                conn = ((ConnectionFactory)cf).createConnection();
            }
        } else if (isXA) {
            if (trace) {
                ActiveMQJMSBridgeLogger.LOGGER.trace("Creating an XA connection");
            }
            conn = ((XAConnectionFactory)cf).createXAConnection(username, password);
        } else {
            if (trace) {
                ActiveMQJMSBridgeLogger.LOGGER.trace("Creating a non XA connection");
            }
            conn = ((ConnectionFactory)cf).createConnection(username, password);
        }
        if (clientID != null) {
            conn.setClientID(clientID);
        }
        boolean ha = false;
        BridgeFailoverListener failoverListener = null;
        if (conn instanceof ActiveMQConnection && (ha = (activeMQCF = (ActiveMQConnectionFactory)cf).isHA())) {
            ActiveMQConnection activeMQConn = (ActiveMQConnection)conn;
            failoverListener = new BridgeFailoverListener(isSource);
            activeMQConn.setFailoverListener((FailoverEventListener)failoverListener);
        }
        conn.setExceptionListener((ExceptionListener)new BridgeExceptionListener(ha, failoverListener, isSource));
        return conn;
    }

    private boolean setupJMSObjects() {
        try {
            this.forwardMode = this.sourceCff == this.targetCff ? 1 : (this.qualityOfServiceMode == QualityOfServiceMode.ONCE_AND_ONLY_ONCE ? 0 : 2);
            this.sourceDestination = this.sourceDestinationFactory.createDestination();
            this.targetDestination = this.targetDestinationFactory.createDestination();
            if (this.forwardMode == 1) {
                this.sourceConn = this.createConnection(this.sourceUsername, this.sourcePassword, this.sourceCff, this.clientID, false, true);
                this.sourceSession = this.sourceConn.createSession(true, 0);
            } else if (this.forwardMode == 0) {
                if (trace) {
                    ActiveMQJMSBridgeLogger.LOGGER.trace("Creating XA source session");
                }
                this.sourceConn = this.createConnection(this.sourceUsername, this.sourcePassword, this.sourceCff, this.clientID, true, true);
                this.sourceSession = ((XAConnection)this.sourceConn).createXASession();
            } else {
                if (trace) {
                    ActiveMQJMSBridgeLogger.LOGGER.trace("Creating non XA source session");
                }
                this.sourceConn = this.createConnection(this.sourceUsername, this.sourcePassword, this.sourceCff, this.clientID, false, true);
                this.sourceSession = this.qualityOfServiceMode == QualityOfServiceMode.AT_MOST_ONCE && this.maxBatchSize == 1 ? this.sourceConn.createSession(false, 1) : this.sourceConn.createSession(false, 2);
            }
            this.sourceConsumer = this.subName == null ? (this.selector == null ? this.sourceSession.createConsumer(this.sourceDestination) : this.sourceSession.createConsumer(this.sourceDestination, this.selector, false)) : (this.selector == null ? this.sourceSession.createDurableSubscriber((Topic)this.sourceDestination, this.subName) : this.sourceSession.createDurableSubscriber((Topic)this.sourceDestination, this.subName, this.selector, false));
            if (this.forwardMode == 1) {
                this.targetConn = this.sourceConn;
                this.targetSession = this.sourceSession;
            } else if (this.forwardMode == 0) {
                if (trace) {
                    ActiveMQJMSBridgeLogger.LOGGER.trace("Creating XA dest session");
                }
                this.targetConn = this.createConnection(this.targetUsername, this.targetPassword, this.targetCff, null, true, false);
                this.targetSession = ((XAConnection)this.targetConn).createXASession();
            } else {
                if (trace) {
                    ActiveMQJMSBridgeLogger.LOGGER.trace("Creating non XA dest session");
                }
                boolean transacted = this.maxBatchSize > 1;
                this.targetConn = this.createConnection(this.targetUsername, this.targetPassword, this.targetCff, null, false, false);
                this.targetSession = this.targetConn.createSession(transacted, transacted ? 0 : 1);
            }
            if (this.forwardMode == 0) {
                if (trace) {
                    ActiveMQJMSBridgeLogger.LOGGER.trace("Starting JTA transaction");
                }
                this.tx = this.startTx();
                this.enlistResources(this.tx);
            }
            this.targetProducer = this.targetSession.createProducer(null);
            return true;
        }
        catch (Exception e) {
            ActiveMQJMSBridgeLogger.LOGGER.bridgeConnectError(e);
            this.cleanup();
            return false;
        }
    }

    private void cleanup() {
        block16: {
            block15: {
                block14: {
                    block12: {
                        try {
                            this.sourceConn.stop();
                        }
                        catch (Throwable ignore) {
                            if (!trace) break block12;
                            ActiveMQJMSBridgeLogger.LOGGER.trace("Failed to stop source connection", ignore);
                        }
                    }
                    if (this.tx != null) {
                        block13: {
                            try {
                                this.delistResources(this.tx);
                            }
                            catch (Throwable ignore) {
                                if (!trace) break block13;
                                ActiveMQJMSBridgeLogger.LOGGER.trace("Failed to delist resources", ignore);
                            }
                        }
                        try {
                            this.tx.rollback();
                        }
                        catch (Throwable ignore) {
                            if (!trace) break block14;
                            ActiveMQJMSBridgeLogger.LOGGER.trace("Failed to rollback", ignore);
                        }
                    }
                }
                try {
                    this.sourceConn.close();
                }
                catch (Throwable ignore) {
                    if (!trace) break block15;
                    ActiveMQJMSBridgeLogger.LOGGER.trace("Failed to close source connection", ignore);
                }
            }
            try {
                if (this.targetConn != null) {
                    this.targetConn.close();
                }
            }
            catch (Throwable ignore) {
                if (!trace) break block16;
                ActiveMQJMSBridgeLogger.LOGGER.trace("Failed to close target connection", ignore);
            }
        }
    }

    private void pause(long interval) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < this.failureRetryInterval) {
            try {
                Thread.sleep(this.failureRetryInterval);
            }
            catch (InterruptedException ex) {}
        }
    }

    private boolean setupJMSObjectsWithRetry() {
        if (trace) {
            ActiveMQJMSBridgeLogger.LOGGER.trace("Setting up connections");
        }
        int count = 0;
        while (!this.stopping) {
            boolean ok = this.setupJMSObjects();
            if (ok) {
                return true;
            }
            if (this.maxRetries != -1 && ++count == this.maxRetries) break;
            ActiveMQJMSBridgeLogger.LOGGER.failedToSetUpBridge(this.failureRetryInterval);
            this.pause(this.failureRetryInterval);
        }
        return false;
    }

    private void sendBatch() {
        if (trace) {
            ActiveMQJMSBridgeLogger.LOGGER.trace("Sending batch of " + this.messages.size() + " messages");
        }
        if (this.paused) {
            if (trace) {
                ActiveMQJMSBridgeLogger.LOGGER.trace("Paused, so not sending now");
            }
            return;
        }
        if (this.forwardMode == 1) {
            this.sendBatchLocalTx();
        } else if (this.forwardMode == 0) {
            this.sendBatchXA();
        } else {
            this.sendBatchNonTransacted();
        }
    }

    private void sendBatchNonTransacted() {
        try {
            boolean exHappened;
            if (this.qualityOfServiceMode == QualityOfServiceMode.ONCE_AND_ONLY_ONCE || this.qualityOfServiceMode == QualityOfServiceMode.AT_MOST_ONCE && this.maxBatchSize > 1) {
                if (trace) {
                    ActiveMQJMSBridgeLogger.LOGGER.trace("Client acking source session");
                }
                this.messages.getLast().acknowledge();
                if (trace) {
                    ActiveMQJMSBridgeLogger.LOGGER.trace("Client acked source session");
                }
            }
            do {
                exHappened = false;
                try {
                    this.sendMessages();
                }
                catch (TransactionRolledbackException e) {
                    ActiveMQJMSBridgeLogger.LOGGER.warn(e.getMessage() + ", retrying TX", e);
                    exHappened = true;
                }
            } while (exHappened);
            if (this.maxBatchSize > 1) {
                if (trace) {
                    ActiveMQJMSBridgeLogger.LOGGER.trace("Committing target session");
                }
                this.targetSession.commit();
                if (trace) {
                    ActiveMQJMSBridgeLogger.LOGGER.trace("Committed target session");
                }
            }
            if (this.qualityOfServiceMode == QualityOfServiceMode.DUPLICATES_OK) {
                if (trace) {
                    ActiveMQJMSBridgeLogger.LOGGER.trace("Client acking source session");
                }
                this.messages.getLast().acknowledge();
                if (trace) {
                    ActiveMQJMSBridgeLogger.LOGGER.trace("Client acked source session");
                }
            }
        }
        catch (Exception e) {
            if (!this.stopping) {
                ActiveMQJMSBridgeLogger.LOGGER.bridgeAckError(e);
            }
            if (this.connectedSource) {
                try {
                    this.sourceSession.recover();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        finally {
            this.messages.clear();
        }
    }

    private void sendBatchXA() {
        try {
            this.sendMessages();
            this.delistResources(this.tx);
            if (trace) {
                ActiveMQJMSBridgeLogger.LOGGER.trace("Committing JTA transaction");
            }
            this.tx.commit();
            if (trace) {
                ActiveMQJMSBridgeLogger.LOGGER.trace("Committed JTA transaction");
            }
        }
        catch (Exception e) {
            try {
                this.tx.rollback();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ActiveMQJMSBridgeLogger.LOGGER.bridgeAckError(e);
        }
        finally {
            try {
                this.tx = this.startTx();
                this.enlistResources(this.tx);
                this.messages.clear();
            }
            catch (Exception e) {
                ActiveMQJMSBridgeLogger.LOGGER.bridgeAckError(e);
                this.handleFailureOnSend();
            }
        }
    }

    private void sendBatchLocalTx() {
        try {
            this.sendMessages();
            if (trace) {
                ActiveMQJMSBridgeLogger.LOGGER.trace("Committing source session");
            }
            this.sourceSession.commit();
            if (trace) {
                ActiveMQJMSBridgeLogger.LOGGER.trace("Committed source session");
            }
        }
        catch (Exception e) {
            ActiveMQJMSBridgeLogger.LOGGER.bridgeAckError(e);
            try {
                this.sourceSession.rollback();
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            try {
                this.targetSession.rollback();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        finally {
            this.messages.clear();
        }
    }

    private void sendMessages() throws Exception {
        Iterator iter = this.messages.iterator();
        Message msg = null;
        while (iter.hasNext()) {
            long timeToLive;
            msg = (Message)iter.next();
            if (this.addMessageIDInHeader) {
                this.addMessageIDInHeader(msg);
            }
            if (trace) {
                ActiveMQJMSBridgeLogger.LOGGER.trace("Sending message " + msg);
            }
            if ((timeToLive = msg.getJMSExpiration()) != 0L && (timeToLive -= System.currentTimeMillis()) <= 0L) {
                timeToLive = 1L;
            }
            this.targetProducer.send(this.targetDestination, msg, msg.getJMSDeliveryMode(), msg.getJMSPriority(), timeToLive);
            if (!trace) continue;
            ActiveMQJMSBridgeLogger.LOGGER.trace("Sent message " + msg);
        }
    }

    private void handleFailureOnSend() {
        this.handleFailure(new FailureHandler());
    }

    private void handleFailureOnStartup() {
        this.handleFailure(new StartupFailureHandler());
    }

    private void handleFailure(Runnable failureHandler) {
        this.failed = true;
        this.executor.execute(failureHandler);
    }

    private void addMessageIDInHeader(Message msg) throws Exception {
        if (trace) {
            ActiveMQJMSBridgeLogger.LOGGER.trace("Adding old message id in Message header");
        }
        JMSBridgeImpl.copyProperties(msg);
        String val = null;
        val = msg.getStringProperty("AMQ_BRIDGE_MSG_ID_LIST");
        if (val == null) {
            val = msg.getJMSMessageID();
        } else {
            StringBuffer sb = new StringBuffer(val);
            sb.append(",").append(msg.getJMSMessageID());
            val = sb.toString();
        }
        msg.setStringProperty("AMQ_BRIDGE_MSG_ID_LIST", val);
    }

    private static void copyProperties(Message msg) throws JMSException {
        Enumeration en = msg.getPropertyNames();
        HashMap<String, Object> oldProps = null;
        while (en.hasMoreElements()) {
            String propName = (String)en.nextElement();
            if (oldProps == null) {
                oldProps = new HashMap<String, Object>();
            }
            oldProps.put(propName, msg.getObjectProperty(propName));
        }
        msg.clearProperties();
        if (oldProps != null) {
            for (Map.Entry entry : oldProps.entrySet()) {
                String propName = (String)entry.getKey();
                Object val = entry.getValue();
                if (!(val instanceof byte[])) {
                    msg.setObjectProperty(propName, entry.getValue());
                    continue;
                }
                if (!(msg instanceof ActiveMQMessage)) continue;
                ((ActiveMQMessage)msg).getCoreMessage().putBytesProperty(propName, (byte[])val);
            }
        }
    }

    private ExecutorService createExecutor() {
        ExecutorService service = Executors.newFixedThreadPool(3, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                final Thread thr = new Thread(r);
                if (JMSBridgeImpl.this.moduleTccl != null) {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            thr.setContextClassLoader(JMSBridgeImpl.this.moduleTccl);
                            return null;
                        }
                    });
                }
                return thr;
            }
        });
        return service;
    }

    private void locateRecoveryRegistry() {
        if (this.registry == null) {
            for (String locatorClasse : RESOURCE_RECOVERY_CLASS_NAMES) {
                try {
                    ServiceLoader<ActiveMQRegistry> sl = ServiceLoader.load(ActiveMQRegistry.class);
                    if (sl.iterator().hasNext()) {
                        this.registry = sl.iterator().next();
                    }
                }
                catch (Throwable e) {
                    ActiveMQJMSBridgeLogger.LOGGER.debug("unable to load  recovery registry " + locatorClasse, e);
                }
                if (this.registry != null) break;
            }
            if (this.registry != null) {
                ActiveMQJMSBridgeLogger.LOGGER.debug("Recovery Registry located = " + this.registry);
            }
        }
    }

    @Override
    public boolean isUseMaskedPassword() {
        return this.useMaskedPassword;
    }

    @Override
    public void setUseMaskedPassword(boolean maskPassword) {
        this.useMaskedPassword = maskPassword;
    }

    @Override
    public String getPasswordCodec() {
        return this.passwordCodec;
    }

    @Override
    public void setPasswordCodec(String passwordCodec) {
        this.passwordCodec = passwordCodec;
    }

    public long getFailoverTimeout() {
        return this.failoverTimeout;
    }

    public void setFailoverTimeout(long failoverTimeout) {
        this.failoverTimeout = failoverTimeout;
    }

    private class BridgeFailoverListener
    implements FailoverEventListener {
        private final boolean isSource;
        volatile FailoverEventType lastEvent;

        public BridgeFailoverListener(boolean isSource) {
            this.isSource = isSource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void failoverEvent(FailoverEventType eventType) {
            BridgeFailoverListener bridgeFailoverListener = this;
            synchronized (bridgeFailoverListener) {
                this.lastEvent = eventType;
                if (eventType == FailoverEventType.FAILURE_DETECTED) {
                    if (this.isSource) {
                        JMSBridgeImpl.this.connectedSource = false;
                    } else {
                        JMSBridgeImpl.this.connectedTarget = false;
                    }
                }
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitForFailover() {
            long toWait = JMSBridgeImpl.this.failoverTimeout;
            long start = 0L;
            long waited = 0L;
            boolean timedOut = false;
            FailoverEventType result = null;
            BridgeFailoverListener bridgeFailoverListener = this;
            synchronized (bridgeFailoverListener) {
                while (this.lastEvent == null || this.lastEvent == FailoverEventType.FAILURE_DETECTED) {
                    try {
                        if (toWait <= 0L) {
                            timedOut = true;
                            break;
                        }
                        start = System.currentTimeMillis();
                        this.wait(toWait);
                    }
                    catch (InterruptedException e) {}
                    continue;
                    finally {
                        waited = System.currentTimeMillis() - start;
                        toWait = JMSBridgeImpl.this.failoverTimeout - waited;
                    }
                }
                result = this.lastEvent;
                this.lastEvent = null;
            }
            if (timedOut) {
                ActiveMQJMSBridgeLogger.LOGGER.debug("Timed out waiting for failover completion " + this);
                return false;
            }
            if (result == FailoverEventType.FAILOVER_COMPLETED) {
                if (this.isSource) {
                    JMSBridgeImpl.this.connectedSource = true;
                } else {
                    JMSBridgeImpl.this.connectedTarget = true;
                }
                return true;
            }
            return false;
        }
    }

    private class BridgeExceptionListener
    implements ExceptionListener {
        boolean ha;
        BridgeFailoverListener failoverListener;
        private final boolean isSource;

        public BridgeExceptionListener(boolean ha, BridgeFailoverListener failoverListener, boolean isSource) {
            this.ha = ha;
            this.failoverListener = failoverListener;
            this.isSource = isSource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onException(JMSException e) {
            if (JMSBridgeImpl.this.stopping) {
                return;
            }
            ActiveMQJMSBridgeLogger.LOGGER.bridgeFailure((Exception)e);
            if (this.isSource) {
                JMSBridgeImpl.this.connectedSource = false;
            } else {
                JMSBridgeImpl.this.connectedTarget = false;
            }
            Object object = JMSBridgeImpl.this.lock;
            synchronized (object) {
                if (JMSBridgeImpl.this.stopping) {
                    return;
                }
                if (JMSBridgeImpl.this.failed) {
                    if (trace) {
                        ActiveMQJMSBridgeLogger.LOGGER.trace("Failure recovery already in progress");
                    }
                } else {
                    boolean shouldHandleFailure = true;
                    if (this.ha) {
                        boolean bl = shouldHandleFailure = !this.failoverListener.waitForFailover();
                    }
                    if (shouldHandleFailure) {
                        JMSBridgeImpl.this.handleFailure(new FailureHandler());
                    }
                }
            }
        }
    }

    private class BatchTimeChecker
    implements Runnable {
        private BatchTimeChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            if (trace) {
                ActiveMQJMSBridgeLogger.LOGGER.trace(this + " running");
            }
            Object object = JMSBridgeImpl.this.lock;
            synchronized (object) {
                while (JMSBridgeImpl.this.started) {
                    long toWait = JMSBridgeImpl.this.batchExpiryTime - System.currentTimeMillis();
                    if (toWait <= 0L) {
                        if (trace) {
                            ActiveMQJMSBridgeLogger.LOGGER.trace(this + " waited enough");
                        }
                        Object object2 = JMSBridgeImpl.this.lock;
                        synchronized (object2) {
                            if (!JMSBridgeImpl.this.failed && !JMSBridgeImpl.this.messages.isEmpty()) {
                                if (trace) {
                                    ActiveMQJMSBridgeLogger.LOGGER.trace(this + " got some messages so sending batch");
                                }
                                JMSBridgeImpl.this.sendBatch();
                                if (trace) {
                                    ActiveMQJMSBridgeLogger.LOGGER.trace(this + " sent batch");
                                }
                            }
                        }
                        JMSBridgeImpl.this.batchExpiryTime = System.currentTimeMillis() + JMSBridgeImpl.this.maxBatchTime;
                        continue;
                    }
                    try {
                        if (trace) {
                            ActiveMQJMSBridgeLogger.LOGGER.trace(this + " waiting for " + toWait);
                        }
                        JMSBridgeImpl.this.lock.wait(toWait);
                        if (!trace) continue;
                        ActiveMQJMSBridgeLogger.LOGGER.trace(this + " woke up");
                    }
                    catch (InterruptedException e) {
                        if (trace) {
                            ActiveMQJMSBridgeLogger.LOGGER.trace(this + " thread was interrupted");
                        }
                        if (!JMSBridgeImpl.this.stopping) throw new ActiveMQInterruptedException((Throwable)e);
                        return;
                    }
                }
                return;
            }
        }
    }

    private class StartupFailureHandler
    extends FailureHandler {
        private StartupFailureHandler() {
        }

        @Override
        protected void failed() {
            ActiveMQJMSBridgeLogger.LOGGER.bridgeNotStarted();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void succeeded() {
            ActiveMQJMSBridgeLogger.LOGGER.bridgeConnected();
            Object object = JMSBridgeImpl.this.lock;
            synchronized (object) {
                JMSBridgeImpl.this.connectedSource = true;
                JMSBridgeImpl.this.connectedTarget = true;
                JMSBridgeImpl.this.failed = false;
                JMSBridgeImpl.this.started = true;
                try {
                    JMSBridgeImpl.this.startSource();
                }
                catch (JMSException e) {
                    ActiveMQJMSBridgeLogger.LOGGER.jmsBridgeSrcConnectError((Exception)((Object)e));
                }
            }
        }
    }

    private class FailureHandler
    implements Runnable {
        private FailureHandler() {
        }

        protected void startSourceConnection() {
            try {
                JMSBridgeImpl.this.sourceConn.start();
            }
            catch (JMSException e) {
                ActiveMQJMSBridgeLogger.LOGGER.jmsBridgeSrcConnectError((Exception)((Object)e));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void succeeded() {
            ActiveMQJMSBridgeLogger.LOGGER.bridgeReconnected();
            JMSBridgeImpl.this.connectedSource = true;
            JMSBridgeImpl.this.connectedTarget = true;
            Object object = JMSBridgeImpl.this.lock;
            synchronized (object) {
                JMSBridgeImpl.this.failed = false;
                this.startSourceConnection();
            }
        }

        protected void failed() {
            ActiveMQJMSBridgeLogger.LOGGER.errorConnectingBridge();
            try {
                JMSBridgeImpl.this.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            if (trace) {
                ActiveMQJMSBridgeLogger.LOGGER.trace("Failure handler running");
            }
            JMSBridgeImpl.this.messages.clear();
            JMSBridgeImpl.this.cleanup();
            boolean ok = false;
            if (JMSBridgeImpl.this.maxRetries > 0 || JMSBridgeImpl.this.maxRetries == -1) {
                ActiveMQJMSBridgeLogger.LOGGER.bridgeRetry(JMSBridgeImpl.this.failureRetryInterval);
                JMSBridgeImpl.this.pause(JMSBridgeImpl.this.failureRetryInterval);
                ok = JMSBridgeImpl.this.setupJMSObjectsWithRetry();
            }
            if (!ok) {
                this.failed();
            } else {
                this.succeeded();
            }
        }
    }

    private final class SourceReceiver
    extends Thread {
        SourceReceiver() {
            super("jmsbridge-source-receiver-thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (JMSBridgeImpl.this.started) {
                if (JMSBridgeImpl.this.stopping) {
                    return;
                }
                Object object = JMSBridgeImpl.this.lock;
                synchronized (object) {
                    Message msg;
                    block22: {
                        if (JMSBridgeImpl.this.paused || JMSBridgeImpl.this.failed) {
                            try {
                                JMSBridgeImpl.this.lock.wait(500L);
                            }
                            catch (InterruptedException e) {
                                if (JMSBridgeImpl.this.stopping) {
                                    return;
                                }
                                throw new ActiveMQInterruptedException((Throwable)e);
                            }
                        }
                        msg = null;
                        try {
                            msg = JMSBridgeImpl.this.sourceConsumer.receive(1000L);
                            if (msg instanceof ActiveMQMessage) {
                                ((ActiveMQMessage)msg).checkBuffer();
                            }
                        }
                        catch (JMSException jmse) {
                            if (!trace) break block22;
                            ActiveMQJMSBridgeLogger.LOGGER.trace(this + " exception while receiving a message", jmse);
                        }
                    }
                    if (msg == null) {
                        try {
                            JMSBridgeImpl.this.lock.wait(500L);
                        }
                        catch (InterruptedException e) {
                            if (trace) {
                                ActiveMQJMSBridgeLogger.LOGGER.trace(this + " thread was interrupted");
                            }
                            if (JMSBridgeImpl.this.stopping) {
                                return;
                            }
                            throw new ActiveMQInterruptedException((Throwable)e);
                        }
                    }
                    if (trace) {
                        ActiveMQJMSBridgeLogger.LOGGER.trace(this + " received message " + msg);
                    }
                    JMSBridgeImpl.this.messages.add(msg);
                    JMSBridgeImpl.this.batchExpiryTime = System.currentTimeMillis() + JMSBridgeImpl.this.maxBatchTime;
                    if (trace) {
                        ActiveMQJMSBridgeLogger.LOGGER.trace(this + " rescheduled batchExpiryTime to " + JMSBridgeImpl.this.batchExpiryTime);
                    }
                    if (JMSBridgeImpl.this.maxBatchSize != -1 && JMSBridgeImpl.this.messages.size() >= JMSBridgeImpl.this.maxBatchSize) {
                        if (trace) {
                            ActiveMQJMSBridgeLogger.LOGGER.trace(this + " maxBatchSize has been reached so sending batch");
                        }
                        JMSBridgeImpl.this.sendBatch();
                        if (trace) {
                            ActiveMQJMSBridgeLogger.LOGGER.trace(this + " sent batch");
                        }
                    }
                }
            }
        }
    }
}

