/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.infinispan.task;

import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.server.infinispan.task.ServerTaskRegistry;
import org.infinispan.server.infinispan.task.ServerTaskWrapper;
import org.infinispan.tasks.TaskContext;

public class DistributedServerTask<T>
implements Serializable,
DistributedCallable<Object, Object, T> {
    private final Optional<Map<String, ?>> parameters;
    private final String taskName;
    private transient ServerTaskRegistry taskRegistry;
    private transient Marshaller marshaller;
    private transient Cache<Object, Object> cache;

    public DistributedServerTask(String taskName, Optional<Map<String, ?>> parameters) {
        this.taskName = taskName;
        this.parameters = parameters;
    }

    public void setEnvironment(Cache<Object, Object> cache, Set<Object> inputKeys) {
        this.cache = cache;
        GlobalComponentRegistry componentRegistry = cache.getCacheManager().getGlobalComponentRegistry();
        this.taskRegistry = (ServerTaskRegistry)componentRegistry.getComponent(ServerTaskRegistry.class);
        this.marshaller = (Marshaller)componentRegistry.getComponent(StreamingMarshaller.class, "org.infinispan.marshaller.global");
    }

    public T call() throws Exception {
        ServerTaskWrapper task = this.taskRegistry.getTask(this.taskName);
        task.inject(this.prepareContext());
        return task.run();
    }

    private TaskContext prepareContext() {
        TaskContext context = new TaskContext();
        if (this.parameters.isPresent()) {
            context.parameters(this.parameters.get());
        }
        if (this.cache != null) {
            context.cache(this.cache);
        }
        if (this.marshaller != null) {
            context.marshaller(this.marshaller);
        }
        return context;
    }
}

