/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.infinispan.server.infinispan.spi.service.CacheContainerServiceName;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResource;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;

public class GetProtobufSchemaHandler
extends AbstractRuntimeOnlyHandler {
    public static final GetProtobufSchemaHandler INSTANCE = new GetProtobufSchemaHandler();

    public void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String cacheContainerName = address.getElement(address.size() - 1).getValue();
        ServiceController controller = context.getServiceRegistry(false).getService(CacheContainerServiceName.CACHE_CONTAINER.getServiceName(cacheContainerName));
        EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)controller.getValue();
        ProtobufMetadataManager protoManager = (ProtobufMetadataManager)cacheManager.getGlobalComponentRegistry().getComponent(ProtobufMetadataManager.class);
        if (protoManager != null) {
            try {
                ModelNode name = operation.require(CacheContainerResource.PROTO_NAME.getName());
                this.validateParameters(name);
                context.getResult().set(new ModelNode().set(protoManager.getProtofile(name.asString())));
            }
            catch (Exception e) {
                throw new OperationFailedException(InfinispanMessages.MESSAGES.failedToInvokeOperation(e.getLocalizedMessage()));
            }
        }
    }

    private void validateParameters(ModelNode name) {
        if (name.getType() != ModelType.STRING) {
            throw InfinispanMessages.MESSAGES.invalidParameterType(CacheContainerResource.PROTO_NAME.getName(), ModelType.STRING.toString());
        }
    }
}

