/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.global.QueryOperationHandler;
import org.jboss.as.controller.registry.OperationTransformerRegistry;
import org.jboss.as.controller.transform.CompositeOperationTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.PathAddressTransformer;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.controller.transform.TransformerEntry;
import org.jboss.as.controller.transform.TransformerRegistry;

public class TransformationTargetImpl
implements TransformationTarget {
    private final String hostName;
    private final ModelVersion version;
    private final TransformerRegistry transformerRegistry;
    private final Map<String, ModelVersion> subsystemVersions = Collections.synchronizedMap(new HashMap());
    private final OperationTransformerRegistry registry;
    private final TransformationTarget.TransformationTargetType type;
    private final OperationTransformerRegistry.PlaceholderResolver placeholderResolver;
    private final boolean ignoreUnaffectedConfig;

    private TransformationTargetImpl(String hostName, TransformerRegistry transformerRegistry, ModelVersion version, Map<PathAddress, ModelVersion> subsystemVersions, OperationTransformerRegistry transformers, TransformationTarget.TransformationTargetType type, OperationTransformerRegistry.PlaceholderResolver placeholderResolver, boolean ignoreUnaffectedConfig) {
        this.version = version;
        this.hostName = hostName;
        this.transformerRegistry = transformerRegistry;
        for (Map.Entry<PathAddress, ModelVersion> p : subsystemVersions.entrySet()) {
            String name = p.getKey().getLastElement().getValue();
            this.subsystemVersions.put(name, p.getValue());
        }
        this.registry = transformers;
        this.type = type;
        this.placeholderResolver = placeholderResolver;
        this.ignoreUnaffectedConfig = ignoreUnaffectedConfig;
    }

    private TransformationTargetImpl(TransformationTargetImpl target, OperationTransformerRegistry.PlaceholderResolver placeholderResolver) {
        this.version = target.version;
        this.hostName = target.hostName;
        this.transformerRegistry = target.transformerRegistry;
        this.subsystemVersions.putAll(target.subsystemVersions);
        this.registry = target.registry;
        this.type = target.type;
        this.placeholderResolver = placeholderResolver;
        this.ignoreUnaffectedConfig = false;
    }

    public static TransformationTarget createLocal() {
        TransformerRegistry registry = new TransformerRegistry();
        OperationTransformerRegistry r2 = registry.resolveHost(ModelVersion.create(0), new HashMap<PathAddress, ModelVersion>());
        return new TransformationTargetImpl(null, registry, ModelVersion.create(0), new HashMap<PathAddress, ModelVersion>(), r2, TransformationTarget.TransformationTargetType.SERVER, null, false);
    }

    public static TransformationTargetImpl create(String hostName, TransformerRegistry transformerRegistry, ModelVersion version, Map<PathAddress, ModelVersion> subsystems, TransformationTarget.TransformationTargetType type, boolean ignoreUnaffectedConfig) {
        OperationTransformerRegistry registry;
        switch (type) {
            case SERVER: {
                registry = transformerRegistry.resolveServer(version, subsystems);
                break;
            }
            default: {
                registry = transformerRegistry.resolveHost(version, subsystems);
            }
        }
        return new TransformationTargetImpl(hostName, transformerRegistry, version, subsystems, registry, type, null, ignoreUnaffectedConfig);
    }

    TransformationTargetImpl copyWithplaceholderResolver(OperationTransformerRegistry.PlaceholderResolver placeholderResolver) {
        return new TransformationTargetImpl(this, placeholderResolver);
    }

    @Override
    public ModelVersion getVersion() {
        return this.version;
    }

    @Override
    public ModelVersion getSubsystemVersion(String subsystemName) {
        return this.subsystemVersions.get(subsystemName);
    }

    @Override
    public ResourceTransformer resolveTransformer(ResourceTransformationContext context, PathAddress address) {
        if (this.ignoreResourceTransformation(context, address)) {
            return ResourceTransformer.DISCARD;
        }
        OperationTransformerRegistry.ResourceTransformerEntry entry = this.registry.resolveResourceTransformer(address, this.placeholderResolver);
        if (entry == null) {
            return ResourceTransformer.DEFAULT;
        }
        return entry.getTransformer();
    }

    @Override
    public TransformerEntry getTransformerEntry(TransformationContext context, PathAddress address) {
        if (this.ignoreResourceTransformation((ResourceTransformationContext)context, address)) {
            return TransformerEntry.DISCARD;
        }
        return this.registry.getTransformerEntry(address, this.placeholderResolver);
    }

    @Override
    public List<PathAddressTransformer> getPathTransformation(PathAddress address) {
        return this.registry.getPathTransformations(address, this.placeholderResolver);
    }

    @Override
    public OperationTransformer resolveTransformer(TransformationContext context, PathAddress address, String operationName) {
        if (address.size() == 0 && "composite".equals(operationName)) {
            return new CompositeOperationTransformer();
        }
        if (this.version.getMajor() < 3 && "query".equals(operationName)) {
            return QueryOperationHandler.TRANSFORMER;
        }
        OperationTransformerRegistry.OperationTransformerEntry entry = this.registry.resolveOperationTransformer(address, operationName, this.placeholderResolver);
        return entry.getTransformer();
    }

    @Override
    public void addSubsystemVersion(String subsystemName, int majorVersion, int minorVersion) {
        this.addSubsystemVersion(subsystemName, ModelVersion.create(majorVersion, minorVersion));
    }

    @Override
    public void addSubsystemVersion(String subsystemName, ModelVersion version) {
        this.subsystemVersions.put(subsystemName, version);
        this.transformerRegistry.addSubsystem(this.registry, subsystemName, version);
    }

    @Override
    public TransformationTarget.TransformationTargetType getTargetType() {
        return this.type;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public boolean isIgnoredResourceListAvailableAtRegistration() {
        return this.version.getMajor() >= 1 && this.version.getMinor() >= 4;
    }

    @Override
    public boolean isIgnoreUnaffectedConfig() {
        return false;
    }

    private boolean ignoreResourceTransformation(ResourceTransformationContext context, PathAddress address) {
        return context.isResourceTransformationIgnored(address);
    }
}

